/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.authorize;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.SpontaneousScopeService;
import org.gluu.oxauth.service.external.ExternalSpontaneousScopeService;
import org.gluu.oxauth.service.external.context.SpontaneousScopeExternalContext;
import org.slf4j.Logger;

@Stateless
@Named(value="scopeChecker")
public class ScopeChecker {
    @Inject
    private Logger log;
    @Inject
    private ScopeService scopeService;
    @Inject
    private SpontaneousScopeService spontaneousScopeService;
    @Inject
    private ExternalSpontaneousScopeService externalSpontaneousScopeService;

    public Set<String> checkScopesPolicy(Client client, String scope) {
        if (StringUtils.isBlank((String)scope)) {
            return Sets.newHashSet();
        }
        return this.checkScopesPolicy(client, Arrays.asList(scope.split(" ")));
    }

    public Set<String> checkScopesPolicy(Client client, List<String> scopesRequested) {
        this.log.debug("Checking scopes policy for: " + scopesRequested);
        HashSet<String> grantedScopes = new HashSet<String>();
        if (scopesRequested == null || scopesRequested.isEmpty() || client == null) {
            return grantedScopes;
        }
        String[] scopesAllowed = client.getScopes() != null ? client.getScopes() : new String[]{};
        for (String scopeRequested : scopesRequested) {
            if (StringUtils.isBlank((String)scopeRequested)) continue;
            List<String> scopesAllowedIds = this.scopeService.getScopeIdsByDns(Arrays.asList(scopesAllowed));
            if (scopesAllowedIds.contains(scopeRequested)) {
                grantedScopes.add(scopeRequested);
                continue;
            }
            if (!this.spontaneousScopeService.isAllowedBySpontaneousScopes(client, scopeRequested)) continue;
            grantedScopes.add(scopeRequested);
            SpontaneousScopeExternalContext context = new SpontaneousScopeExternalContext(client, scopeRequested, grantedScopes, this.spontaneousScopeService);
            this.externalSpontaneousScopeService.executeExternalManipulateScope(context);
            if (!context.isAllowSpontaneousScopePersistence()) continue;
            this.spontaneousScopeService.createSpontaneousScopeIfNeeded(Sets.newHashSet((Iterable)client.getAttributes().getSpontaneousScopes()), scopeRequested, client.getClientId());
        }
        this.log.debug("Granted scopes: " + grantedScopes);
        return grantedScopes;
    }
}

