/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.authorize;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.authorize.IdTokenMember;
import org.gluu.oxauth.model.authorize.UserInfoMember;
import org.gluu.oxauth.model.common.Display;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwe.Jwe;
import org.gluu.oxauth.model.jwe.JweDecrypterImpl;
import org.gluu.oxauth.model.jwt.JwtHeader;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.RedirectUriResponse;
import org.gluu.service.cdi.util.CdiUtil;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthorizationRequest {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthorizationRequest.class);
    private String type;
    private String algorithm;
    private String encryptionAlgorithm;
    private String keyId;
    private List<ResponseType> responseTypes;
    private String clientId;
    private List<String> scopes;
    private String redirectUri;
    private String nonce;
    private String state;
    private List<String> aud;
    private Display display;
    private List<Prompt> prompts;
    private UserInfoMember userInfoMember;
    private IdTokenMember idTokenMember;
    private Integer exp;
    private String iss;
    private Integer iat;
    private Integer nbf;
    private String jti;
    private String clientNotificationToken;
    private String acrValues;
    private String loginHintToken;
    private String idTokenHint;
    private String loginHint;
    private String bindingMessage;
    private String userCode;
    private Integer requestedExpiry;
    private String encodedJwt;
    private String payload;
    private AppConfiguration appConfiguration;

    public JwtAuthorizationRequest(AppConfiguration appConfiguration, AbstractCryptoProvider cryptoProvider, String encodedJwt, Client client) throws InvalidJwtException {
        block11: {
            this.aud = Lists.newArrayList();
            try {
                this.appConfiguration = appConfiguration;
                this.responseTypes = new ArrayList<ResponseType>();
                this.scopes = new ArrayList<String>();
                this.prompts = new ArrayList<Prompt>();
                this.encodedJwt = encodedJwt;
                if (StringUtils.isEmpty((String)encodedJwt)) {
                    throw new InvalidJwtException("The JWT is null or empty");
                }
                String[] parts = encodedJwt.split("\\.");
                if (parts.length == 5) {
                    String encodedHeader = parts[0];
                    JwtHeader jwtHeader = new JwtHeader(encodedHeader);
                    this.keyId = jwtHeader.getKeyId();
                    KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("alg"));
                    BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("enc"));
                    JweDecrypterImpl jweDecrypter = null;
                    if ("RSA".equals(keyEncryptionAlgorithm.getFamily())) {
                        PrivateKey privateKey = cryptoProvider.getPrivateKey(this.keyId);
                        jweDecrypter = new JweDecrypterImpl(privateKey);
                    } else {
                        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
                        jweDecrypter = new JweDecrypterImpl(clientService.decryptSecret(client.getClientSecret()).getBytes(StandardCharsets.UTF_8));
                    }
                    jweDecrypter.setKeyEncryptionAlgorithm(keyEncryptionAlgorithm);
                    jweDecrypter.setBlockEncryptionAlgorithm(blockEncryptionAlgorithm);
                    Jwe jwe = jweDecrypter.decrypt(encodedJwt);
                    this.loadHeader(jwe.getHeader().toJsonString());
                    this.loadPayload(jwe.getClaims().toJsonString());
                    break block11;
                }
                if (parts.length == 2 || parts.length == 3) {
                    String encodedHeader = parts[0];
                    String encodedClaim = parts[1];
                    String encodedSignature = "";
                    if (parts.length == 3) {
                        encodedSignature = parts[2];
                    }
                    String signingInput = encodedHeader + "." + encodedClaim;
                    String header = new String(Base64Util.base64urldecode((String)encodedHeader), StandardCharsets.UTF_8);
                    String payload = new String(Base64Util.base64urldecode((String)encodedClaim), StandardCharsets.UTF_8);
                    payload = payload.replace("\\", "");
                    this.loadHeader(header);
                    SignatureAlgorithm sigAlg = SignatureAlgorithm.fromString((String)this.algorithm);
                    if (sigAlg == null) {
                        throw new InvalidJwtException("The JWT algorithm is not supported");
                    }
                    if (sigAlg == SignatureAlgorithm.NONE && appConfiguration.getFapiCompatibility().booleanValue()) {
                        throw new InvalidJwtException("None algorithm is not allowed for FAPI");
                    }
                    if (!this.validateSignature(cryptoProvider, sigAlg, client, signingInput, encodedSignature)) {
                        throw new InvalidJwtException("The JWT signature is not valid");
                    }
                    this.loadPayload(payload);
                    break block11;
                }
                throw new InvalidJwtException("The JWT is not well formed");
            }
            catch (Exception e) {
                throw new InvalidJwtException((Throwable)e);
            }
        }
    }

    public String getEncodedJwt() {
        return this.encodedJwt;
    }

    private void loadHeader(String header) throws JSONException {
        JSONObject jsonHeader = new JSONObject(header);
        if (jsonHeader.has("typ")) {
            this.type = jsonHeader.getString("typ");
        }
        if (jsonHeader.has("alg")) {
            this.algorithm = jsonHeader.getString("alg");
        }
        if (jsonHeader.has("enc")) {
            this.encryptionAlgorithm = jsonHeader.getString("enc");
        }
        if (jsonHeader.has("kid")) {
            this.keyId = jsonHeader.getString("kid");
        }
    }

    private void loadPayload(String payload) throws JSONException, UnsupportedEncodingException {
        int i;
        this.payload = payload;
        JSONObject jsonPayload = new JSONObject(payload);
        if (jsonPayload.has("response_type")) {
            JSONArray responseTypeJsonArray = jsonPayload.optJSONArray("response_type");
            if (responseTypeJsonArray != null) {
                for (i = 0; i < responseTypeJsonArray.length(); ++i) {
                    ResponseType responseType = ResponseType.fromString((String)responseTypeJsonArray.getString(i));
                    this.responseTypes.add(responseType);
                }
            } else {
                this.responseTypes.addAll(ResponseType.fromString((String)jsonPayload.getString("response_type"), (String)" "));
            }
        }
        if (jsonPayload.has("exp")) {
            this.exp = jsonPayload.getInt("exp");
        }
        if (jsonPayload.has("aud")) {
            JSONArray audArray;
            String audStr = jsonPayload.optString("aud");
            if (StringUtils.isNotBlank((String)audStr)) {
                this.aud.add(audStr);
            }
            if ((audArray = jsonPayload.optJSONArray("aud")) != null && audArray.length() > 0) {
                this.aud.addAll(Util.asList((JSONArray)audArray));
            }
        }
        this.clientId = jsonPayload.optString("client_id", null);
        if (jsonPayload.has("scope")) {
            JSONArray scopesJsonArray = jsonPayload.optJSONArray("scope");
            if (scopesJsonArray != null) {
                for (i = 0; i < scopesJsonArray.length(); ++i) {
                    String scope = scopesJsonArray.getString(i);
                    this.scopes.add(scope);
                }
            } else {
                String scopeStringList = jsonPayload.getString("scope");
                this.scopes.addAll(Util.splittedStringAsList((String)scopeStringList, (String)" "));
            }
        }
        if (jsonPayload.has("redirect_uri")) {
            this.redirectUri = URLDecoder.decode(jsonPayload.getString("redirect_uri"), "UTF-8");
        }
        this.nonce = jsonPayload.optString("nonce", null);
        this.state = jsonPayload.optString("state", null);
        if (jsonPayload.has("display")) {
            this.display = Display.fromString((String)jsonPayload.getString("display"));
        }
        if (jsonPayload.has("prompt")) {
            JSONArray promptJsonArray = jsonPayload.optJSONArray("prompt");
            if (promptJsonArray != null) {
                for (int i2 = 0; i2 < promptJsonArray.length(); ++i2) {
                    Prompt prompt = Prompt.fromString((String)promptJsonArray.getString(i2));
                    this.prompts.add(prompt);
                }
            } else {
                this.prompts.addAll(Prompt.fromString((String)jsonPayload.getString("prompt"), (String)" "));
            }
        }
        if (jsonPayload.has("claims")) {
            JSONObject claimsJsonObject = jsonPayload.getJSONObject("claims");
            if (claimsJsonObject.has("userinfo")) {
                this.userInfoMember = new UserInfoMember(claimsJsonObject.getJSONObject("userinfo"));
            }
            if (claimsJsonObject.has("id_token")) {
                this.idTokenMember = new IdTokenMember(claimsJsonObject.getJSONObject("id_token"));
            }
        }
        this.iss = jsonPayload.optString("iss", null);
        if (jsonPayload.has("exp")) {
            this.exp = jsonPayload.getInt("exp");
        }
        if (jsonPayload.has("iat")) {
            this.iat = jsonPayload.getInt("iat");
        }
        if (jsonPayload.has("nbf")) {
            this.nbf = jsonPayload.getInt("nbf");
        }
        this.jti = jsonPayload.optString("jti", null);
        this.clientNotificationToken = jsonPayload.optString("client_notification_token", null);
        this.acrValues = jsonPayload.optString("acr_values", null);
        this.loginHintToken = jsonPayload.optString("login_hint_token", null);
        this.idTokenHint = jsonPayload.optString("id_token_hint", null);
        this.loginHint = jsonPayload.optString("login_hint", null);
        this.bindingMessage = jsonPayload.optString("binding_message", null);
        this.userCode = jsonPayload.optString("user_code", null);
        if (jsonPayload.has("requested_expiry")) {
            this.requestedExpiry = jsonPayload.get("requested_expiry") instanceof Number ? Integer.valueOf(jsonPayload.getInt("requested_expiry")) : Integer.valueOf(Integer.parseInt(jsonPayload.getString("requested_expiry")));
        }
    }

    private boolean validateSignature(AbstractCryptoProvider cryptoProvider, SignatureAlgorithm signatureAlgorithm, Client client, String signingInput, String signature) throws Exception {
        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
        String sharedSecret = clientService.decryptSecret(client.getClientSecret());
        JSONObject jwks = Strings.isNullOrEmpty((String)client.getJwks()) ? JwtUtil.getJSONWebKeys((String)client.getJwksUri()) : new JSONObject(client.getJwks());
        return cryptoProvider.verifySignature(signingInput, signature, this.keyId, jwks, sharedSecret, signatureAlgorithm);
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getType() {
        return this.type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getState() {
        return this.state;
    }

    public Display getDisplay() {
        return this.display;
    }

    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public UserInfoMember getUserInfoMember() {
        return this.userInfoMember;
    }

    public IdTokenMember getIdTokenMember() {
        return this.idTokenMember;
    }

    public Integer getExp() {
        return this.exp;
    }

    public List<String> getAud() {
        if (this.aud == null) {
            this.aud = Lists.newArrayList();
        }
        return this.aud;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getIss() {
        return this.iss;
    }

    public Integer getIat() {
        return this.iat;
    }

    public Integer getNbf() {
        return this.nbf;
    }

    public String getJti() {
        return this.jti;
    }

    public String getClientNotificationToken() {
        return this.clientNotificationToken;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public String getLoginHintToken() {
        return this.loginHintToken;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public Integer getRequestedExpiry() {
        return this.requestedExpiry;
    }

    @Nullable
    private static String queryRequest(@Nullable String requestUri, @Nullable RedirectUriResponse redirectUriResponse) {
        if (StringUtils.isBlank((String)requestUri)) {
            return null;
        }
        boolean validRequestUri = false;
        try {
            URI reqUri = new URI(requestUri);
            String reqUriHash = reqUri.getFragment();
            String reqUriWithoutFragment = reqUri.getScheme() + ":" + reqUri.getSchemeSpecificPart();
            ClientRequest clientRequest = new ClientRequest(reqUriWithoutFragment);
            clientRequest.setHttpMethod("GET");
            ClientResponse clientResponse = clientRequest.get(String.class);
            int status = clientResponse.getStatus();
            String request = null;
            if (status == 200) {
                request = (String)clientResponse.getEntity(String.class);
                if (StringUtils.isBlank((String)reqUriHash)) {
                    validRequestUri = true;
                } else {
                    String hash = Base64Util.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)request));
                    validRequestUri = StringUtils.equals((String)reqUriHash, (String)hash);
                }
            }
            if (!validRequestUri && redirectUriResponse != null) {
                throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_URI, "Invalid request uri.");
            }
            return request;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static JwtAuthorizationRequest createJwtRequest(String request, String requestUri, Client client, RedirectUriResponse redirectUriResponse, AbstractCryptoProvider cryptoProvider, AppConfiguration appConfiguration) {
        String requestFromClient = JwtAuthorizationRequest.queryRequest(requestUri, redirectUriResponse);
        if (StringUtils.isNotBlank((String)requestFromClient)) {
            request = requestFromClient;
        }
        if (StringUtils.isBlank((String)request)) {
            return null;
        }
        try {
            return new JwtAuthorizationRequest(appConfiguration, cryptoProvider, request, client);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Invalid JWT authorization request. " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

