/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.i18n;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.service.cdi.event.ConfigurationUpdate;
import org.gluu.util.StringHelper;
import org.gluu.util.ilocale.LocaleUtil;
import org.slf4j.Logger;

@Named(value="language")
@ApplicationScoped
public class LanguageBean
implements Serializable {
    private static final long serialVersionUID = -6723715664277907737L;
    private static final String COOKIE_NAME = "org.gluu.i18n.Locale";
    private static final int DEFAULT_MAX_AGE = 31536000;
    private static final String COOKIE_PATH = "/";
    private static final Locale defaultLocale = Locale.ENGLISH;
    @Inject
    private Logger log;
    private List<Locale> supportedLocales;

    public void initSupportedLocales(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        this.supportedLocales = this.buildSupportedLocales(appConfiguration);
    }

    @Deprecated
    public String getLocaleCode() {
        try {
            Locale locale = this.getCookieLocale();
            if (locale != null) {
                this.setLocale(locale);
            }
            return locale.toLanguageTag();
        }
        catch (Exception e) {
            return defaultLocale.getLanguage();
        }
    }

    public Locale getLocale() {
        try {
            Locale locale = this.getCookieLocale();
            if (locale != null) {
                return locale;
            }
        }
        catch (Exception ex) {
            this.log.trace("Failed to get locale from cookie", (Throwable)ex);
        }
        return defaultLocale;
    }

    public void setLocaleCode(String requestedLocaleCode) {
        for (Locale supportedLocale : this.supportedLocales) {
            if (Strings.isEmpty((CharSequence)supportedLocale.getLanguage()) || !supportedLocale.getLanguage().equals(requestedLocaleCode)) continue;
            Locale locale = new Locale(requestedLocaleCode);
            FacesContext.getCurrentInstance().getViewRoot().setLocale(locale);
            this.setCookieValue(locale.toLanguageTag());
            break;
        }
    }

    public void setLocale(Locale requestedLocale) {
        for (Locale supportedLocale : this.supportedLocales) {
            if (!supportedLocale.equals(requestedLocale)) continue;
            FacesContext.getCurrentInstance().getViewRoot().setLocale(supportedLocale);
            this.setCookieValue(supportedLocale.toLanguageTag());
            break;
        }
        this.setLocaleCode(requestedLocale.getLanguage());
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    private List<Locale> buildSupportedLocales(AppConfiguration appConfiguration) {
        List uiLocales = appConfiguration.getUiLocalesSupported();
        LinkedList<Locale> supportedLocales = new LinkedList<Locale>();
        for (String uiLocale : uiLocales) {
            Pair locales = LocaleUtil.toLocaleList((String)uiLocale);
            supportedLocales.addAll((Collection)locales.getRight());
        }
        return supportedLocales;
    }

    public String getMessage(String key) {
        String result;
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceBundle bundle = context.getApplication().getResourceBundle(context, "msgs");
        try {
            result = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            result = "???" + key + "??? not found";
        }
        return result;
    }

    private void setCookieValue(String value) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)ctx.getExternalContext().getResponse();
        Cookie cookie = new Cookie(COOKIE_NAME, value);
        cookie.setMaxAge(31536000);
        cookie.setPath(COOKIE_PATH);
        cookie.setSecure(true);
        cookie.setVersion(1);
        response.addCookie(cookie);
    }

    private String getCookieValue() {
        Cookie cookie = this.getCookie();
        return cookie == null ? null : cookie.getValue();
    }

    private Locale getCookieLocale() {
        String cookieValue = this.getCookieValue();
        if (StringHelper.isEmpty((String)cookieValue)) {
            return null;
        }
        Locale locale = Locale.forLanguageTag(cookieValue);
        return locale;
    }

    private Cookie getCookie() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            return (Cookie)ctx.getExternalContext().getRequestCookieMap().get(COOKIE_NAME);
        }
        return null;
    }
}

