/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ciba;

import javax.ejb.Stateless;
import javax.inject.Named;
import org.gluu.oxauth.client.BaseRequest;
import org.gluu.oxauth.client.ciba.push.PushTokenDeliveryClient;
import org.gluu.oxauth.client.ciba.push.PushTokenDeliveryRequest;
import org.gluu.oxauth.client.ciba.push.PushTokenDeliveryResponse;
import org.gluu.oxauth.model.common.TokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBAPushTokenDeliveryService {
    private static final Logger log = LoggerFactory.getLogger(CIBAPushTokenDeliveryService.class);

    public void pushTokenDelivery(String authReqId, String clientNotificationEndpoint, String clientNotificationToken, String accessToken, String refreshToken, String idToken, Integer expiresIn) {
        PushTokenDeliveryRequest pushTokenDeliveryRequest = new PushTokenDeliveryRequest();
        pushTokenDeliveryRequest.setClientNotificationToken(clientNotificationToken);
        pushTokenDeliveryRequest.setAuthReqId(authReqId);
        pushTokenDeliveryRequest.setAccessToken(accessToken);
        pushTokenDeliveryRequest.setTokenType(TokenType.BEARER);
        pushTokenDeliveryRequest.setRefreshToken(refreshToken);
        pushTokenDeliveryRequest.setExpiresIn(expiresIn);
        pushTokenDeliveryRequest.setIdToken(idToken);
        PushTokenDeliveryClient pushTokenDeliveryClient = new PushTokenDeliveryClient(clientNotificationEndpoint);
        pushTokenDeliveryClient.setRequest((BaseRequest)pushTokenDeliveryRequest);
        PushTokenDeliveryResponse pushTokenDeliveryResponse = pushTokenDeliveryClient.exec();
        log.debug("CIBA: push token delivery result status " + pushTokenDeliveryResponse.getStatus());
    }
}

