/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.authorize.ws.rs;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.authorize.AuthorizeParamsValidator;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.ciba.BackchannelAuthenticationErrorResponseType;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseMode;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.RedirectUriResponse;
import org.gluu.oxauth.service.RedirectionUriService;
import org.gluu.oxauth.util.RedirectUri;
import org.gluu.oxauth.util.RedirectUtil;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.exception.EntryPersistenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Named
@Stateless
public class AuthorizeRestWebServiceValidator {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ClientService clientService;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private AppConfiguration appConfiguration;

    public Client validateClient(String clientId, String state) {
        if (StringUtils.isBlank((String)clientId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "client_id is empty or blank.")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        try {
            Client client = this.clientService.getClient(clientId);
            if (client == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "Unable to find client.")).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
            if (client.isDisabled()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.DISABLED_CLIENT, state, "Client is disabled.")).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
            return client;
        }
        catch (EntryPersistenceException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "Unable to find client on AS.")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    public boolean validateAuthnMaxAge(Integer maxAge, SessionId sessionUser, Client client) {
        if (maxAge == null) {
            maxAge = client.getDefaultMaxAge();
        }
        GregorianCalendar userAuthnTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        if (sessionUser.getAuthenticationTime() != null) {
            userAuthnTime.setTime(sessionUser.getAuthenticationTime());
        }
        if (maxAge != null) {
            userAuthnTime.add(13, maxAge);
            return userAuthnTime.after(ServerUtil.now());
        }
        return true;
    }

    public void validateRequestJwt(String request, String requestUri, RedirectUriResponse redirectUriResponse) {
        if (this.appConfiguration.getFapiCompatibility().booleanValue() && StringUtils.isBlank((String)request) && StringUtils.isBlank((String)requestUri)) {
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "request and request_uri are both not specified which is forbidden for FAPI.");
        }
        if (StringUtils.isNotBlank((String)request) && StringUtils.isNotBlank((String)requestUri)) {
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "Both request and request_uri are specified which is not allowed.");
        }
    }

    public void validate(List<ResponseType> responseTypes, List<Prompt> prompts, String nonce, String state, String redirectUri, HttpServletRequest httpRequest, Client client, ResponseMode responseMode) {
        if (!AuthorizeParamsValidator.validateParams(responseTypes, prompts, nonce, this.appConfiguration.getFapiCompatibility())) {
            if (redirectUri != null && this.redirectionUriService.validateRedirectionUri(client, redirectUri) != null) {
                RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state));
                throw new WebApplicationException(RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest).build());
            }
            throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "Invalid redirect uri.")).build());
        }
    }

    public void validateRequestObject(JwtAuthorizationRequest jwtRequest, RedirectUriResponse redirectUriResponse) {
        long now;
        if (!jwtRequest.getAud().isEmpty() && !jwtRequest.getAud().contains(this.appConfiguration.getIssuer())) {
            this.log.error("Failed to match aud to AS, aud: " + jwtRequest.getAud());
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        if (!this.appConfiguration.getFapiCompatibility().booleanValue()) {
            return;
        }
        if (jwtRequest.getExp() == null) {
            this.log.error("The exp claim is not set");
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        long expInMillis = (long)jwtRequest.getExp().intValue() * 1000L;
        if (expInMillis < (now = new Date().getTime())) {
            this.log.error("Request object expired. Exp:" + expInMillis + ", now: " + now);
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        if (jwtRequest.getScopes() == null || jwtRequest.getScopes().isEmpty()) {
            this.log.error("Request object does not have scope claim.");
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        if (StringUtils.isBlank((String)jwtRequest.getNonce())) {
            this.log.error("Request object does not have nonce claim.");
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        if (StringUtils.isBlank((String)jwtRequest.getRedirectUri())) {
            this.log.error("Request object does not have redirect_uri claim.");
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
    }

    public void validateCibaRequestObject(JwtAuthorizationRequest jwtRequest, String clientId) {
        long now;
        if (jwtRequest.getAud().isEmpty() || !jwtRequest.getAud().contains(this.appConfiguration.getIssuer())) {
            this.log.error("Failed to match aud to AS, aud: " + jwtRequest.getAud());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (!this.appConfiguration.getFapiCompatibility().booleanValue()) {
            return;
        }
        if (jwtRequest.getExp() == null) {
            this.log.error("The exp claim is not set");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        long expInMillis = (long)jwtRequest.getExp().intValue() * 1000L;
        if (expInMillis < (now = new Date().getTime())) {
            this.log.error("Request object expired. Exp:" + expInMillis + ", now: " + now);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (jwtRequest.getScopes() == null || jwtRequest.getScopes().isEmpty()) {
            this.log.error("Request object does not have scope claim.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (StringUtils.isEmpty((String)jwtRequest.getIss()) || !jwtRequest.getIss().equals(clientId)) {
            this.log.error("Request object has a wrong iss claim, iss: " + jwtRequest.getIss());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (jwtRequest.getIat() == null || jwtRequest.getIat() == 0) {
            this.log.error("Request object has a wrong iat claim, iat: " + jwtRequest.getIat());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        int nowInSeconds = Math.toIntExact(System.currentTimeMillis() / 1000L);
        if (jwtRequest.getNbf() == null || jwtRequest.getNbf() > nowInSeconds || jwtRequest.getNbf() < nowInSeconds - this.appConfiguration.getCibaMaxExpirationTimeAllowedSec()) {
            this.log.error("Request object has a wrong nbf claim, nbf: " + jwtRequest.getNbf());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (StringUtils.isEmpty((String)jwtRequest.getJti())) {
            this.log.error("Request object has a wrong jti claim, jti: " + jwtRequest.getJti());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        int result = (StringUtils.isNotBlank((String)jwtRequest.getLoginHint()) ? 1 : 0) + (StringUtils.isNotBlank((String)jwtRequest.getLoginHintToken()) ? 1 : 0) + (StringUtils.isNotBlank((String)jwtRequest.getIdTokenHint()) ? 1 : 0);
        if (result != 1) {
            this.log.error("Request object has too many hints or doesnt have any");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
    }

    public String validateRedirectUri(@NotNull Client client, @Nullable String redirectUri, String state) {
        if (StringUtils.isNotBlank((String)(redirectUri = this.redirectionUriService.validateRedirectionUri(client, redirectUri)))) {
            return redirectUri;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_REDIRECT_URI, state, "")).build());
    }
}

