/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.auth;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.ExternalContext;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.gluu.jsf2.service.FacesService;
import org.gluu.oxauth.auth.Authenticator;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.RequestParameterService;
import org.gluu.oxauth.service.SessionIdService;
import org.slf4j.Logger;

@RequestScoped
public class SelectAccountAction {
    private static final String FORM_ID = "selectForm";
    private static final String LOGIN_BUTTON_REF = "selectForm:loginButton";
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private FacesService facesService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private Authenticator authenticator;
    private String scope;
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String state;
    private String responseMode;
    private String nonce;
    private String display;
    private String prompt;
    private Integer maxAge;
    private String uiLocales;
    private String idTokenHint;
    private String loginHint;
    private String acrValues;
    private String amrValues;
    private String request;
    private String requestUri;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String claims;
    private String authReqId;
    private String bindingMessage;
    private String sessionId;
    private String allowedScope;
    private List<SessionId> currentSessions = Lists.newArrayList();
    private String selectedSessionId;

    @PostConstruct
    public void prepare() {
        this.currentSessions = Lists.newArrayList();
        HashSet uids = Sets.newHashSet();
        for (SessionId sessionId : this.sessionIdService.getCurrentSessions()) {
            String uid;
            User user = this.sessionIdService.getUser(sessionId);
            if (user == null) {
                this.log.error("Failed to get user for session. Skipping it from current_sessions, id: " + sessionId.getId());
                continue;
            }
            String string = uid = StringUtils.isNotBlank((String)user.getUserId()) ? user.getUserId() : user.getDn();
            if (this.currentSessions.contains(sessionId) || uids.contains(uid)) continue;
            this.log.trace("User: {}, sessionId: {}", (Object)uid, (Object)sessionId.getId());
            this.currentSessions.add(sessionId);
            uids.add(uid);
        }
        this.log.trace("Found {} sessions", (Object)this.currentSessions.size());
    }

    public List<SessionId> getCurrentSessions() {
        return this.currentSessions;
    }

    public void select() {
        try {
            this.log.debug("Selected account: " + this.selectedSessionId);
            this.clearSessionIdCookie();
            SessionId selectedSession = this.currentSessions.stream().filter(s -> s.getId().equals(this.selectedSessionId)).findAny().get();
            this.cookieService.createSessionIdCookie(selectedSession, false);
            this.identity.setSessionId(selectedSession);
            this.authenticator.authenticateBySessionId(this.selectedSessionId);
            String uri = this.buildAuthorizationUrl();
            this.log.trace("RedirectTo: {}", (Object)uri);
            this.facesService.redirectToExternalURL(uri);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getName(SessionId sessionId) {
        User user = sessionId.getUser();
        String displayName = user.getAttribute("displayName");
        if (StringUtils.isNotBlank((String)displayName)) {
            return displayName;
        }
        if (StringUtils.isNotBlank((String)displayName)) {
            return user.getUserId();
        }
        return user.getDn();
    }

    public void login() {
        try {
            this.clearSessionIdCookie();
            String uri = this.buildAuthorizationUrl();
            this.log.trace("RedirectTo: {}", (Object)uri);
            this.facesService.redirectToExternalURL(uri);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void clearSessionIdCookie() {
        Object response = this.externalContext.getResponse();
        if (!(response instanceof HttpServletResponse)) {
            this.log.error("Unknown http response.");
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.cookieService.removeSessionIdCookie(httpResponse);
        this.cookieService.removeOPBrowserStateCookie(httpResponse);
        if (this.identity != null) {
            this.identity.logout();
        }
        this.log.trace("Removed session_id and opbs cookies.");
    }

    private String buildAuthorizationUrl() throws UnsupportedEncodingException {
        HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
        return httpRequest.getContextPath() + "/restv1/authorize?" + this.requestParameterService.parametersAsString(this.getFilteredParameters());
    }

    private Map<String, String> getFilteredParameters() {
        Map parameterMap = this.externalContext.getRequestParameterMap();
        HashMap filtered = Maps.newHashMap();
        String formIdWithColon = "selectForm:";
        for (Map.Entry entry : parameterMap.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("javax.faces.ViewState") || key.equals(FORM_ID) || key.contains(LOGIN_BUTTON_REF)) continue;
            if (key.startsWith("selectForm:")) {
                filtered.put(StringUtils.removeStart((String)key, (String)"selectForm:"), entry.getValue());
                continue;
            }
            filtered.put(StringUtils.removeStart((String)key, (String)"selectForm:"), entry.getValue());
        }
        return filtered;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public String getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getAmrValues() {
        return this.amrValues;
    }

    public void setAmrValues(String amrValues) {
        this.amrValues = amrValues;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAllowedScope() {
        return this.allowedScope;
    }

    public void setAllowedScope(String allowedScope) {
        this.allowedScope = allowedScope;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public void setBindingMessage(String bindingMessage) {
        this.bindingMessage = bindingMessage;
    }

    public String getSelectedSessionId() {
        return this.selectedSessionId;
    }

    public void setSelectedSessionId(String selectedSessionId) {
        this.selectedSessionId = selectedSessionId;
    }
}

