/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.RegisterResponse;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.client.UserInfoRequest;
import org.gluu.oxauth.client.model.authorize.Claim;
import org.gluu.oxauth.client.model.authorize.ClaimValue;
import org.gluu.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.common.AuthorizationMethod;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.common.SubjectType;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.ws.rs.ClientTestUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class UserInfoRestWebServiceEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId;
    private static String clientSecret;
    private static String accessToken1;
    private static String accessToken2;
    private static String accessToken3;
    private static String accessToken4;
    private static String accessToken5;
    private static String accessToken6;
    private static String accessToken7;
    private static String clientId1;
    private static String clientId2;
    private static String clientId3;
    private static String clientSecret1;
    private static String clientSecret2;
    private static String clientSecret3;

    @Parameters(value={"registerPath", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void dynamicClientRegistration(String registerPath, String redirectUris, String sectorIdentifierUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setSubjectType(SubjectType.PAIRWISE);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerRequest.setClaims(Arrays.asList("iname", "o"));
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("dynamicClientRegistration", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            RegisterResponse registerResponse = RegisterResponse.valueOf((String)entity);
            ClientTestUtil.assert_((RegisterResponse)registerResponse);
            clientId = registerResponse.getClientId();
            clientSecret = registerResponse.getClientSecret();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestUserInfoStep1ImplicitFlow(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String userEncodedCredentials = Base64.encodeBase64String((byte[])(userId + ":" + userSecret).getBytes());
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + userEncodedCredentials));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfo step 1 Implicit Flow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                Map params = QueryStringDecoder.decode((String)uri.getFragment());
                Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                accessToken1 = (String)params.get("access_token");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Unexpected error");
            }
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoStep1ImplicitFlow"})
    public void requestUserInfoStep2PostImplicitFlow(String userInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        request.header("Authorization", (Object)("Bearer " + accessToken1));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        UserInfoRequest userInfoRequest = new UserInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfo step 2 POST Implicit Flow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("sub"));
            Assert.assertTrue((boolean)jsonObj.has("name"));
            Assert.assertTrue((boolean)jsonObj.has("given_name"));
            Assert.assertTrue((boolean)jsonObj.has("family_name"));
            Assert.assertTrue((boolean)jsonObj.has("email"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoStep1ImplicitFlow"})
    public void requestUserInfoStep2GetImplicitFlow(String userInfoPath) throws Exception {
        UserInfoRequest userInfoRequest = new UserInfoRequest(null);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath + "?" + userInfoRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Bearer " + accessToken1));
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfo step 2 GET Implicit Flow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("sub"));
            Assert.assertTrue((boolean)jsonObj.has("name"));
            Assert.assertTrue((boolean)jsonObj.has("given_name"));
            Assert.assertTrue((boolean)jsonObj.has("family_name"));
            Assert.assertTrue((boolean)jsonObj.has("email"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestUserInfoStep1PasswordFlow(String tokenPath, String userId, String userSecret) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("openid profile address email");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoStep1PasswordFlow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertTrue((!entity.equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
            accessToken4 = jsonObj.getString("access_token");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoStep1PasswordFlow"})
    public void requestUserInfoStep2PasswordFlow(String userInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        request.header("Authorization", (Object)("Bearer " + accessToken4));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        UserInfoRequest userInfoRequest = new UserInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoStep2PasswordFlow", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("sub"));
            Assert.assertTrue((boolean)jsonObj.has("name"));
            Assert.assertTrue((boolean)jsonObj.has("given_name"));
            Assert.assertTrue((boolean)jsonObj.has("family_name"));
            Assert.assertTrue((boolean)jsonObj.has("email"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test
    public void requestUserInfoInvalidRequest(String userInfoPath) throws Exception {
        UserInfoRequest userInfoRequest = new UserInfoRequest(null);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoInvalidRequest", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test
    public void requestUserInfoInvalidToken(String userInfoPath) throws Exception {
        UserInfoRequest userInfoRequest = new UserInfoRequest("INVALID_ACCESS_TOKEN");
        userInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoInvalidToken", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)401, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test
    public void requestUserInfoInvalidSchema(String userInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        UserInfoRequest userInfoRequest = new UserInfoRequest("INVALID_ACCESS_TOKEN");
        Map userInfoParameters = userInfoRequest.getParameters();
        userInfoParameters.put("schema", "INVALID_SCHEMA");
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoInvalidSchema", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestUserInfoAdditionalClaims(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("invalid", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("iname", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("o", ClaimValue.createEssential((boolean)true)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        System.out.println("Request JWT: " + authJwt);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoAdditionalClaims step 1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                Map params = QueryStringDecoder.decode((String)uri.getFragment());
                Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                accessToken3 = (String)params.get("access_token");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoAdditionalClaims"})
    public void requestUserInfoAdditionalClaimsStep2(String userInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken3);
        userInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoAdditionalClaims step 2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("sub"));
            Assert.assertTrue((boolean)jsonObj.has("name"));
            Assert.assertTrue((boolean)jsonObj.has("given_name"));
            Assert.assertTrue((boolean)jsonObj.has("family_name"));
            Assert.assertTrue((boolean)jsonObj.has("email"));
            Assert.assertTrue((boolean)jsonObj.has("iname"));
            Assert.assertTrue((boolean)jsonObj.has("o"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestUserInfoHS256Step1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS256Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestUserInfoHS256Step1"})
    public void requestUserInfoHS256Step2(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId1, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret1, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        System.out.println("Request JWT: " + authJwt);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS256Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
            Assert.assertEquals((String)((String)params.get("state")), (String)state);
            accessToken5 = (String)params.get("access_token");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoHS256Step2"})
    public void requestUserInfoHS256Step3(String userInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        request.header("Authorization", (Object)("Bearer " + accessToken5));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        UserInfoRequest userInfoRequest = new UserInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS256Step3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            Jwt jwt = Jwt.parse((String)entity);
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("name"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("email"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("picture"));
        }
        catch (InvalidJwtException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestUserInfoHS384Step1(String registerPath, String redirectUris) throws Exception {
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS384Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestUserInfoHS384Step1"})
    public void requestUserInfoHS384Step2(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId2, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS384, clientSecret2, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        System.out.println("Request JWT: " + authJwt);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS384Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
            Assert.assertEquals((String)((String)params.get("state")), (String)state);
            accessToken6 = (String)params.get("access_token");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoHS384Step2"})
    public void requestUserInfoHS384Step3(String userInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        request.header("Authorization", (Object)("Bearer " + accessToken6));
        UserInfoRequest userInfoRequest = new UserInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS384Step3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            Jwt jwt = Jwt.parse((String)entity);
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("name"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("email"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("picture"));
        }
        catch (InvalidJwtException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestUserInfoHS512Step1(String registerPath, String redirectUris) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS512Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret3 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestUserInfoHS512Step1"})
    public void requestUserInfoHS512Step2(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId3, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS512, clientSecret3, (AbstractCryptoProvider)cryptoProvider);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        System.out.println("Request JWT: " + authJwt);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS512Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        try {
            URI uri = new URI(response.getLocation().toString());
            Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
            Map params = QueryStringDecoder.decode((String)uri.getFragment());
            Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
            Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
            Assert.assertNotNull(params.get("state"), (String)"The state is null");
            Assert.assertEquals((String)((String)params.get("state")), (String)state);
            accessToken7 = (String)params.get("access_token");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)"Response URI is not well formed");
        }
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoHS512Step2"})
    public void requestUserInfoHS512Step3(String userInfoPath) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + userInfoPath).request();
        request.header("Authorization", (Object)("Bearer " + accessToken7));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        UserInfoRequest userInfoRequest = new UserInfoRequest(null);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(userInfoRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        UserInfoRestWebServiceEmbeddedTest.showResponse("requestUserInfoHS512Step3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            Jwt jwt = Jwt.parse((String)entity);
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("name"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("email"));
            Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("picture"));
        }
        catch (InvalidJwtException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

