/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.EndSessionRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.RegisterResponse;
import org.gluu.oxauth.model.TClientService;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.util.StringUtils;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@RunAsClient
public class EndSessionBackchannelRestServerTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static RegisterResponse registerResponse;
    private static String idToken;
    private static String sessionId;

    @Parameters(value={"redirectUris", "postLogoutRedirectUri"})
    @Test
    public void requestEndSessionStep1(String redirectUris, String postLogoutRedirectUri) throws Exception {
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
        registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
        registerRequest.setBackchannelLogoutUris((List)Lists.newArrayList((Object[])new String[]{postLogoutRedirectUri}));
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        registerResponse = TClientService.register(registerRequest, this.url);
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestEndSessionStep1"})
    public void requestEndSessionStep2(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, registerResponse.getClientId(), scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        EndSessionBackchannelRestServerTest.showResponse("requestEndSessionStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                Map params = QueryStringDecoder.decode((String)uri.getFragment());
                Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                idToken = (String)params.get("id_token");
                sessionId = (String)params.get("session_id");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"endSessionPath", "postLogoutRedirectUri"})
    @Test(dependsOnMethods={"requestEndSessionStep2"})
    public void requestEndSessionStep3(String endSessionPath, String postLogoutRedirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        EndSessionRequest endSessionRequest = new EndSessionRequest(idToken, postLogoutRedirectUri, state);
        endSessionRequest.setSessionId(sessionId);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + endSessionPath + "?" + endSessionRequest.getQueryString()).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        EndSessionBackchannelRestServerTest.showResponse("requestEndSessionStep3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertEquals((Object)response.getLocation(), (Object)new URI(postLogoutRedirectUri));
    }
}

