/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.model.uma.TUma;
import org.gluu.oxauth.model.uma.UmaResource;
import org.gluu.oxauth.model.uma.UmaResourceResponse;
import org.gluu.oxauth.model.uma.UmaTestUtil;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class UmaRegisterResourceWSTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static Token pat;
    private static UmaResourceResponse resourceStatus;
    private static String umaRegisterResourcePath;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri", "umaRegisterResourcePath"})
    public void init(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri, String umaRegisterResourcePath) {
        pat = TUma.requestPat(this.url, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaRegisterResourceWSTest.umaRegisterResourcePath = umaRegisterResourcePath;
    }

    @Test(dependsOnMethods={"init"})
    public void testRegisterResource() throws Exception {
        resourceStatus = TUma.registerResource(this.url, pat, umaRegisterResourcePath, UmaTestUtil.createResource());
        UmaTestUtil.assert_((UmaResourceResponse)resourceStatus);
    }

    @Test(dependsOnMethods={"testRegisterResource"})
    public void testModifyResource() throws Exception {
        UmaResource resource = new UmaResource();
        resource.setName("Server Photo Album 2");
        resource.setIconUri("http://www.example.com/icons/flower.png");
        resource.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
        UmaResourceResponse status = TUma.modifyResource(this.url, pat, umaRegisterResourcePath, resourceStatus.getId(), resource);
        UmaTestUtil.assert_((UmaResourceResponse)status);
    }

    @Test(dependsOnMethods={"testModifyResource"})
    public void testGetResources() throws Exception {
        List<String> list = TUma.getResourceList(this.url, pat, umaRegisterResourcePath);
        Assert.assertTrue((list != null && !list.isEmpty() && list.contains(resourceStatus.getId()) ? 1 : 0) != 0, (String)"Resource list is empty");
    }

    @Test(dependsOnMethods={"testGetResources"})
    public void testDeleteResource() throws Exception {
        TUma.deleteResource(this.url, pat, umaRegisterResourcePath, resourceStatus.getId());
    }
}

