/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.uma;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.Holder;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.uma.RPTResponse;
import org.gluu.oxauth.model.uma.RptIntrospectionResponse;
import org.gluu.oxauth.model.uma.UmaScopeType;
import org.gluu.oxauth.model.uma.UmaTestUtil;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;

public class TTokenRequest {
    private final URI baseUri;
    private final Token token = new Token();

    public TTokenRequest(URI baseUri) {
        Assert.assertNotNull((Object)baseUri);
        this.baseUri = baseUri;
    }

    public Token pat(String authorizePath, String tokenPath, String userId, String userSecret, String umaClientId, String umaClientSecret, String umaRedirectUri) {
        return this.internalRequest(authorizePath, tokenPath, userId, userSecret, umaClientId, umaClientSecret, umaRedirectUri, UmaScopeType.PROTECTION);
    }

    public Token newTokenByRefreshToken(String tokenPath, Token p_oldToken, String umaClientId, String umaClientSecret) {
        if (p_oldToken == null || StringUtils.isBlank((String)p_oldToken.getRefreshToken()) || StringUtils.isBlank((String)tokenPath)) {
            throw new IllegalArgumentException("Refresh token or tokenPath is empty.");
        }
        Holder t = new Holder();
        try {
            TokenRequest tokenRequest = new TokenRequest(GrantType.REFRESH_TOKEN);
            tokenRequest.setAuthUsername(umaClientId);
            tokenRequest.setAuthPassword(umaClientSecret);
            tokenRequest.setRefreshToken(p_oldToken.getRefreshToken());
            tokenRequest.setScope(p_oldToken.getScope());
            Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + tokenPath).request();
            request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
            Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
            String entity = (String)response.readEntity(String.class);
            BaseTest.showResponse("TTokenClient.requestToken() :", response, entity);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
            try {
                JSONObject jsonObj = new JSONObject(entity);
                Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                String accessToken = jsonObj.getString("access_token");
                String refreshToken = jsonObj.getString("refresh_token");
                Token newToken = new Token();
                newToken.setAccessToken(accessToken);
                newToken.setRefreshToken(refreshToken);
                t.setT((Object)newToken);
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return (Token)t.getT();
    }

    private Token internalRequest(String authorizePath, String tokenPath, String userId, String userSecret, String umaClientId, String umaClientSecret, String umaRedirectUri, UmaScopeType p_scopeType) {
        try {
            this.requestAuthorizationCode(authorizePath, userId, userSecret, umaClientId, umaRedirectUri, p_scopeType);
            this.requestToken(tokenPath, umaClientId, umaClientSecret, umaRedirectUri);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        UmaTestUtil.assert_((Token)this.token);
        return this.token;
    }

    private void requestAuthorizationCode(String authorizePath, String userId, String userSecret, String umaClientId, String umaRedirectUri, UmaScopeType p_scopeType) throws Exception {
        this.requestAuthorizationCode(authorizePath, userId, userSecret, umaClientId, umaRedirectUri, p_scopeType.getValue());
    }

    private void requestAuthorizationCode(String authorizePath, String userId, String userSecret, String umaClientId, String umaRedirectUri, String p_scopeType) throws Exception {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.CODE);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(p_scopeType);
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, umaClientId, scopes, umaRedirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        BaseTest.showResponse("TTokenClient.requestAuthorizationCode() : ", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                String location = response.getLocation().toString();
                int fragmentIndex = location.indexOf("#");
                Map params = new HashMap();
                if (fragmentIndex != -1) {
                    String fragment = location.substring(fragmentIndex + 1);
                    params = QueryStringDecoder.decode((String)fragment);
                } else {
                    int queryStringIndex = location.indexOf("?");
                    if (queryStringIndex != -1) {
                        String queryString = location.substring(queryStringIndex + 1);
                        params = QueryStringDecoder.decode((String)queryString);
                    }
                }
                Assert.assertNotNull(params.get("code"), (String)"The code is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                this.token.setAuthorizationCode((String)params.get("code"));
                this.token.setScope((String)params.get("scope"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private void requestToken(String tokenPath, String umaClientId, String umaClientSecret, String umaRedirectUri) throws Exception {
        if (this.token == null || StringUtils.isBlank((String)this.token.getAuthorizationCode())) {
            throw new IllegalArgumentException("Authorization code is not initialized.");
        }
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(this.token.getAuthorizationCode());
        tokenRequest.setRedirectUri(umaRedirectUri);
        tokenRequest.setAuthUsername(umaClientId);
        tokenRequest.setAuthPassword(umaClientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        tokenRequest.setScope(this.token.getScope());
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + tokenPath).request();
        request.header("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        BaseTest.showResponse("TTokenClient.requestToken() :", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
            String accessToken = jsonObj.getString("access_token");
            String refreshToken = jsonObj.getString("refresh_token");
            this.token.setAccessToken(accessToken);
            this.token.setRefreshToken(refreshToken);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public RPTResponse requestRpt(String p_rptPath) {
        Holder h = new Holder();
        try {
            Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + p_rptPath).request();
            request.header("Accept", (Object)"application/json");
            Response response = request.post(Entity.form((Form)new Form()));
            String entity = (String)response.readEntity(String.class);
            BaseTest.showResponse("UMA : TTokenRequest.requestRpt() : ", response, entity);
            Assert.assertEquals((int)response.getStatus(), (int)Response.Status.CREATED.getStatusCode(), (String)"Unexpected response code.");
            try {
                String tokenResponse = entity;
                JSONObject jsonObj = new JSONObject(tokenResponse);
                if (jsonObj.has("requesterPermissionTokenResponse")) {
                    tokenResponse = jsonObj.get("requesterPermissionTokenResponse").toString();
                }
                System.out.println("Token response = " + tokenResponse);
                RPTResponse result = (RPTResponse)ServerUtil.createJsonMapper().readValue(tokenResponse, RPTResponse.class);
                UmaTestUtil.assert_((RPTResponse)result);
                h.setT((Object)result);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
            catch (JSONException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return (RPTResponse)h.getT();
    }

    public RptIntrospectionResponse requestRptStatus(String p_umaRptStatusPath, String rpt) {
        Holder h = new Holder();
        try {
            Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.baseUri.toString() + p_umaRptStatusPath).request();
            request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            Response response = request.post(Entity.form((Form)new Form("token", rpt)));
            String entity = (String)response.readEntity(String.class);
            BaseTest.showResponse("UMA : TTokenRequest.requestRptStatus() : ", response, entity);
            Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)"Unexpected response code.");
            try {
                RptIntrospectionResponse result = (RptIntrospectionResponse)ServerUtil.createJsonMapper().readValue(entity, RptIntrospectionResponse.class);
                Assert.assertNotNull((Object)result);
                h.setT((Object)result);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return (RptIntrospectionResponse)h.getT();
    }
}

