/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.json;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.model.json.JsonApplier;
import org.json.JSONArray;
import org.json.JSONObject;
import org.oxauth.persistence.model.ClientAttributes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonApplierServerTest {
    @Test
    public void transfer_fromRegisterRequestToClientAttribute_withListOfString_shouldTransferValueCorrectly() {
        RegisterRequest request = new RegisterRequest();
        request.setAdditionalAudience((List)Lists.newArrayList((Object[])new String[]{"aud1", "aud2"}));
        ClientAttributes attributes = new ClientAttributes();
        JsonApplier.getInstance().transfer((Object)request, (Object)attributes);
        Assert.assertEquals((Collection)Lists.newArrayList((Object[])new String[]{"aud1", "aud2"}), (Collection)attributes.getAdditionalAudience());
    }

    @Test
    public void apply_fromClientAttributesToJSONObject_withListOfString_shouldTransferValueCorrectly() {
        ClientAttributes attributes = new ClientAttributes();
        attributes.setAdditionalAudience((List)Lists.newArrayList((Object[])new String[]{"aud1", "aud2"}));
        JSONObject jsonObject = new JSONObject();
        JsonApplier.getInstance().apply((Object)attributes, jsonObject);
        Assert.assertEquals((Iterable)new JSONArray((Collection)Lists.newArrayList((Object[])new String[]{"aud1", "aud2"})), (Iterable)jsonObject.getJSONArray("additional_audience"));
    }
}

