/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.dev.duo;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.oxauth.persistence.model.configuration.CustomProperty;
import org.oxauth.persistence.model.configuration.oxIDPAuthConf;
import org.testng.annotations.Test;

public class PythonToLdapString {
    public static final String SCRIPT_FIELD_NAME = "script.__$__customAuthenticationScript__$__";

    @Test
    public void test() throws IOException {
        File f = new File("U:\\own\\project\\oxAuth\\Server\\integrations\\duo\\ExternalAuthenticator.py");
        String pythonScript = IOUtils.toString((InputStream)new FileInputStream(f));
        System.out.println("Python script: \n" + pythonScript);
        ArrayList<CustomProperty> fields = new ArrayList<CustomProperty>();
        fields.add(this.createAttribute("property.duo_host", "api-fa928e64.duosecurity.com"));
        fields.add(this.createAttribute("property.duo_ikey", "DIT2906CETIMKHE1QND8"));
        fields.add(this.createAttribute("property.duo_skey", "cjNn9R4QvQV0R2Mynw2CauCUesojuR3cPGDoVygM"));
        fields.add(this.createAttribute("property.duo_akey", "6f88ca3dea7ac88a514cdef7c18021678ccaf0e1"));
        fields.add(this.createAttribute(SCRIPT_FIELD_NAME, pythonScript));
        oxIDPAuthConf c = new oxIDPAuthConf();
        c.setType("customAuthentication");
        c.setName("duo");
        c.setEnabled(true);
        c.setLevel(1);
        c.setPriority(1);
        c.setFields(fields);
        String json = this.getJSONString(c);
        System.out.println("JSON: \n" + json);
        oxIDPAuthConf fromJson = this.fromJSON(json);
        for (CustomProperty attr : fromJson.getFields()) {
            if (!attr.getName().equals(SCRIPT_FIELD_NAME)) continue;
            System.out.println("Script from json: \n" + (String)attr.getValues().get(0));
        }
    }

    private CustomProperty createAttribute(String p_name, String p_value) {
        ArrayList<String> v = new ArrayList<String>();
        v.add(p_value);
        CustomProperty result = new CustomProperty();
        result.setName(p_name);
        result.setValues(v);
        return result;
    }

    private String getJSONString(oxIDPAuthConf conf) throws IOException {
        StringWriter sw = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((Writer)sw, (Object)conf);
        return sw.toString();
    }

    private oxIDPAuthConf fromJSON(String p_json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (oxIDPAuthConf)mapper.readValue(p_json, oxIDPAuthConf.class);
    }
}

