/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs.fido.u2f;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.fido.u2f.U2fConfiguration;
import org.gluu.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.gluu.oxauth.util.ServerUtil;
import org.slf4j.Logger;

@Path(value="/fido-configuration")
@Api(value="/.well-known/fido-configuration", description="The FIDO server endpoint that provides configuration data in a JSON [RFC4627] document that resides in at /.well-known/fido-configuration directory at its hostmeta [hostmeta] location. The configuration data documents conformance options and endpoints supported by the FIDO U2f server.")
public class U2fConfigurationWS {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Provides configuration data as json document. It contains options and endpoints supported by the FIDO U2F server.", response=U2fConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Failed to build FIDO U2F configuration json object.")})
    public Response getConfiguration() {
        try {
            if (this.appConfiguration.getDisableU2fEndpoint().booleanValue()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            String baseEndpointUri = this.appConfiguration.getBaseEndpoint();
            U2fConfiguration conf = new U2fConfiguration();
            conf.setVersion("2.0");
            conf.setIssuer(this.appConfiguration.getIssuer());
            conf.setRegistrationEndpoint(baseEndpointUri + "/fido/u2f/registration");
            conf.setAuthenticationEndpoint(baseEndpointUri + "/fido/u2f/authentication");
            String entity = ServerUtil.asPrettyJson(conf);
            this.log.trace("FIDO U2F configuration: {}", (Object)entity);
            return Response.ok((Object)entity).build();
        }
        catch (Throwable ex) {
            this.log.error(ex.getMessage(), ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)U2fErrorResponseType.SERVER_ERROR, "Unknown.")).build());
        }
    }
}

