/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.userinfo.ws.rs;

import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.GluuAttribute;
import org.gluu.model.attribute.AttributeDataType;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.authorize.Claim;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.DefaultScope;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.oxauth.model.common.SubjectType;
import org.gluu.oxauth.model.common.UnmodifiableAuthorizationGrant;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.exception.InvalidClaimException;
import org.gluu.oxauth.model.exception.InvalidJweException;
import org.gluu.oxauth.model.jwe.Jwe;
import org.gluu.oxauth.model.jwe.JweEncrypterImpl;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.jwt.JwtSubClaimObject;
import org.gluu.oxauth.model.jwt.JwtType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.gluu.oxauth.model.userinfo.UserInfoParamsValidator;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.PairwiseIdentifierService;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.ServerCryptoProvider;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.external.ExternalDynamicScopeService;
import org.gluu.oxauth.service.external.context.DynamicScopeExternalContext;
import org.gluu.oxauth.userinfo.ws.rs.UserInfoRestWebService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.oxauth.persistence.model.PairwiseIdentifier;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Path(value="/")
public class UserInfoRestWebServiceImpl
implements UserInfoRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private UserService userService;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private PairwiseIdentifierService pairwiseIdentifierService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private PersistenceEntryManager entryManager;

    @Override
    public Response requestUserInfoGet(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        return this.requestUserInfo(accessToken, authorization, request, securityContext);
    }

    @Override
    public Response requestUserInfoPost(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        return this.requestUserInfo(accessToken, authorization, request, securityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response requestUserInfo(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        Response.ResponseBuilder builder;
        block20: {
            if (authorization != null && !authorization.isEmpty() && authorization.startsWith("Bearer ")) {
                accessToken = authorization.substring(7);
            }
            this.log.debug("Attempting to request User Info, Access token = {}, Is Secure = {}", (Object)accessToken, (Object)securityContext.isSecure());
            builder = Response.ok();
            OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.USER_INFO);
            try {
                if (!UserInfoParamsValidator.validateParams(accessToken)) {
                    builder = Response.status((int)400);
                    builder.entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)UserInfoErrorResponseType.INVALID_REQUEST, "access token is not valid."));
                    break block20;
                }
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
                if (authorizationGrant == null) {
                    this.log.trace("Failed to find authorization grant by access_token: " + accessToken);
                    Response response = this.response(401, UserInfoErrorResponseType.INVALID_TOKEN);
                    return response;
                }
                AbstractToken accessTokenObject = authorizationGrant.getAccessToken(accessToken);
                if (accessTokenObject == null || !accessTokenObject.isValid()) {
                    this.log.trace("Invalid access token object, access_token: {}, isNull: {}, isValid: {}", new Object[]{accessToken, accessTokenObject == null, accessTokenObject.isValid()});
                    Response response = this.response(401, UserInfoErrorResponseType.INVALID_TOKEN);
                    return response;
                }
                if (authorizationGrant.getAuthorizationGrantType() == AuthorizationGrantType.CLIENT_CREDENTIALS) {
                    builder = Response.status((int)403);
                    builder.entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Grant object has client_credentials grant_type which is not valid."));
                    break block20;
                }
                if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && !authorizationGrant.getScopes().contains(DefaultScope.OPEN_ID.toString()) && !authorizationGrant.getScopes().contains(DefaultScope.PROFILE.toString())) {
                    builder = Response.status((int)403);
                    builder.entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Both openid and profile scopes are not present."));
                    oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, false);
                    break block20;
                }
                if (!this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && !authorizationGrant.getScopes().contains(DefaultScope.OPEN_ID.toString())) {
                    builder = Response.status((int)403);
                    builder.entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Missed openid scope."));
                    oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, false);
                    break block20;
                }
                oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, true);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setPrivate(true);
                cacheControl.setNoTransform(false);
                cacheControl.setNoStore(true);
                builder.cacheControl(cacheControl);
                builder.header("Pragma", (Object)"no-cache");
                User currentUser = authorizationGrant.getUser();
                try {
                    currentUser = this.userService.getUserByDn(authorizationGrant.getUserDn(), new String[0]);
                }
                catch (EntryPersistenceException ex) {
                    this.log.warn("Failed to reload user entry: '{}'", (Object)authorizationGrant.getUserDn());
                }
                if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getUserInfoEncryptedResponseAlg() != null && authorizationGrant.getClient().getUserInfoEncryptedResponseEnc() != null) {
                    KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoEncryptedResponseAlg());
                    BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoEncryptedResponseEnc());
                    builder.type("application/jwt");
                    builder.entity((Object)this.getJweResponse(keyEncryptionAlgorithm, blockEncryptionAlgorithm, currentUser, authorizationGrant, authorizationGrant.getScopes()));
                } else if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getUserInfoSignedResponseAlg() != null) {
                    SignatureAlgorithm algorithm = SignatureAlgorithm.fromString((String)authorizationGrant.getClient().getUserInfoSignedResponseAlg());
                    builder.type("application/jwt");
                    builder.entity((Object)this.getJwtResponse(algorithm, currentUser, authorizationGrant, authorizationGrant.getScopes()));
                } else {
                    builder.type("application/json;charset=UTF-8");
                    builder.entity((Object)this.getJSonResponse(currentUser, authorizationGrant, authorizationGrant.getScopes()));
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            }
            finally {
                this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            }
        }
        return builder.build();
    }

    private Response response(int status, UserInfoErrorResponseType errorResponseType) {
        return Response.status((int)status).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)errorResponseType, "")).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public String getJwtResponse(SignatureAlgorithm signatureAlgorithm, User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        this.log.trace("Building JWT reponse with next scopes {0} for user {1} and user custom attributes {0}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        Jwt jwt = new Jwt();
        jwt.getHeader().setType(JwtType.JWT);
        jwt.getHeader().setAlgorithm(signatureAlgorithm);
        String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(this.webKeysConfiguration, Algorithm.fromString((String)signatureAlgorithm.getName()), Use.SIGNATURE);
        if (keyId != null) {
            jwt.getHeader().setKeyId(keyId);
        }
        String claimsString = this.getJSonResponse(user, authorizationGrant, scopes);
        JwtClaims claims = new JwtClaims(new JSONObject(claimsString));
        jwt.setClaims(claims);
        jwt.getClaims().setIssuer(this.appConfiguration.getIssuer());
        jwt.getClaims().addAudience(authorizationGrant.getClientId());
        String sharedSecret = this.clientService.decryptSecret(authorizationGrant.getClient().getClientSecret());
        String signature = this.cryptoProvider.sign(jwt.getSigningInput(), jwt.getHeader().getKeyId(), sharedSecret, signatureAlgorithm);
        jwt.setEncodedSignature(signature);
        return jwt.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getJweResponse(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        this.log.trace("Building JWE reponse with next scopes {0} for user {1} and user custom attributes {0}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        Jwe jwe = new Jwe();
        jwe.getHeader().setType(JwtType.JWT);
        jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
        String claimsString = this.getJSonResponse(user, authorizationGrant, scopes);
        JwtClaims claims = new JwtClaims(new JSONObject(claimsString));
        jwe.setClaims(claims);
        jwe.getClaims().setIssuer(this.appConfiguration.getIssuer());
        jwe.getClaims().addAudience(authorizationGrant.getClientId());
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            JSONObject jsonWebKeys = JwtUtil.getJSONWebKeys((String)authorizationGrant.getClient().getJwksUri());
            String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyEncryptionAlgorithm.getName()), Use.ENCRYPTION);
            PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId, jsonWebKeys);
            if (publicKey == null) throw new InvalidJweException("The public key is not valid");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, publicKey);
            jwe = jweEncrypter.encrypt(jwe);
            return jwe.toString();
        }
        if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A128KW && keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A256KW) return jwe.toString();
        try {
            byte[] sharedSymmetricKey = this.clientService.decryptSecret(authorizationGrant.getClient().getClientSecret()).getBytes("UTF-8");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedSymmetricKey);
            jwe = jweEncrypter.encrypt(jwe);
            return jwe.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJweException((Throwable)e);
        }
    }

    public String getJSonResponse(User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        Object claimsObj;
        Object value;
        this.log.trace("Building JSON reponse with next scopes {0} for user {1} and user custom attributes {0}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        JsonWebResponse jsonWebResponse = new JsonWebResponse();
        ArrayList<Scope> dynamicScopes = new ArrayList<Scope>();
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeById(scopeName);
            if (scope != null && ScopeType.DYNAMIC == scope.getScopeType()) {
                dynamicScopes.add(scope);
                continue;
            }
            Map<String, Object> claims = this.getClaims(user, scope);
            if (Boolean.TRUE.equals(scope.isOxAuthGroupClaims())) {
                JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                groupClaim.setName(scope.getId());
                for (Map.Entry<String, Object> entry : claims.entrySet()) {
                    String key = entry.getKey();
                    Object value2 = entry.getValue();
                    if (value2 instanceof List) {
                        groupClaim.setClaim(key, (List)value2);
                        continue;
                    }
                    groupClaim.setClaim(key, String.valueOf(value2));
                }
                jsonWebResponse.getClaims().setClaim(scope.getId(), groupClaim);
            } else {
                for (Map.Entry entry : claims.entrySet()) {
                    String key = (String)entry.getKey();
                    value = entry.getValue();
                    if (value instanceof List) {
                        jsonWebResponse.getClaims().setClaim(key, (List)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        jsonWebResponse.getClaims().setClaim(key, (Boolean)value);
                        continue;
                    }
                    if (value instanceof Date) {
                        jsonWebResponse.getClaims().setClaim(key, Long.valueOf(((Date)value).getTime()));
                        continue;
                    }
                    jsonWebResponse.getClaims().setClaim(key, String.valueOf(value));
                }
            }
            jsonWebResponse.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute("inum"));
        }
        if (authorizationGrant.getClaims() != null && (claimsObj = new JSONObject(authorizationGrant.getClaims())).has("userinfo")) {
            JSONObject userInfoObj = claimsObj.getJSONObject("userinfo");
            Iterator it = userInfoObj.keys();
            while (it.hasNext()) {
                String ldapClaimName;
                Object attribute;
                String claimName = (String)it.next();
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claimName);
                if (gluuAttribute == null || (attribute = user.getAttribute(ldapClaimName = gluuAttribute.getName(), optional, gluuAttribute.getOxMultiValuedAttribute().booleanValue())) == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value3 = jsonArray.optString(i);
                        if (value3 == null) continue;
                        values.add(value3);
                    }
                    jsonWebResponse.getClaims().setClaim(claimName, values);
                    continue;
                }
                String value2 = String.valueOf(attribute);
                jsonWebResponse.getClaims().setClaim(claimName, value2);
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember().getClaims()) {
                String string;
                Object attribute;
                Client client;
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null || !this.validateRequesteClaim(gluuAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes) || (attribute = user.getAttribute(string = gluuAttribute.getName(), optional, gluuAttribute.getOxMultiValuedAttribute().booleanValue())) == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value4 = jsonArray.optString(i);
                        if (value4 == null) continue;
                        values.add(value4);
                    }
                    jsonWebResponse.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                value = String.valueOf(attribute);
                jsonWebResponse.getClaims().setClaim(claim.getName(), value);
            }
        }
        if (authorizationGrant.getClient().getSubjectType() != null && SubjectType.fromString((String)authorizationGrant.getClient().getSubjectType()).equals((Object)SubjectType.PAIRWISE) && (StringUtils.isNotBlank((String)authorizationGrant.getClient().getSectorIdentifierUri()) || authorizationGrant.getClient().getRedirectUris() != null)) {
            String clientId;
            String sectorIdentifierUri = null;
            sectorIdentifierUri = StringUtils.isNotBlank((String)authorizationGrant.getClient().getSectorIdentifierUri()) ? authorizationGrant.getClient().getSectorIdentifierUri() : authorizationGrant.getClient().getRedirectUris()[0];
            String userInum = authorizationGrant.getUser().getAttribute("inum");
            PairwiseIdentifier pairwiseIdentifier = this.pairwiseIdentifierService.findPairWiseIdentifier(userInum, sectorIdentifierUri, clientId = authorizationGrant.getClientId());
            if (pairwiseIdentifier == null) {
                pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, clientId, userInum);
                pairwiseIdentifier.setId(UUID.randomUUID().toString());
                pairwiseIdentifier.setDn(this.pairwiseIdentifierService.getDnForPairwiseIdentifier(pairwiseIdentifier.getId(), userInum));
                this.pairwiseIdentifierService.addPairwiseIdentifier(userInum, pairwiseIdentifier);
            }
            jsonWebResponse.getClaims().setSubjectIdentifier(pairwiseIdentifier.getId());
        } else {
            if (authorizationGrant.getClient().getSubjectType() != null && SubjectType.fromString((String)authorizationGrant.getClient().getSubjectType()).equals((Object)SubjectType.PAIRWISE)) {
                this.log.warn("Unable to calculate the pairwise subject identifier because the client hasn't a redirect uri. A public subject identifier will be used instead.");
            }
            String openidSubAttribute = this.appConfiguration.getOpenidSubAttribute();
            String subValue = authorizationGrant.getUser().getAttribute(openidSubAttribute);
            if (StringHelper.equalsIgnoreCase((String)openidSubAttribute, (String)"uid")) {
                subValue = authorizationGrant.getUser().getUserId();
            }
            jsonWebResponse.getClaims().setSubjectIdentifier(subValue);
        }
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, jsonWebResponse, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        return jsonWebResponse.toString();
    }

    public boolean validateRequesteClaim(GluuAttribute gluuAttribute, String[] clientAllowedClaims, Collection<String> scopes) {
        if (gluuAttribute != null) {
            if (clientAllowedClaims != null) {
                for (int i = 0; i < clientAllowedClaims.length; ++i) {
                    if (!gluuAttribute.getDn().equals(clientAllowedClaims[i])) continue;
                    return true;
                }
            }
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeById(scopeName);
                if (scope == null || scope.getOxAuthClaims() == null) continue;
                for (String claimDn : scope.getOxAuthClaims()) {
                    if (!gluuAttribute.getDisplayName().equals(this.attributeService.getAttributeByDn(claimDn).getDisplayName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Map<String, Object> getClaims(User user, Scope scope) throws InvalidClaimException, ParseException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (scope != null && scope.getOxAuthClaims() != null) {
            for (String claimDn : scope.getOxAuthClaims()) {
                Object value;
                GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                String claimName = gluuAttribute.getOxAuthClaimName();
                String ldapName = gluuAttribute.getName();
                Object attribute = null;
                if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
                if (ldapName.equals("uid")) {
                    attribute = user.getUserId();
                } else if (AttributeDataType.BOOLEAN.equals((Object)gluuAttribute.getDataType())) {
                    value = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                    attribute = value instanceof String ? Boolean.valueOf(Boolean.parseBoolean(String.valueOf(value))) : value;
                } else if (AttributeDataType.DATE.equals((Object)gluuAttribute.getDataType())) {
                    value = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                    if (value instanceof Date) {
                        attribute = value;
                    } else if (value != null) {
                        attribute = this.entryManager.decodeTime(user.getDn(), value.toString());
                    }
                } else {
                    attribute = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                }
                if (attribute == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value2 = jsonArray.optString(i);
                        if (value2 == null) continue;
                        values.add(value2);
                    }
                    claims.put(claimName, values);
                    continue;
                }
                claims.put(claimName, attribute);
            }
        }
        return claims;
    }
}

