/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.PermissionTicket;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.model.uma.UmaPermissionList;
import org.gluu.oxauth.service.token.TokenService;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaValidationService;
import org.gluu.oxauth.util.ServerUtil;
import org.slf4j.Logger;

@Path(value="/host/rsrc_pr")
@Api(value="/host/rsrc_pr", description="The resource server uses the protection API's permission registration endpoint to register a requested permission with the authorization server that would suffice for the client's access attempt. The authorization server returns a permission ticket for the resource server to give to the client in its response. The PAT provided in the API request implicitly identifies the resource owner (\"subject\") to which the permission applies.\n\nNote: The resource server is free to choose the extent of the requested permission that it registers, as long as it minimally suffices for the access attempted by the client. For example, it can choose to register a permission that covers several scopes or a resource set that is greater in extent than the specific resource that the client attempted to access. Likewise, the authorization server is ultimately free to choose to partially fulfill the elements of a permission request based on incomplete satisfaction of policy criteria, or not to fulfill the request.\n\nThe resource server uses the POST method at the endpoint. The body of the HTTP request message contains a JSON object providing the requested permission, using a format derived from the scope description format specified in [OAuth-resource-reg], as follows. The object has the following properties:")
public class UmaPermissionRegistrationWS {
    @Inject
    private Logger log;
    @Inject
    private TokenService tokenService;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaValidationService umaValidationService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Registers permission using the POST method", consumes="application/json", produces="application/json", notes="The resource server uses the POST method at the endpoint. The body of the HTTP request message contains a JSON object providing the requested permission, using a format derived from the scope description format specified in [OAuth-resource-reg], as follows. The object has the following properties:")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=400, message="Bad Request")})
    public Response registerPermission(@Context HttpServletRequest request, @HeaderParam(value="Authorization") String authorization, @ApiParam(value="The identifier for a resource to which this client is seeking access. The identifier MUST correspond to a resource set that was previously registered.", required=true) String requestAsString) {
        try {
            this.umaValidationService.assertHasProtectionScope(authorization);
            UmaPermissionList permissionList = this.parseRequest(requestAsString);
            this.umaValidationService.validatePermissions(permissionList);
            String ticket = this.permissionService.addPermission(permissionList, this.tokenService.getClientDn(authorization));
            return Response.status((Response.Status)Response.Status.CREATED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new PermissionTicket(ticket)).build();
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            this.log.error("Exception happened", (Throwable)ex);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Internal error.");
        }
    }

    private UmaPermissionList parseRequest(String requestAsString) {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        try {
            UmaPermission permission = (UmaPermission)mapper.readValue(requestAsString, UmaPermission.class);
            return new UmaPermissionList().addPermission(permission);
        }
        catch (IOException permission) {
            try {
                UmaPermissionList permissions = (UmaPermissionList)mapper.readValue(requestAsString, UmaPermissionList.class);
                if (!permissions.isEmpty()) {
                    return permissions;
                }
                this.log.error("Permission list is empty.");
            }
            catch (IOException e) {
                this.log.error("Failed to parse uma permission request" + requestAsString, (Throwable)e);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_PERMISSION_REQUEST, "Failed to parse uma permission request.");
        }
    }
}

