/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.persistence.UmaPermission;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.external.ExternalUmaClaimsGatheringService;
import org.gluu.oxauth.uma.authorization.UmaGatherContext;
import org.gluu.oxauth.uma.authorization.UmaWebException;
import org.gluu.oxauth.uma.service.UmaPctService;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaSessionService;
import org.gluu.oxauth.uma.service.UmaValidationService;
import org.slf4j.Logger;

@Path(value="/uma/gather_claims")
public class UmaGatheringWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaValidationService validationService;
    @Inject
    private ExternalUmaClaimsGatheringService external;
    @Inject
    private UmaSessionService sessionService;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UserService userService;

    public Response gatherClaims(String clientId, String ticket, String claimRedirectUri, String state, Boolean reset, Boolean authenticationRedirect, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        block6: {
            try {
                this.log.trace("gatherClaims client_id: {}, ticket: {}, claims_redirect_uri: {}, state: {}, authenticationRedirect: {}, queryString: {}", new Object[]{clientId, ticket, claimRedirectUri, state, authenticationRedirect, httpRequest.getQueryString()});
                SessionId session = this.sessionService.getSession(httpRequest, httpResponse);
                if (authenticationRedirect != null && authenticationRedirect.booleanValue()) {
                    this.log.debug("Authentication redirect, restoring parameters from session ...");
                    if (session == null) {
                        this.log.error("Session is null however authentication=true. Wrong workflow! Please correct custom Glaims-Gathering Script.");
                        throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_SESSION, "Session is null however authentication=true. Wrong workflow! Please correct custom Glaims-Gathering Script.");
                    }
                    clientId = this.sessionService.getClientId(session);
                    ticket = this.sessionService.getTicket(session);
                    claimRedirectUri = this.sessionService.getClaimsRedirectUri(session);
                    state = this.sessionService.getState(session);
                    this.log.debug("Restored parameters from session, clientId: {}, ticket: {}, claims_redirect_uri: {}, state: {}", new Object[]{clientId, ticket, claimRedirectUri, state});
                }
                this.validationService.validateClientAndClaimsRedirectUri(clientId, claimRedirectUri, state);
                List<UmaPermission> permissions = this.validationService.validateTicketWithRedirect(ticket, claimRedirectUri, state);
                Object[] scriptNames = this.validationService.validatesGatheringScriptNames(UmaGatheringWS.getScriptNames(permissions), claimRedirectUri, state);
                CustomScriptConfiguration script = this.external.determineScript((String[])scriptNames);
                if (script == null) {
                    this.log.error("Failed to determine claims-gathering script for names: " + Arrays.toString(scriptNames));
                    throw new UmaWebException(claimRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLAIMS_GATHERING_SCRIPT_NAME, state);
                }
                this.sessionService.configure(session, script.getName(), reset, permissions, clientId, claimRedirectUri, state);
                UmaGatherContext context = new UmaGatherContext(script.getConfigurationAttributes(), httpRequest, session, this.sessionService, this.permissionService, this.pctService, new HashMap<String, String>(), this.userService, null, this.appConfiguration);
                int step = this.sessionService.getStep(session);
                int stepsCount = this.external.getStepsCount(script, context);
                if (step < stepsCount) {
                    String page = this.external.getPageForStep(script, step, context);
                    context.persist();
                    String baseEndpoint = StringUtils.removeEnd((String)this.appConfiguration.getBaseEndpoint(), (String)"/");
                    baseEndpoint = StringUtils.removeEnd((String)baseEndpoint, (String)"restv1");
                    baseEndpoint = StringUtils.removeEnd((String)baseEndpoint, (String)"/");
                    String fullUri = baseEndpoint + page;
                    fullUri = StringUtils.removeEnd((String)fullUri, (String)".xhtml") + ".htm";
                    this.log.trace("Redirecting to page: '{}', fullUri: {}", (Object)page, (Object)fullUri);
                    return Response.status((Response.Status)Response.Status.FOUND).location(new URI(fullUri)).build();
                }
                this.log.error("Step '{}' is more or equal to stepCount: '{}'", (Object)stepsCount);
            }
            catch (Exception ex) {
                this.log.error("Exception happened", (Throwable)ex);
                if (!(ex instanceof WebApplicationException)) break block6;
                throw (WebApplicationException)((Object)ex);
            }
        }
        this.log.error("Failed to handle call to UMA Claims Gathering Endpoint.");
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Failed to handle call to UMA Claims Gathering Endpoint.");
    }

    private static String getScriptNames(List<UmaPermission> permissions) {
        return (String)permissions.get(0).getAttributes().get("gathering_id");
    }

    @GET
    @Produces(value={"application/json"})
    public Response getGatherClaims(@QueryParam(value="client_id") String clientId, @QueryParam(value="ticket") String ticket, @QueryParam(value="claims_redirect_uri") String claimRedirectUri, @QueryParam(value="state") String state, @QueryParam(value="reset") Boolean reset, @QueryParam(value="authentication") Boolean authenticationRedirect, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.gatherClaims(clientId, ticket, claimRedirectUri, state, reset, authenticationRedirect, httpRequest, httpResponse);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postGatherClaims(@FormParam(value="client_id") String clientId, @FormParam(value="ticket") String ticket, @FormParam(value="claims_redirect_uri") String claimRedirectUri, @FormParam(value="state") String state, @FormParam(value="reset") Boolean reset, @FormParam(value="authentication") Boolean authenticationRedirect, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.gatherClaims(clientId, ticket, claimRedirectUri, state, reset, authenticationRedirect, httpRequest, httpResponse);
    }
}

