/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gluu.model.GluuAttribute;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.oxauth.service.external.ExternalDynamicScopeService;
import org.gluu.oxauth.util.ServerUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/.well-known/openid-configuration"})
public class OpenIdConfiguration
extends HttpServlet {
    private static final long serialVersionUID = -8224898157373678903L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private AttributeService attributeService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        HttpServletResponse httpResponse = servletResponse;
        httpResponse.setContentType("application/json");
        try (PrintWriter out = httpResponse.getWriter();){
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("issuer", (Object)this.appConfiguration.getIssuer());
            jsonObj.put("authorization_endpoint", (Object)this.appConfiguration.getAuthorizationEndpoint());
            jsonObj.put("token_endpoint", (Object)this.appConfiguration.getTokenEndpoint());
            jsonObj.put("token_revocation_endpoint", (Object)this.appConfiguration.getTokenRevocationEndpoint());
            jsonObj.put("revocation_endpoint", (Object)this.appConfiguration.getTokenRevocationEndpoint());
            jsonObj.put("userinfo_endpoint", (Object)this.appConfiguration.getUserInfoEndpoint());
            jsonObj.put("clientinfo_endpoint", (Object)this.appConfiguration.getClientInfoEndpoint());
            jsonObj.put("check_session_iframe", (Object)this.appConfiguration.getCheckSessionIFrame());
            jsonObj.put("end_session_endpoint", (Object)this.appConfiguration.getEndSessionEndpoint());
            jsonObj.put("jwks_uri", (Object)this.appConfiguration.getJwksUri());
            jsonObj.put("registration_endpoint", (Object)this.appConfiguration.getRegistrationEndpoint());
            jsonObj.put("id_generation_endpoint", (Object)this.appConfiguration.getIdGenerationEndpoint());
            jsonObj.put("introspection_endpoint", (Object)this.appConfiguration.getIntrospectionEndpoint());
            JSONArray responseTypesSupported = new JSONArray();
            for (Object responseTypes : this.appConfiguration.getResponseTypesSupported()) {
                responseTypesSupported.put((Object)StringUtils.implode((Collection)responseTypes, (String)" "));
            }
            if (responseTypesSupported.length() > 0) {
                jsonObj.put("response_types_supported", (Object)responseTypesSupported);
            }
            JSONArray responseModesSupported = new JSONArray();
            if (this.appConfiguration.getResponseModesSupported() != null) {
                for (Object responseMode : this.appConfiguration.getResponseModesSupported()) {
                    responseModesSupported.put(responseMode);
                }
            }
            if (responseModesSupported.length() > 0) {
                jsonObj.put("response_modes_supported", (Object)responseModesSupported);
            }
            JSONArray grantTypesSupported = new JSONArray();
            for (Object grantType : this.appConfiguration.getGrantTypesSupported()) {
                grantTypesSupported.put(grantType);
            }
            if (grantTypesSupported.length() > 0) {
                jsonObj.put("grant_types_supported", (Object)grantTypesSupported);
            }
            JSONArray acrValuesSupported = new JSONArray();
            for (String string : this.externalAuthenticationService.getAcrValuesList()) {
                acrValuesSupported.put((Object)string);
            }
            jsonObj.put("acr_values_supported", (Object)acrValuesSupported);
            jsonObj.put("auth_level_mapping", (Object)this.createAuthLevelMapping());
            JSONArray subjectTypesSupported = new JSONArray();
            for (Object subjectType : this.appConfiguration.getSubjectTypesSupported()) {
                subjectTypesSupported.put(subjectType);
            }
            if (subjectTypesSupported.length() > 0) {
                jsonObj.put("subject_types_supported", (Object)subjectTypesSupported);
            }
            JSONArray jSONArray = new JSONArray();
            for (Object userInfoSigningAlg : this.appConfiguration.getUserInfoSigningAlgValuesSupported()) {
                jSONArray.put(userInfoSigningAlg);
            }
            if (jSONArray.length() > 0) {
                jsonObj.put("userinfo_signing_alg_values_supported", (Object)jSONArray);
            }
            JSONArray userInfoEncryptionAlgValuesSupported = new JSONArray();
            for (Object userInfoEncryptionAlg : this.appConfiguration.getUserInfoEncryptionAlgValuesSupported()) {
                userInfoEncryptionAlgValuesSupported.put(userInfoEncryptionAlg);
            }
            if (userInfoEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("userinfo_encryption_alg_values_supported", (Object)userInfoEncryptionAlgValuesSupported);
            }
            JSONArray userInfoEncryptionEncValuesSupported = new JSONArray();
            for (Object userInfoEncryptionEnc : this.appConfiguration.getUserInfoEncryptionEncValuesSupported()) {
                userInfoEncryptionEncValuesSupported.put(userInfoEncryptionEnc);
            }
            if (userInfoEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("userinfo_encryption_enc_values_supported", (Object)userInfoEncryptionAlgValuesSupported);
            }
            JSONArray idTokenSigningAlgValuesSupported = new JSONArray();
            for (Object idTokenSigningAlg : this.appConfiguration.getIdTokenSigningAlgValuesSupported()) {
                idTokenSigningAlgValuesSupported.put(idTokenSigningAlg);
            }
            if (idTokenSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("id_token_signing_alg_values_supported", (Object)idTokenSigningAlgValuesSupported);
            }
            JSONArray idTokenEncryptionAlgValuesSupported = new JSONArray();
            for (Object idTokenEncryptionAlg : this.appConfiguration.getIdTokenEncryptionAlgValuesSupported()) {
                idTokenEncryptionAlgValuesSupported.put(idTokenEncryptionAlg);
            }
            if (idTokenEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("id_token_encryption_alg_values_supported", (Object)idTokenEncryptionAlgValuesSupported);
            }
            JSONArray idTokenEncryptionEncValuesSupported = new JSONArray();
            for (Object idTokenEncryptionEnc : this.appConfiguration.getIdTokenEncryptionEncValuesSupported()) {
                idTokenEncryptionEncValuesSupported.put(idTokenEncryptionEnc);
            }
            if (idTokenEncryptionEncValuesSupported.length() > 0) {
                jsonObj.put("id_token_encryption_enc_values_supported", (Object)idTokenEncryptionEncValuesSupported);
            }
            JSONArray requestObjectSigningAlgValuesSupported = new JSONArray();
            for (Object requestObjectSigningAlg : this.appConfiguration.getRequestObjectSigningAlgValuesSupported()) {
                requestObjectSigningAlgValuesSupported.put(requestObjectSigningAlg);
            }
            if (requestObjectSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("request_object_signing_alg_values_supported", (Object)requestObjectSigningAlgValuesSupported);
            }
            JSONArray requestObjectEncryptionAlgValuesSupported = new JSONArray();
            for (Object requestObjectEncryptionAlg : this.appConfiguration.getRequestObjectEncryptionAlgValuesSupported()) {
                requestObjectEncryptionAlgValuesSupported.put(requestObjectEncryptionAlg);
            }
            if (requestObjectEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("request_object_encryption_alg_values_supported", (Object)requestObjectEncryptionAlgValuesSupported);
            }
            JSONArray requestObjectEncryptionEncValuesSupported = new JSONArray();
            for (Object requestObjectEncryptionEnc : this.appConfiguration.getRequestObjectEncryptionEncValuesSupported()) {
                requestObjectEncryptionEncValuesSupported.put(requestObjectEncryptionEnc);
            }
            if (requestObjectEncryptionEncValuesSupported.length() > 0) {
                jsonObj.put("request_object_encryption_enc_values_supported", (Object)requestObjectEncryptionEncValuesSupported);
            }
            JSONArray tokenEndpointAuthMethodsSupported = new JSONArray();
            for (Object tokenEndpointAuthMethod : this.appConfiguration.getTokenEndpointAuthMethodsSupported()) {
                tokenEndpointAuthMethodsSupported.put(tokenEndpointAuthMethod);
            }
            if (tokenEndpointAuthMethodsSupported.length() > 0) {
                jsonObj.put("token_endpoint_auth_methods_supported", (Object)tokenEndpointAuthMethodsSupported);
            }
            JSONArray tokenEndpointAuthSigningAlgValuesSupported = new JSONArray();
            for (Object tokenEndpointAuthSigningAlg : this.appConfiguration.getTokenEndpointAuthSigningAlgValuesSupported()) {
                tokenEndpointAuthSigningAlgValuesSupported.put(tokenEndpointAuthSigningAlg);
            }
            if (tokenEndpointAuthSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("token_endpoint_auth_signing_alg_values_supported", (Object)tokenEndpointAuthSigningAlgValuesSupported);
            }
            JSONArray displayValuesSupported = new JSONArray();
            for (Object display : this.appConfiguration.getDisplayValuesSupported()) {
                displayValuesSupported.put(display);
            }
            if (displayValuesSupported.length() > 0) {
                jsonObj.put("display_values_supported", (Object)displayValuesSupported);
            }
            JSONArray claimTypesSupported = new JSONArray();
            for (Object claimType : this.appConfiguration.getClaimTypesSupported()) {
                claimTypesSupported.put(claimType);
            }
            if (claimTypesSupported.length() > 0) {
                jsonObj.put("claim_types_supported", (Object)claimTypesSupported);
            }
            jsonObj.put("service_documentation", (Object)this.appConfiguration.getServiceDocumentation());
            JSONArray idTokenTokenBindingCnfValuesSupported = new JSONArray();
            for (Object value : this.appConfiguration.getIdTokenTokenBindingCnfValuesSupported()) {
                idTokenTokenBindingCnfValuesSupported.put(value);
            }
            jsonObj.put("id_token_token_binding_cnf_values_supported", (Object)idTokenTokenBindingCnfValuesSupported);
            JSONArray claimsLocalesSupported = new JSONArray();
            for (Object claimLocale : this.appConfiguration.getClaimsLocalesSupported()) {
                claimsLocalesSupported.put(claimLocale);
            }
            if (claimsLocalesSupported.length() > 0) {
                jsonObj.put("claims_locales_supported", (Object)claimsLocalesSupported);
            }
            JSONArray uiLocalesSupported = new JSONArray();
            for (String uiLocale : this.appConfiguration.getUiLocalesSupported()) {
                uiLocalesSupported.put((Object)uiLocale);
            }
            if (uiLocalesSupported.length() > 0) {
                jsonObj.put("ui_locales_supported", (Object)uiLocalesSupported);
            }
            JSONArray scopesSupported = new JSONArray();
            JSONArray claimsSupported = new JSONArray();
            JSONArray scopeToClaimsMapping = this.createScopeToClaimsMapping(scopesSupported, claimsSupported);
            if (scopesSupported.length() > 0) {
                jsonObj.put("scopes_supported", (Object)scopesSupported);
            }
            if (claimsSupported.length() > 0) {
                jsonObj.put("claims_supported", (Object)claimsSupported);
            }
            jsonObj.put("scope_to_claims_mapping", (Object)scopeToClaimsMapping);
            jsonObj.put("claims_parameter_supported", (Object)this.appConfiguration.getClaimsParameterSupported());
            jsonObj.put("request_parameter_supported", (Object)this.appConfiguration.getRequestParameterSupported());
            jsonObj.put("request_uri_parameter_supported", (Object)this.appConfiguration.getRequestUriParameterSupported());
            jsonObj.put("require_request_uri_registration", (Object)this.appConfiguration.getRequireRequestUriRegistration());
            jsonObj.put("op_policy_uri", (Object)this.appConfiguration.getOpPolicyUri());
            jsonObj.put("op_tos_uri", (Object)this.appConfiguration.getOpTosUri());
            jsonObj.put("tls_client_certificate_bound_access_tokens", (Object)Boolean.TRUE);
            jsonObj.put("frontchannel_logout_supported", (Object)Boolean.TRUE);
            jsonObj.put("frontchannel_logout_session_supported", (Object)Boolean.TRUE);
            jsonObj.put("frontchannel_logout_session_supported", (Object)this.appConfiguration.getFrontChannelLogoutSessionSupported());
            out.println(ServerUtil.toPrettyJson(jsonObj).replace("\\/", "/"));
        }
    }

    @Deprecated
    private JSONArray createScopeToClaimsMapping(JSONArray scopesSupported, JSONArray claimsSupported) {
        JSONArray scopeToClaimMapping = new JSONArray();
        HashSet<String> scopes = new HashSet<String>();
        HashSet<String> claims = new HashSet<String>();
        try {
            for (Scope scope : this.scopeService.getAllScopesList()) {
                JSONArray claimsList = new JSONArray();
                JSONObject mapping = new JSONObject();
                mapping.put(scope.getId(), (Object)claimsList);
                scopes.add(scope.getId());
                scopeToClaimMapping.put((Object)mapping);
                if (ScopeType.DYNAMIC.equals((Object)scope.getScopeType())) {
                    List<String> claimNames = this.externalDynamicScopeService.executeExternalGetSupportedClaimsMethods(Arrays.asList(scope));
                    for (String claimName : claimNames) {
                        if (!org.apache.commons.lang.StringUtils.isNotBlank((String)claimName)) continue;
                        claimsList.put((Object)claimName);
                        claims.add(claimName);
                    }
                    continue;
                }
                List claimIdList = scope.getOxAuthClaims();
                if (claimIdList == null || claimIdList.isEmpty()) continue;
                for (String claimDn : claimIdList) {
                    GluuAttribute attribute = this.attributeService.getAttributeByDn(claimDn);
                    String claimName = attribute.getOxAuthClaimName();
                    if (!org.apache.commons.lang.StringUtils.isNotBlank((String)claimName)) continue;
                    claimsList.put((Object)claimName);
                    claims.add(claimName);
                }
            }
            for (String string : scopes) {
                scopesSupported.put((Object)string);
            }
            for (String string : claims) {
                claimsSupported.put((Object)string);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return scopeToClaimMapping;
    }

    @Deprecated
    private JSONObject createAuthLevelMapping() {
        JSONObject mappings = new JSONObject();
        try {
            Map<Integer, Set<String>> map = this.externalAuthenticationService.levelToAcrMapping();
            for (Integer level : map.keySet()) {
                mappings.put(level.toString(), (Collection)map.get(level));
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return mappings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "OpenID Provider Configuration Information";
    }
}

