/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.fido.u2f;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Stateless
@Named(value="u2fValidationService")
public class ValidationService {
    @Inject
    private Logger log;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private UserService userService;

    public boolean isValidSessionId(String userName, String sessionId) {
        if (sessionId == null) {
            this.log.error("In two step authentication workflow session_id is mandatory");
            return false;
        }
        SessionId ldapSessionId = this.sessionIdService.getSessionId(sessionId);
        if (ldapSessionId == null) {
            this.log.error("Specified session_id '{}' is invalid", (Object)sessionId);
            return false;
        }
        String sessionIdUser = ldapSessionId.getSessionAttributes().get("auth_user");
        if (!StringHelper.equalsIgnoreCase((String)userName, (String)sessionIdUser)) {
            this.log.error("Username '{}' and session_id '{}' don't match", (Object)userName, (Object)sessionId);
            return false;
        }
        return true;
    }

    public boolean isValidEnrollmentCode(String userName, String enrollmentCode) {
        if (enrollmentCode == null) {
            this.log.error("In two step authentication workflow enrollment_code is mandatory");
            return false;
        }
        User user = this.userService.getUser(userName, new String[]{"oxEnrollmentCode"});
        if (user == null) {
            this.log.error("Specified user_name '{}' is invalid", (Object)userName);
            return false;
        }
        String userEnrollmentCode = user.getAttribute("oxEnrollmentCode");
        if (userEnrollmentCode == null) {
            this.log.error("Specified enrollment_code '{}' is invalid", (Object)enrollmentCode);
            return false;
        }
        if (!StringHelper.equalsIgnoreCase((String)userEnrollmentCode, (String)enrollmentCode)) {
            this.log.error("Username '{}' and enrollment_code '{}' don't match", (Object)userName, (Object)enrollmentCode);
            return false;
        }
        return true;
    }
}

