/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.unboundid.ldap.sdk.LDAPException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.exception.AcrChangedException;
import org.gluu.oxauth.model.exception.InvalidSessionStateException;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtSubClaimObject;
import org.gluu.oxauth.model.token.JwtSigner;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.RequestParameterService;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.external.ExternalApplicationSessionService;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.service.CacheService;
import org.gluu.util.StringHelper;
import org.json.JSONException;
import org.slf4j.Logger;

@RequestScoped
@Named
public class SessionIdService {
    public static final String SESSION_STATE_COOKIE_NAME = "session_state";
    public static final String OP_BROWSER_STATE = "opbs";
    public static final String SESSION_ID_COOKIE_NAME = "session_id";
    public static final String RP_ORIGIN_ID_COOKIE_NAME = "rp_origin_id";
    public static final String UMA_SESSION_ID_COOKIE_NAME = "uma_session_id";
    public static final String CONSENT_SESSION_ID_COOKIE_NAME = "consent_session_id";
    public static final String SESSION_CUSTOM_STATE = "session_custom_state";
    @Inject
    private Logger log;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private CacheService cacheService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private UserService userService;

    public String getAcr(SessionId session) {
        if (session == null) {
            return null;
        }
        String acr = session.getSessionAttributes().get("acr");
        if (StringUtils.isBlank((String)acr)) {
            acr = session.getSessionAttributes().get("acr_values");
        }
        return acr;
    }

    public SessionId assertAuthenticatedSessionCorrespondsToNewRequest(SessionId session, String acrValuesStr) throws AcrChangedException {
        if (session != null && !session.getSessionAttributes().isEmpty() && session.getState() == SessionIdState.AUTHENTICATED) {
            boolean isAcrChanged;
            Map<String, String> sessionAttributes = session.getSessionAttributes();
            String sessionAcr = this.getAcr(session);
            if (StringUtils.isBlank((String)sessionAcr)) {
                this.log.trace("Failed to fetch acr from session, attributes: " + sessionAttributes);
                return session;
            }
            List<String> acrValuesList = this.acrValuesList(acrValuesStr);
            boolean bl = isAcrChanged = !acrValuesList.isEmpty() && !acrValuesList.contains(sessionAcr);
            if (isAcrChanged) {
                Map<String, Integer> acrToLevel = this.externalAuthenticationService.acrToLevelMapping();
                Integer sessionAcrLevel = acrToLevel.get(this.externalAuthenticationService.scriptName(sessionAcr));
                for (String acrValue : acrValuesList) {
                    Integer currentAcrLevel = acrToLevel.get(this.externalAuthenticationService.scriptName(acrValue));
                    this.log.info("Acr is changed. Session acr: " + sessionAcr + "(level: " + sessionAcrLevel + "), current acr: " + acrValue + "(level: " + currentAcrLevel + ")");
                    if (currentAcrLevel == null) {
                        throw new AcrChangedException(false);
                    }
                    if (sessionAcrLevel >= currentAcrLevel) continue;
                    throw new AcrChangedException();
                }
                return session;
            }
            this.reinitLogin(session, false);
        }
        return session;
    }

    private static boolean shouldReinitSession(Map<String, String> sessionAttributes, Map<String, String> currentSessionAttributes) {
        HashMap<String, String> copySessionAttributes = new HashMap<String, String>(sessionAttributes);
        HashMap<String, String> copyCurrentSessionAttributes = new HashMap<String, String>(currentSessionAttributes);
        copySessionAttributes.remove("state");
        copyCurrentSessionAttributes.remove("state");
        return !copyCurrentSessionAttributes.equals(copySessionAttributes);
    }

    public void reinitLogin(SessionId session, boolean force) {
        Map<String, String> sessionAttributes = session.getSessionAttributes();
        Map<String, String> currentSessionAttributes = this.getCurrentSessionAttributes(sessionAttributes);
        if (force || SessionIdService.shouldReinitSession(sessionAttributes, currentSessionAttributes)) {
            boolean updateResult;
            sessionAttributes.putAll(currentSessionAttributes);
            sessionAttributes.put("c", "1");
            Iterator<Map.Entry<String, String>> it = currentSessionAttributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> currentSessionAttributesEntry = it.next();
                String name = currentSessionAttributesEntry.getKey();
                if (!name.startsWith("auth_step_passed_")) continue;
                it.remove();
            }
            session.setSessionAttributes(currentSessionAttributes);
            if (force) {
                session.setState(SessionIdState.UNAUTHENTICATED);
            }
            if (!(updateResult = this.updateSessionId(session, true, true, true))) {
                this.log.debug("Failed to update session entry: '{}'", (Object)session.getId());
            }
        }
    }

    public void resetToStep(SessionId session, int resetToStep) {
        Map<String, String> sessionAttributes = session.getSessionAttributes();
        int currentStep = 1;
        if (sessionAttributes.containsKey("auth_step")) {
            currentStep = StringHelper.toInteger((String)sessionAttributes.get("auth_step"), (int)currentStep);
        }
        for (int i = resetToStep; i <= currentStep; ++i) {
            String key = String.format("auth_step_passed_%d", i);
            sessionAttributes.remove(key);
        }
        sessionAttributes.put("auth_step", String.valueOf(resetToStep));
        boolean updateResult = this.updateSessionId(session, true, true, true);
        if (!updateResult) {
            this.log.debug("Failed to update session entry: '{}'", (Object)session.getId());
        }
    }

    private Map<String, String> getCurrentSessionAttributes(Map<String, String> sessionAttributes) {
        if (this.facesContext != null) {
            HashMap<String, String> currentSessionAttributes = new HashMap<String, String>(sessionAttributes);
            Map parameterMap = this.externalContext.getRequestParameterMap();
            Map<String, String> newRequestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
            for (Map.Entry<String, String> newRequestParameterMapEntry : newRequestParameterMap.entrySet()) {
                String name = newRequestParameterMapEntry.getKey();
                if (StringHelper.equalsIgnoreCase((String)name, (String)"auth_step")) continue;
                currentSessionAttributes.put(name, newRequestParameterMapEntry.getValue());
            }
            return currentSessionAttributes;
        }
        return sessionAttributes;
    }

    public String getSessionIdFromCookie(HttpServletRequest request) {
        return this.getValueFromCookie(request, SESSION_ID_COOKIE_NAME);
    }

    public String getUmaSessionIdFromCookie(HttpServletRequest request) {
        return this.getValueFromCookie(request, UMA_SESSION_ID_COOKIE_NAME);
    }

    public String getConsentSessionIdFromCookie(HttpServletRequest request) {
        return this.getValueFromCookie(request, CONSENT_SESSION_ID_COOKIE_NAME);
    }

    public String getSessionStateFromCookie(HttpServletRequest request) {
        return this.getValueFromCookie(request, SESSION_STATE_COOKIE_NAME);
    }

    public String getRpOriginIdCookie() {
        return this.getValueFromCookie(RP_ORIGIN_ID_COOKIE_NAME);
    }

    public String getValueFromCookie(String cookieName) {
        try {
            if (this.facesContext == null) {
                return null;
            }
            HttpServletRequest request = (HttpServletRequest)this.externalContext.getRequest();
            if (request != null) {
                return this.getValueFromCookie(request, cookieName);
            }
            this.log.trace("Faces context returns null for http request object.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getValueFromCookie(HttpServletRequest request, String cookieName) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(cookieName)) continue;
                    this.log.trace("Found session_id cookie: '{}'", (Object)cookie.getValue());
                    return cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public String getSessionIdFromCookie() {
        try {
            if (this.facesContext == null) {
                return null;
            }
            HttpServletRequest request = (HttpServletRequest)this.externalContext.getRequest();
            if (request != null) {
                return this.getSessionIdFromCookie(request);
            }
            this.log.trace("Faces context returns null for http request object.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void creatRpOriginIdCookie(String rpOriginId) {
        try {
            Object response = this.externalContext.getResponse();
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                this.creatRpOriginIdCookie(rpOriginId, httpResponse);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void creatRpOriginIdCookie(String rpOriginId, HttpServletResponse httpResponse) {
        String header = "rp_origin_id=" + rpOriginId;
        header = header + "; Path=" + this.configurationFactory.getContextPath();
        header = header + "; Secure";
        header = header + "; HttpOnly";
        this.createCookie(header, httpResponse);
    }

    public void createSessionIdCookie(String sessionId, String sessionState, String opbs, HttpServletResponse httpResponse, String cookieName) {
        String header = cookieName + "=" + sessionId;
        header = header + "; Path=/";
        header = header + "; Secure";
        header = header + "; HttpOnly";
        this.createCookie(header, httpResponse);
        this.createSessionStateCookie(sessionState, httpResponse);
        this.createOPBrowserStateCookie(opbs, httpResponse);
    }

    public void createSessionIdCookie(String sessionId, String sessionState, String opbs, HttpServletResponse httpResponse, boolean isUma) {
        String cookieName = isUma ? UMA_SESSION_ID_COOKIE_NAME : SESSION_ID_COOKIE_NAME;
        this.createSessionIdCookie(sessionId, sessionState, opbs, httpResponse, cookieName);
    }

    public void createSessionIdCookie(String sessionId, String sessionState, String opbs, boolean isUma) {
        try {
            Object response = this.externalContext.getResponse();
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                this.createSessionIdCookie(sessionId, sessionState, opbs, httpResponse, isUma);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void createSessionStateCookie(String sessionState, HttpServletResponse httpResponse) {
        String header = "session_state=" + sessionState;
        header = header + "; Path=/";
        header = header + "; Secure";
        this.createCookie(header, httpResponse);
    }

    public void createOPBrowserStateCookie(String opbs, HttpServletResponse httpResponse) {
        String header = "opbs=" + opbs;
        header = header + "; Path=/";
        header = header + "; Secure";
        Integer sessionStateLifetime = this.appConfiguration.getSessionIdLifetime();
        if (sessionStateLifetime != null && sessionStateLifetime > 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
            Calendar expirationDate = Calendar.getInstance();
            expirationDate.add(13, sessionStateLifetime);
            header = header + "; Expires=" + formatter.format(expirationDate.getTime()) + ";";
            if (StringUtils.isNotBlank((String)this.appConfiguration.get\u0421ookieDomain())) {
                header = header + "Domain=" + this.appConfiguration.get\u0421ookieDomain() + ";";
            }
        }
        httpResponse.addHeader("Set-Cookie", header);
    }

    protected void createCookie(String header, HttpServletResponse httpResponse) {
        Integer sessionStateLifetime = this.appConfiguration.getSessionIdLifetime();
        if (sessionStateLifetime != null && sessionStateLifetime > 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
            Calendar expirationDate = Calendar.getInstance();
            expirationDate.add(13, sessionStateLifetime);
            header = header + "; Expires=" + formatter.format(expirationDate.getTime()) + ";";
            if (StringUtils.isNotBlank((String)this.appConfiguration.get\u0421ookieDomain())) {
                header = header + "Domain=" + this.appConfiguration.get\u0421ookieDomain() + ";";
            }
        }
        httpResponse.addHeader("Set-Cookie", header);
    }

    public void removeSessionIdCookie(HttpServletResponse httpResponse) {
        this.removeCookie(SESSION_ID_COOKIE_NAME, httpResponse);
    }

    public void removeOPBrowserStateCookie(HttpServletResponse httpResponse) {
        this.removeCookie(OP_BROWSER_STATE, httpResponse);
    }

    public void removeUmaSessionIdCookie(HttpServletResponse httpResponse) {
        this.removeCookie(UMA_SESSION_ID_COOKIE_NAME, httpResponse);
    }

    public void removeConsentSessionIdCookie(HttpServletResponse httpResponse) {
        this.removeCookie(CONSENT_SESSION_ID_COOKIE_NAME, httpResponse);
    }

    public void removeCookie(String cookieName, HttpServletResponse httpResponse) {
        Cookie cookie = new Cookie(cookieName, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        if (StringUtils.isNotBlank((String)this.appConfiguration.get\u0421ookieDomain())) {
            cookie.setDomain(this.appConfiguration.get\u0421ookieDomain());
        }
        httpResponse.addCookie(cookie);
    }

    public SessionId getSessionId() {
        String sessionId = this.getSessionIdFromCookie();
        if (StringHelper.isNotEmpty((String)sessionId)) {
            return this.getSessionId(sessionId);
        }
        this.log.trace("Session cookie not exists");
        return null;
    }

    public Map<String, String> getSessionAttributes(SessionId sessionId) {
        if (sessionId != null) {
            return sessionId.getSessionAttributes();
        }
        return null;
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn) throws InvalidSessionStateException {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("prompt", "");
        return this.generateAuthenticatedSessionId(httpRequest, userDn, sessionIdAttributes);
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn, String prompt) throws InvalidSessionStateException {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("prompt", prompt);
        return this.generateAuthenticatedSessionId(httpRequest, userDn, sessionIdAttributes);
    }

    public SessionId generateAuthenticatedSessionId(HttpServletRequest httpRequest, String userDn, Map<String, String> sessionIdAttributes) throws InvalidSessionStateException {
        SessionId sessionId = this.generateSessionId(userDn, new Date(), SessionIdState.AUTHENTICATED, sessionIdAttributes, true);
        if (this.externalApplicationSessionService.isEnabled()) {
            String userName = sessionId.getSessionAttributes().get("auth_user");
            boolean externalResult = this.externalApplicationSessionService.executeExternalStartSessionMethods(httpRequest, sessionId);
            this.log.info("Start session result for '{}': '{}'", new Object[]{userName, "start", externalResult});
            if (!externalResult) {
                this.reinitLogin(sessionId, true);
                throw new InvalidSessionStateException("Session creation is prohibited by external session script!");
            }
        }
        return sessionId;
    }

    public SessionId generateUnauthenticatedSessionId(String userDn) {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        return this.generateSessionId(userDn, new Date(), SessionIdState.UNAUTHENTICATED, sessionIdAttributes, true);
    }

    public SessionId generateUnauthenticatedSessionId(String userDn, Date authenticationDate, SessionIdState state, Map<String, String> sessionIdAttributes, boolean persist) {
        return this.generateSessionId(userDn, authenticationDate, state, sessionIdAttributes, persist);
    }

    public String computeSessionState(SessionId sessionId, String clientId, String redirectUri) {
        boolean isSameClient;
        boolean bl = isSameClient = clientId.equals(sessionId.getSessionAttributes().get("client_id")) && redirectUri.equals(sessionId.getSessionAttributes().get("redirect_uri"));
        if (isSameClient) {
            return sessionId.getSessionState();
        }
        String salt = UUID.randomUUID().toString();
        String opbs = sessionId.getOPBrowserState();
        String sessionState = this.computeSessionState(clientId, redirectUri, opbs, salt);
        return sessionState;
    }

    private String computeSessionState(String clientId, String redirectUri, String opbs, String salt) {
        try {
            String clientOrigin = this.getClientOrigin(redirectUri);
            String sessionState = JwtUtil.bytesToHex((byte[])JwtUtil.getMessageDigestSHA256((String)(clientId + " " + clientOrigin + " " + opbs + " " + salt))) + "." + salt;
            return sessionState;
        }
        catch (UnsupportedEncodingException | URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException e) {
            this.log.error("Failed generating session state! " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getClientOrigin(String redirectUri) throws URISyntaxException {
        if (StringHelper.isNotEmpty((String)redirectUri)) {
            URI uri = new URI(redirectUri);
            String result = uri.getScheme() + "://" + uri.getHost();
            if (uri.getPort() > 0) {
                result = result + ":" + Integer.toString(uri.getPort());
            }
            return result;
        }
        return this.appConfiguration.getIssuer();
    }

    private SessionId generateSessionId(String userDn, Date authenticationDate, SessionIdState state, Map<String, String> sessionIdAttributes, boolean persist) {
        String sid = UUID.randomUUID().toString();
        String salt = UUID.randomUUID().toString();
        String clientId = sessionIdAttributes.get("client_id");
        String opbs = UUID.randomUUID().toString();
        String redirectUri = sessionIdAttributes.get("redirect_uri");
        String sessionState = this.computeSessionState(clientId, redirectUri, opbs, salt);
        String dn = sid;
        sessionIdAttributes.put(OP_BROWSER_STATE, opbs);
        if (StringUtils.isBlank((String)dn)) {
            return null;
        }
        if (SessionIdState.AUTHENTICATED == state && StringUtils.isBlank((String)userDn)) {
            return null;
        }
        SessionId sessionId = new SessionId();
        sessionId.setId(sid);
        sessionId.setDn(dn);
        sessionId.setUserDn(userDn);
        sessionId.setSessionState(sessionState);
        Boolean sessionAsJwt = this.appConfiguration.getSessionAsJwt();
        sessionId.setIsJwt(sessionAsJwt != null && sessionAsJwt != false);
        if (authenticationDate != null) {
            sessionId.setAuthenticationTime(authenticationDate);
        }
        if (state != null) {
            sessionId.setState(state);
        }
        sessionId.setSessionAttributes(sessionIdAttributes);
        sessionId.setLastUsedAt(new Date());
        if (sessionId.getIsJwt().booleanValue()) {
            sessionId.setJwt(this.generateJwt(sessionId, userDn).asString());
        }
        boolean persisted = false;
        if (persist) {
            persisted = this.persistSessionId(sessionId);
        }
        this.auditLogging(sessionId);
        this.log.trace("Generated new session, id = '{}', state = '{}', asJwt = '{}', persisted = '{}'", new Object[]{sessionId.getId(), sessionId.getState(), sessionId.getIsJwt(), persisted});
        return sessionId;
    }

    private Jwt generateJwt(SessionId sessionId, String audience) {
        try {
            JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, this.webKeysConfiguration, SignatureAlgorithm.RS512, audience);
            Jwt jwt = jwtSigner.newJwt();
            jwt.getClaims().setClaim("id", sessionId.getId());
            jwt.getClaims().setClaim("authentication_time", sessionId.getAuthenticationTime());
            jwt.getClaims().setClaim("user_dn", sessionId.getUserDn());
            jwt.getClaims().setClaim("state", sessionId.getState() != null ? sessionId.getState().getValue() : "");
            jwt.getClaims().setClaim("session_attributes", JwtSubClaimObject.fromMap(sessionId.getSessionAttributes()));
            jwt.getClaims().setClaim("last_used_at", sessionId.getLastUsedAt());
            jwt.getClaims().setClaim("permission_granted", sessionId.getPermissionGranted());
            jwt.getClaims().setClaim("permission_granted_map", JwtSubClaimObject.fromBooleanMap(sessionId.getPermissionGrantedMap().getPermissionGranted()));
            jwt.getClaims().setClaim("involved_clients_map", JwtSubClaimObject.fromBooleanMap(sessionId.getInvolvedClients().getPermissionGranted()));
            return jwtSigner.sign();
        }
        catch (Exception e) {
            this.log.error("Failed to sign session jwt! " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public SessionId setSessionIdStateAuthenticated(HttpServletRequest httpRequest, SessionId sessionId, String p_userDn) {
        sessionId.setUserDn(p_userDn);
        sessionId.setAuthenticationTime(new Date());
        sessionId.setState(SessionIdState.AUTHENTICATED);
        boolean persisted = this.updateSessionId(sessionId, true, true, true);
        this.auditLogging(sessionId);
        this.log.trace("Authenticated session, id = '{}', state = '{}', persisted = '{}'", new Object[]{sessionId.getId(), sessionId.getState(), persisted});
        if (this.externalApplicationSessionService.isEnabled()) {
            String userName = sessionId.getSessionAttributes().get("auth_user");
            boolean externalResult = this.externalApplicationSessionService.executeExternalStartSessionMethods(httpRequest, sessionId);
            this.log.info("Start session result for '{}': '{}'", new Object[]{userName, "start", externalResult});
            if (!externalResult) {
                this.reinitLogin(sessionId, true);
                throw new InvalidSessionStateException("Session creation is prohibited by external session script!");
            }
        }
        return sessionId;
    }

    public boolean persistSessionId(SessionId sessionId) {
        return this.persistSessionId(sessionId, false);
    }

    public boolean persistSessionId(SessionId sessionId, boolean forcePersistence) {
        List<Prompt> prompts = this.getPromptsFromSessionId(sessionId);
        try {
            int unusedLifetime = this.appConfiguration.getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && this.isPersisted(prompts) || forcePersistence) {
                sessionId.setLastUsedAt(new Date());
                sessionId.setPersisted(true);
                this.log.trace("sessionIdAttributes: " + sessionId.getPermissionGrantedMap());
                this.putInCache(sessionId);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean updateSessionId(SessionId sessionId) {
        return this.updateSessionId(sessionId, true);
    }

    public boolean updateSessionId(SessionId sessionId, boolean updateLastUsedAt) {
        return this.updateSessionId(sessionId, updateLastUsedAt, false, true);
    }

    public boolean updateSessionId(SessionId sessionId, boolean updateLastUsedAt, boolean forceUpdate, boolean modified) {
        List<Prompt> prompts = this.getPromptsFromSessionId(sessionId);
        try {
            int unusedLifetime = this.appConfiguration.getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && this.isPersisted(prompts) || forceUpdate) {
                boolean update = modified;
                if (updateLastUsedAt) {
                    Date lastUsedAt = new Date();
                    if (sessionId.getLastUsedAt() != null) {
                        long diff = lastUsedAt.getTime() - sessionId.getLastUsedAt().getTime();
                        if (diff > 500L) {
                            update = true;
                            sessionId.setLastUsedAt(lastUsedAt);
                        }
                    } else {
                        update = true;
                        sessionId.setLastUsedAt(lastUsedAt);
                    }
                }
                if (!sessionId.isPersisted()) {
                    update = true;
                    sessionId.setPersisted(true);
                }
                if (sessionId.getAuthenticationTime() != null) {
                    long currentLifetimeInSeconds = (System.currentTimeMillis() - sessionId.getAuthenticationTime().getTime()) / 1000L;
                    if (this.appConfiguration.getSessionIdLifetime() != null && this.appConfiguration.getSessionIdLifetime() > 0) {
                        if (currentLifetimeInSeconds > (long)this.appConfiguration.getSessionIdLifetime().intValue()) {
                            this.log.debug("Session id expired: {}, remove it.", (Object)sessionId.getId());
                            this.remove(sessionId);
                            update = false;
                        }
                    } else {
                        this.log.debug("Session id lifetime configuration is null.");
                    }
                }
                if (update) {
                    this.mergeWithRetry(sessionId, 3);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void putInCache(SessionId sessionId) {
        int expirationInSeconds = sessionId.getState() == SessionIdState.UNAUTHENTICATED ? this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime() : (this.appConfiguration.getSessionIdLifetime() != null && this.appConfiguration.getSessionIdLifetime() > 0 ? this.appConfiguration.getSessionIdLifetime() : Integer.MAX_VALUE);
        this.cacheService.put(Integer.toString(expirationInSeconds), sessionId.getId(), (Object)sessionId);
    }

    private SessionId getFromCache(String sessionId) {
        return (SessionId)this.cacheService.get(null, sessionId);
    }

    private SessionId mergeWithRetry(SessionId sessionId, int maxAttempts) {
        EntryPersistenceException lastException = null;
        for (int i = 1; i <= maxAttempts; ++i) {
            try {
                this.putInCache(sessionId);
                return sessionId;
            }
            catch (EntryPersistenceException ex) {
                block6: {
                    block5: {
                        lastException = ex;
                        if (!(ex.getCause() instanceof LDAPException)) break block5;
                        LDAPException parentEx = (LDAPException)ex.getCause();
                        this.log.debug("LDAP exception resultCode: '{}'", (Object)parentEx.getResultCode().intValue());
                        if (parentEx.getResultCode().intValue() == 16 || parentEx.getResultCode().intValue() == 20) break block6;
                    }
                    throw ex;
                }
                this.log.warn("Session entry update attempt '{}' was unsuccessfull", (Object)i);
                continue;
            }
        }
        this.log.error("Session entry update attempt was unsuccessfull after '{}' attempts", (Object)maxAttempts);
        throw lastException;
    }

    public void updateSessionIdIfNeeded(SessionId sessionId, boolean modified) {
        this.updateSessionId(sessionId, true, false, modified);
    }

    private boolean isPersisted(List<Prompt> prompts) {
        if (prompts != null && prompts.contains(Prompt.NONE)) {
            Boolean persistOnPromptNone = this.appConfiguration.getSessionIdPersistOnPromptNone();
            return persistOnPromptNone != null && persistOnPromptNone != false;
        }
        return true;
    }

    public SessionId getSessionById(String sessionId) {
        return this.getFromCache(sessionId);
    }

    public SessionId getSessionId(HttpServletRequest request) {
        return this.getSessionId(this.getSessionIdFromCookie(request));
    }

    public SessionId getSessionId(String sessionId) {
        if (StringHelper.isEmpty((String)sessionId)) {
            return null;
        }
        try {
            SessionId entity = this.getSessionById(sessionId);
            this.log.trace("Try to get session by id: {} ...", (Object)sessionId);
            if (entity != null) {
                this.log.trace("Session dn: {}", (Object)entity.getDn());
                if (this.isSessionValid(entity)) {
                    return entity;
                }
            }
        }
        catch (Exception ex) {
            this.log.trace(ex.getMessage(), (Throwable)ex);
        }
        this.log.trace("Failed to get session by id: {}", (Object)sessionId);
        return null;
    }

    public boolean remove(SessionId sessionId) {
        try {
            this.cacheService.remove(sessionId.getId());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void remove(List<SessionId> list) {
        for (SessionId id : list) {
            try {
                this.remove(id);
            }
            catch (Exception e) {
                this.log.error("Failed to remove entry", (Throwable)e);
            }
        }
    }

    public boolean isSessionValid(SessionId sessionId) {
        if (sessionId == null) {
            return false;
        }
        long sessionInterval = TimeUnit.SECONDS.toMillis(this.appConfiguration.getSessionIdUnusedLifetime());
        long sessionUnauthenticatedInterval = TimeUnit.SECONDS.toMillis(this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime());
        long timeSinceLastAccess = System.currentTimeMillis() - sessionId.getLastUsedAt().getTime();
        if (timeSinceLastAccess > sessionInterval && this.appConfiguration.getSessionIdUnusedLifetime() != -1) {
            return false;
        }
        return sessionId.getState() != SessionIdState.UNAUTHENTICATED || timeSinceLastAccess <= sessionUnauthenticatedInterval || this.appConfiguration.getSessionIdUnauthenticatedUnusedLifetime() == -1;
    }

    private List<Prompt> getPromptsFromSessionId(SessionId sessionId) {
        String promptParam = sessionId.getSessionAttributes().get("prompt");
        return Prompt.fromString((String)promptParam, (String)" ");
    }

    public boolean isSessionIdAuthenticated() {
        SessionId sessionId = this.getSessionId();
        return this.isSessionIdAuthenticated(sessionId);
    }

    public boolean isSessionIdAuthenticated(SessionId sessionId) {
        if (sessionId == null) {
            return false;
        }
        SessionIdState sessionIdState = sessionId.getState();
        return SessionIdState.AUTHENTICATED.equals((Object)sessionIdState);
    }

    public boolean isNotSessionIdAuthenticated() {
        return !this.isSessionIdAuthenticated();
    }

    public List<String> acrValuesList(String acrValues) {
        List acrs;
        try {
            acrs = Util.jsonArrayStringAsList((String)acrValues);
        }
        catch (JSONException ex) {
            acrs = Util.splittedStringAsList((String)acrValues, (String)" ");
        }
        return acrs;
    }

    private void auditLogging(SessionId sessionId) {
        HttpServletRequest httpServletRequest = ServerUtil.getRequestOrNull();
        if (httpServletRequest != null) {
            Action action;
            switch (sessionId.getState()) {
                case AUTHENTICATED: {
                    action = Action.SESSION_AUTHENTICATED;
                    break;
                }
                case UNAUTHENTICATED: {
                    action = Action.SESSION_UNAUTHENTICATED;
                    break;
                }
                default: {
                    action = Action.SESSION_UNAUTHENTICATED;
                }
            }
            OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpServletRequest), action);
            oAuth2AuditLog.setSuccess(true);
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        }
    }

    public User getUser(SessionId sessionId) {
        if (sessionId == null) {
            return null;
        }
        if (sessionId.getUser() != null) {
            return sessionId.getUser();
        }
        if (StringUtils.isBlank((String)sessionId.getUserDn())) {
            return null;
        }
        User user = this.userService.getUserByDn(sessionId.getUserDn(), new String[0]);
        if (user != null) {
            sessionId.setUser(user);
            return user;
        }
        return null;
    }
}

