/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.security.KeyStoreException;
import java.security.PrivateKey;
import org.apache.log4j.Logger;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.service.cdi.util.CdiUtil;
import org.json.JSONObject;
import org.msgpack.core.Preconditions;

public class ServerCryptoProvider
extends AbstractCryptoProvider {
    private static final Logger LOG = Logger.getLogger(ServerCryptoProvider.class);
    private final ConfigurationFactory configurationFactory = (ConfigurationFactory)CdiUtil.bean(ConfigurationFactory.class);
    private final AbstractCryptoProvider cryptoProvider;

    public ServerCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
        Preconditions.checkNotNull((Object)this.configurationFactory);
        Preconditions.checkNotNull((Object)cryptoProvider);
    }

    public String getKeyId(JSONWebKeySet jsonWebKeySet, Algorithm algorithm, Use use) throws Exception {
        try {
            String kid = this.cryptoProvider.getKeyId(jsonWebKeySet, algorithm, use);
            if (!this.cryptoProvider.getKeys().contains(kid) && this.configurationFactory.reloadConfFromLdap()) {
                return this.cryptoProvider.getKeyId(jsonWebKeySet, algorithm, use);
            }
            return kid;
        }
        catch (KeyStoreException e) {
            LOG.trace((Object)"Try to re-load configuration due to keystore exception (it can be rotated).");
            if (this.configurationFactory.reloadConfFromLdap()) {
                return this.cryptoProvider.getKeyId(jsonWebKeySet, algorithm, use);
            }
            return null;
        }
    }

    public JSONObject generateKey(Algorithm algorithm, Long expirationTime, Use use) throws Exception {
        return this.cryptoProvider.generateKey(algorithm, expirationTime, use);
    }

    public String sign(String signingInput, String keyId, String sharedSecret, SignatureAlgorithm signatureAlgorithm) throws Exception {
        return this.cryptoProvider.sign(signingInput, keyId, sharedSecret, signatureAlgorithm);
    }

    public boolean verifySignature(String signingInput, String encodedSignature, String keyId, JSONObject jwks, String sharedSecret, SignatureAlgorithm signatureAlgorithm) throws Exception {
        return this.cryptoProvider.verifySignature(signingInput, encodedSignature, keyId, jwks, sharedSecret, signatureAlgorithm);
    }

    public boolean deleteKey(String keyId) throws Exception {
        return this.cryptoProvider.deleteKey(keyId);
    }

    public boolean containsKey(String keyId) {
        return this.cryptoProvider.containsKey(keyId);
    }

    public PrivateKey getPrivateKey(String keyId) throws Exception {
        return this.cryptoProvider.getPrivateKey(keyId);
    }
}

