/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.service.BaseCacheService;
import org.gluu.service.CacheService;
import org.gluu.service.LocalCacheService;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Stateless
@Named
public class ScopeService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CacheService cacheService;
    @Inject
    private LocalCacheService localCacheService;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public List<Scope> getAllScopesList() {
        String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
        return this.ldapEntryManager.findEntries(scopesBaseDN, Scope.class, Filter.createPresenceFilter((String)"inum"));
    }

    public List<String> getDefaultScopesDn() {
        ArrayList<String> defaultScopes = new ArrayList<String>();
        for (Scope scope : this.getAllScopesList()) {
            if (!Boolean.TRUE.equals(scope.isDefaultScope())) continue;
            defaultScopes.add(scope.getDn());
        }
        return defaultScopes;
    }

    public List<String> getScopesDn(List<String> scopeNames) {
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scopeName : scopeNames) {
            Scope scope = this.getScopeById(scopeName);
            if (scope == null) continue;
            scopes.add(scope.getDn());
        }
        return scopes;
    }

    public Scope getScopeByDn(String dn) {
        BaseCacheService usedCacheService = this.getCacheService();
        Scope scope = (Scope)usedCacheService.getWithPut(dn, () -> (Scope)this.ldapEntryManager.find(Scope.class, (Object)dn), 60);
        if (scope != null && StringUtils.isNotBlank((String)scope.getId())) {
            usedCacheService.put(scope.getId(), (Object)scope);
        }
        return scope;
    }

    public Scope getScopeByDnSilently(String dn) {
        try {
            return this.getScopeByDn(dn);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Scope getScopeById(String id) {
        BaseCacheService usedCacheService = this.getCacheService();
        Object cached = usedCacheService.get(id);
        if (cached != null) {
            return (Scope)cached;
        }
        String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
        Scope scopeExample = new Scope();
        scopeExample.setDn(scopesBaseDN);
        scopeExample.setId(id);
        List scopes = this.ldapEntryManager.findEntries((Object)scopeExample);
        if (scopes != null && scopes.size() > 0) {
            Scope scope = (Scope)scopes.get(0);
            usedCacheService.put(id, (Object)scope);
            usedCacheService.put(scope.getDn(), (Object)scope);
            return scope;
        }
        return null;
    }

    public List<Scope> getScopeByClaim(String claimDn) {
        List scopes = this.fromCacheByClaimDn(claimDn);
        if (scopes == null) {
            Filter filter = Filter.createEqualityFilter((String)"oxAuthClaim", (Object)claimDn);
            String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
            scopes = this.ldapEntryManager.findEntries(scopesBaseDN, Scope.class, filter);
            this.putInCache(claimDn, scopes);
        }
        return scopes;
    }

    public List<Scope> getScopesByClaim(List<Scope> scopes, String claimDn) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        for (Scope scope : scopes) {
            List claims = scope.getOxAuthClaims();
            if (claims == null || !claims.contains(claimDn)) continue;
            result.add(scope);
        }
        return result;
    }

    private void putInCache(String claimDn, List<Scope> scopes) {
        if (scopes == null) {
            return;
        }
        BaseCacheService usedCacheService = this.getCacheService();
        try {
            String key = ScopeService.getClaimDnCacheKey(claimDn);
            usedCacheService.put(key, scopes);
        }
        catch (Exception ex) {
            this.log.error("Failed to put scopes in cache, claimDn: '{}'", (Object)claimDn, (Object)ex);
        }
    }

    private List<Scope> fromCacheByClaimDn(String claimDn) {
        BaseCacheService usedCacheService = this.getCacheService();
        try {
            String key = ScopeService.getClaimDnCacheKey(claimDn);
            return (List)usedCacheService.get(key);
        }
        catch (Exception ex) {
            this.log.error("Failed to get scopes from cache, claimDn: '{}'", (Object)claimDn, (Object)ex);
            return null;
        }
    }

    private static String getClaimDnCacheKey(String claimDn) {
        return "claim_dn" + StringHelper.toLowerCase((String)claimDn);
    }

    private BaseCacheService getCacheService() {
        if (this.appConfiguration.getUseLocalCache().booleanValue()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }
}

