/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.GluuOrganization;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.service.BaseCacheService;
import org.gluu.service.CacheService;
import org.gluu.service.LocalCacheService;

@Stateless
@Named(value="organizationService")
public class OrganizationService
extends org.gluu.service.OrganizationService {
    private static final long serialVersionUID = -8966940469789981584L;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private CacheService cacheService;
    @Inject
    private LocalCacheService localCacheService;

    public void updateOrganization(GluuOrganization organization) {
        this.ldapEntryManager.merge((Object)organization);
    }

    public GluuOrganization getOrganization() {
        String key;
        BaseCacheService usedCacheService = this.getCacheService();
        GluuOrganization organization = (GluuOrganization)usedCacheService.get(key = "organization");
        if (organization == null) {
            String orgDn = this.getDnForOrganization();
            organization = (GluuOrganization)this.ldapEntryManager.find(GluuOrganization.class, (Object)orgDn);
            usedCacheService.put(key, (Object)organization);
        }
        return organization;
    }

    public String getDnForOrganization() {
        return "o=gluu";
    }

    private BaseCacheService getCacheService() {
        if (this.appConfiguration.getUseLocalCache().booleanValue()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }
}

