/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.token;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.gluu.oxauth.model.common.GrantType;

public class TokenParamsValidator {
    public static boolean validateParams(String grantType, String code, String redirectUri, String username, String password, String scope, String assertion, String refreshToken) {
        boolean result = false;
        if (grantType == null || grantType.isEmpty()) {
            return false;
        }
        GrantType gt = GrantType.fromString((String)grantType);
        switch (gt) {
            case AUTHORIZATION_CODE: {
                result = code != null && !code.isEmpty() && redirectUri != null && !redirectUri.isEmpty();
                break;
            }
            case RESOURCE_OWNER_PASSWORD_CREDENTIALS: {
                result = true;
                break;
            }
            case CLIENT_CREDENTIALS: {
                result = true;
                break;
            }
            case REFRESH_TOKEN: {
                result = refreshToken != null && !refreshToken.isEmpty();
            }
        }
        return result;
    }

    public static boolean validateParams(String clientId, String clientSecret) {
        return clientId != null && !clientId.isEmpty() && clientSecret != null && !clientSecret.isEmpty();
    }

    public static boolean validateGrantType(GrantType requestedGrantType, GrantType[] clientGrantTypesArray, Set<GrantType> grantTypesSupported) {
        if (clientGrantTypesArray == null) {
            return false;
        }
        List<GrantType> clientGrantTypes = Arrays.asList(clientGrantTypesArray);
        return clientGrantTypes.contains(requestedGrantType) && grantTypesSupported.contains(requestedGrantType);
    }
}

