/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.error;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ErrorResponse {
    private static final Logger log = LoggerFactory.getLogger(ErrorResponse.class);
    private String errorDescription;
    private String errorUri;
    private String reason;

    public abstract String getErrorCode();

    public abstract String getState();

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String toQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            queryStringBuilder.append("error=").append(this.getErrorCode());
            if (this.errorDescription != null && !this.errorDescription.isEmpty()) {
                queryStringBuilder.append("&error_description=").append(URLEncoder.encode(this.errorDescription, "UTF-8"));
            }
            if (this.errorUri != null && !this.errorUri.isEmpty()) {
                queryStringBuilder.append("&error_uri=").append(URLEncoder.encode(this.errorUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.reason)) {
                queryStringBuilder.append("&reason=").append(URLEncoder.encode(this.reason, "UTF-8"));
            }
            if (this.getState() != null && !this.getState().isEmpty()) {
                queryStringBuilder.append("&state=").append(this.getState());
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return queryStringBuilder.toString();
    }

    public String toJSonString() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("error", (Object)this.getErrorCode());
            if (this.errorDescription != null && !this.errorDescription.isEmpty()) {
                jsonObj.put("error_description", (Object)this.errorDescription);
            }
            if (this.errorUri != null && !this.errorUri.isEmpty()) {
                jsonObj.put("error_uri", (Object)this.errorUri);
            }
            if (StringUtils.isNotBlank((String)this.reason)) {
                jsonObj.put("reason", (Object)this.reason);
            }
            if (this.getState() != null && !this.getState().isEmpty()) {
                jsonObj.put("state", (Object)this.getState());
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return jsonObj.toString();
    }
}

