/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Inject;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.authorize.ScopeChecker;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCode;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.ExecutionContext;
import org.gluu.oxauth.model.common.IAuthorizationGrant;
import org.gluu.oxauth.model.common.IdToken;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.ldap.TokenLdap;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.util.CertUtils;
import org.gluu.oxauth.util.TokenHashUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizationGrant
implements IAuthorizationGrant {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthorizationGrant.class);
    @Inject
    protected AppConfiguration appConfiguration;
    @Inject
    protected ScopeChecker scopeChecker;
    private User user;
    private AuthorizationGrantType authorizationGrantType;
    private Client client;
    private Set<String> scopes;
    private String grantId;
    private JwtAuthorizationRequest jwtAuthorizationRequest;
    private Date authenticationTime;
    private TokenLdap tokenLdap;
    private AccessToken longLivedAccessToken;
    private IdToken idToken;
    private AuthorizationCode authorizationCode;
    private String tokenBindingHash;
    private String x5cs256;
    private String nonce;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String claims;
    private String acrValues;
    private String sessionDn;
    protected final ConcurrentMap<String, AccessToken> accessTokens = new ConcurrentHashMap<String, AccessToken>();
    protected final ConcurrentMap<String, RefreshToken> refreshTokens = new ConcurrentHashMap<String, RefreshToken>();

    public AbstractAuthorizationGrant() {
    }

    protected AbstractAuthorizationGrant(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        this.init(user, authorizationGrantType, client, authenticationTime);
    }

    protected void init(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        this.authenticationTime = authenticationTime != null ? new Date(authenticationTime.getTime()) : null;
        this.user = user;
        this.authorizationGrantType = authorizationGrantType;
        this.client = client;
        this.scopes = new CopyOnWriteArraySet<String>();
        this.grantId = UUID.randomUUID().toString();
    }

    @Override
    public synchronized String getGrantId() {
        return this.grantId;
    }

    @Override
    public synchronized void setGrantId(String p_grantId) {
        this.grantId = p_grantId;
    }

    @Override
    public AuthorizationCode getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Override
    public void setAuthorizationCode(AuthorizationCode authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public String getTokenBindingHash() {
        return this.tokenBindingHash;
    }

    public void setTokenBindingHash(String tokenBindingHash) {
        this.tokenBindingHash = tokenBindingHash;
    }

    public String getX5cs256() {
        return this.x5cs256;
    }

    public void setX5cs256(String x5cs256) {
        this.x5cs256 = x5cs256;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    @Override
    public Set<String> getRefreshTokensCodes() {
        return this.refreshTokens.keySet();
    }

    @Override
    public Set<String> getAccessTokensCodes() {
        return this.accessTokens.keySet();
    }

    @Override
    public List<AccessToken> getAccessTokens() {
        return new ArrayList<AccessToken>(this.accessTokens.values());
    }

    @Override
    public void setScopes(Collection<String> scopes) {
        this.scopes.clear();
        this.scopes.addAll(scopes);
    }

    @Override
    public AccessToken getLongLivedAccessToken() {
        return this.longLivedAccessToken;
    }

    @Override
    public void setLongLivedAccessToken(AccessToken longLivedAccessToken) {
        this.longLivedAccessToken = longLivedAccessToken;
    }

    @Override
    public IdToken getIdToken() {
        return this.idToken;
    }

    @Override
    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    @Override
    public TokenLdap getTokenLdap() {
        return this.tokenLdap;
    }

    @Override
    public void setTokenLdap(TokenLdap p_tokenLdap) {
        this.tokenLdap = p_tokenLdap;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getAcrValues() {
        return this.acrValues;
    }

    @Override
    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    @Override
    public String getSessionDn() {
        return this.sessionDn;
    }

    @Override
    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    @Override
    public String checkScopesPolicy(String requestedScopes) {
        this.scopes.clear();
        Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(this.client, requestedScopes);
        this.scopes.addAll(grantedScopes);
        StringBuilder grantedScopesSb = new StringBuilder();
        for (String scope : this.scopes) {
            grantedScopesSb.append(" ").append(scope);
        }
        String grantedScopesSt = grantedScopesSb.toString().trim();
        return grantedScopesSt;
    }

    @Override
    public AccessToken createAccessToken(String certAsPem, ExecutionContext executionContext) {
        int lifetime = this.appConfiguration.getAccessTokenLifetime();
        if (this.client != null && this.client.getAccessTokenLifetime() != null && this.client.getAccessTokenLifetime() > 0) {
            lifetime = this.client.getAccessTokenLifetime();
        }
        AccessToken accessToken = new AccessToken(lifetime);
        accessToken.setAuthMode(this.getAcrValues());
        accessToken.setSessionDn(this.getSessionDn());
        accessToken.setX5ts256(CertUtils.confirmationMethodHashS256((String)certAsPem));
        return accessToken;
    }

    @Override
    public RefreshToken createRefreshToken() {
        int lifetime = this.appConfiguration.getRefreshTokenLifetime();
        if (this.client.getRefreshTokenLifetime() != null && this.client.getRefreshTokenLifetime() > 0) {
            lifetime = this.client.getRefreshTokenLifetime();
        }
        RefreshToken refreshToken = new RefreshToken(lifetime);
        refreshToken.setAuthMode(this.getAcrValues());
        refreshToken.setSessionDn(this.getSessionDn());
        return refreshToken;
    }

    @Override
    public String getUserId() {
        if (this.user == null) {
            return null;
        }
        return this.user.getUserId();
    }

    @Override
    public String getUserDn() {
        if (this.user == null) {
            return null;
        }
        return this.user.getDn();
    }

    @Override
    public AuthorizationGrantType getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public String getClientId() {
        if (this.client == null) {
            return null;
        }
        return this.client.getClientId();
    }

    @Override
    public String getClientDn() {
        if (this.client == null) {
            return null;
        }
        return this.client.getDn();
    }

    @Override
    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    @Override
    public Set<String> getScopes() {
        return this.scopes;
    }

    @Override
    public JwtAuthorizationRequest getJwtAuthorizationRequest() {
        return this.jwtAuthorizationRequest;
    }

    @Override
    public void setJwtAuthorizationRequest(JwtAuthorizationRequest p_jwtAuthorizationRequest) {
        this.jwtAuthorizationRequest = p_jwtAuthorizationRequest;
    }

    @Override
    public void setAccessTokens(List<AccessToken> accessTokens) {
        AbstractAuthorizationGrant.put(this.accessTokens, accessTokens);
    }

    private static <T extends AbstractToken> void put(ConcurrentMap<String, T> p_map, List<T> p_list) {
        p_map.clear();
        if (p_list != null && !p_list.isEmpty()) {
            for (AbstractToken t : p_list) {
                p_map.put(t.getCode(), t);
            }
        }
    }

    @Override
    public List<RefreshToken> getRefreshTokens() {
        return new ArrayList<RefreshToken>(this.refreshTokens.values());
    }

    @Override
    public void setRefreshTokens(List<RefreshToken> refreshTokens) {
        AbstractAuthorizationGrant.put(this.refreshTokens, refreshTokens);
    }

    @Override
    public RefreshToken getRefreshToken(String refreshTokenCode) {
        if (log.isTraceEnabled()) {
            log.trace("Looking for the refresh token: " + refreshTokenCode + " for an authorization grant of type: " + (Object)((Object)this.getAuthorizationGrantType()));
        }
        return (RefreshToken)this.refreshTokens.get(refreshTokenCode);
    }

    @Override
    public AbstractToken getAccessToken(String tokenCode) {
        String hashedTokenCode = TokenHashUtil.hash(tokenCode);
        IdToken idToken = this.getIdToken();
        if (idToken != null && idToken.getCode().equals(hashedTokenCode)) {
            return idToken;
        }
        AccessToken longLivedAccessToken = this.getLongLivedAccessToken();
        if (longLivedAccessToken != null && longLivedAccessToken.getCode().equals(hashedTokenCode)) {
            return longLivedAccessToken;
        }
        return (AbstractToken)this.accessTokens.get(hashedTokenCode);
    }

    public String toString() {
        return "AbstractAuthorizationGrant{user=" + this.user + ", authorizationCode=" + this.authorizationCode + ", client=" + this.client + ", grantId='" + this.grantId + '\'' + ", nonce='" + this.nonce + '\'' + ", acrValues='" + this.acrValues + '\'' + ", sessionDn='" + this.sessionDn + '\'' + ", codeChallenge='" + this.codeChallenge + '\'' + ", codeChallengeMethod='" + this.codeChallengeMethod + '\'' + ", authenticationTime=" + this.authenticationTime + ", scopes=" + this.scopes + ", authorizationGrantType=" + (Object)((Object)this.authorizationGrantType) + ", tokenBindingHash=" + this.tokenBindingHash + ", x5cs256=" + this.x5cs256 + ", claims=" + this.claims + '}';
    }
}

