/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.authorize;

import java.util.HashSet;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ScopeService;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Stateless
@Named(value="scopeChecker")
public class ScopeChecker {
    @Inject
    private Logger log;
    @Inject
    private ScopeService scopeService;

    public Set<String> checkScopesPolicy(Client client, String scope) {
        this.log.debug("Checking scopes policy for: " + scope);
        HashSet<String> grantedScopes = new HashSet<String>();
        if (scope == null || client == null) {
            return grantedScopes;
        }
        String[] scopesRequested = scope.split(" ");
        String[] scopesAllowed = client.getScopes();
        if (scopesAllowed == null) {
            return grantedScopes;
        }
        for (String scopeRequested : scopesRequested) {
            if (!StringUtils.isNotBlank((String)scopeRequested)) continue;
            for (String scopeAllowedDn : scopesAllowed) {
                String scopeAllowedName;
                Scope scopeAllowed = this.scopeService.getScopeByDnSilently(scopeAllowedDn);
                if (scopeAllowed == null || !scopeRequested.equals(scopeAllowedName = scopeAllowed.getId())) continue;
                grantedScopes.add(scopeRequested);
            }
        }
        this.log.debug("Granted scopes: " + grantedScopes);
        return grantedScopes;
    }
}

