/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.gluu.oxauth.filter.CorsFilterConfig;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ClientService;
import org.gluu.server.filters.AbstractCorsFilter;
import org.gluu.util.StringHelper;

@WebFilter(filterName="CorsFilter", asyncSupported=true, urlPatterns={"/.well-known/*", "/restv1/*", "/opiframe"})
public class CorsFilter
extends AbstractCorsFilter {
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ClientService clientService;
    private boolean filterEnabled;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.parseAndStore("*", "GET,POST,HEAD,OPTIONS", "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers", "", "true", "1800", "true");
        AppConfiguration appConfiguration = this.configurationFactory.getAppConfiguration();
        if (filterConfig != null) {
            String filterName = filterConfig.getFilterName();
            CorsFilterConfig corsFilterConfig = new CorsFilterConfig(filterName, appConfiguration);
            String configEnabled = corsFilterConfig.getInitParameter("cors.enabled");
            String configAllowedOrigins = corsFilterConfig.getInitParameter("cors.allowed.origins");
            String configAllowedHttpMethods = corsFilterConfig.getInitParameter("cors.allowed.methods");
            String configAllowedHttpHeaders = corsFilterConfig.getInitParameter("cors.allowed.headers");
            String configExposedHeaders = corsFilterConfig.getInitParameter("cors.exposed.headers");
            String configSupportsCredentials = corsFilterConfig.getInitParameter("cors.support.credentials");
            String configPreflightMaxAge = corsFilterConfig.getInitParameter("cors.preflight.maxage");
            String configDecorateRequest = corsFilterConfig.getInitParameter("cors.request.decorate");
            if (configEnabled != null) {
                this.filterEnabled = Boolean.parseBoolean(configEnabled);
            }
            this.parseAndStore(configAllowedOrigins, configAllowedHttpMethods, configAllowedHttpHeaders, configExposedHeaders, configSupportsCredentials, configPreflightMaxAge, configDecorateRequest);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Collection<String> globalAllowedOrigins = null;
        if (this.filterEnabled) {
            globalAllowedOrigins = this.doFilterImpl(servletRequest);
            super.doFilter(servletRequest, servletResponse, filterChain);
            this.setAllowedOrigins(globalAllowedOrigins);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected Collection<String> doFilterImpl(ServletRequest servletRequest) throws UnsupportedEncodingException, IOException, ServletException {
        Collection globalAllowedOrigins = this.getAllowedOrigins();
        if (StringHelper.isNotEmpty((String)servletRequest.getParameter("client_id"))) {
            String[] authorizedOriginsArray;
            String clientId = servletRequest.getParameter("client_id");
            Client client = this.clientService.getClient(clientId);
            if (client != null && (authorizedOriginsArray = client.getAuthorizedOrigins()) != null && authorizedOriginsArray.length > 0) {
                List<String> clientAuthorizedOrigins = Arrays.asList(authorizedOriginsArray);
                this.setAllowedOrigins(clientAuthorizedOrigins);
            }
        } else {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            String header = httpRequest.getHeader("Authorization");
            if (httpRequest.getRequestURI().endsWith("/token") && header != null && header.startsWith("Basic ")) {
                String[] authorizedOriginsArray;
                Client client;
                String base64Token = header.substring(6);
                String token = new String(Base64.decodeBase64((String)base64Token), "UTF-8");
                String username = "";
                int delim = token.indexOf(":");
                if (delim != -1) {
                    username = URLDecoder.decode(token.substring(0, delim), "UTF-8");
                }
                if ((client = this.clientService.getClient(username)) != null && (authorizedOriginsArray = client.getAuthorizedOrigins()) != null && authorizedOriginsArray.length > 0) {
                    List<String> clientAuthorizedOrigins = Arrays.asList(authorizedOriginsArray);
                    this.setAllowedOrigins(clientAuthorizedOrigins);
                }
            }
        }
        return globalAllowedOrigins;
    }
}

