/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.exception;

import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.gluu.oxauth.model.exception.InvalidSessionStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private ExceptionHandler wrapped;

    GlobalExceptionHandler(ExceptionHandler exception) {
        this.wrapped = exception;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        Iterator i = this.getUnhandledExceptionQueuedEvents().iterator();
        while (i.hasNext()) {
            ExceptionQueuedEvent event = (ExceptionQueuedEvent)i.next();
            ExceptionQueuedEventContext context = (ExceptionQueuedEventContext)event.getSource();
            Throwable t = context.getException();
            FacesContext fc = FacesContext.getCurrentInstance();
            ExternalContext externalContext = fc.getExternalContext();
            try {
                if (this.isInvalidSessionStateException(t)) {
                    log.error(t.getMessage(), t);
                    this.performRedirect(externalContext, "/error_session.htm");
                } else {
                    log.error(t.getMessage(), t);
                    this.performRedirect(externalContext, "/error_service.htm");
                }
                fc.renderResponse();
            }
            finally {
                i.remove();
            }
        }
        this.getWrapped().handle();
    }

    private boolean isInvalidSessionStateException(Throwable t) {
        return ExceptionUtils.getRootCause((Throwable)t) instanceof InvalidSessionStateException;
    }

    private void performRedirect(ExternalContext externalContext, String viewId) {
        try {
            externalContext.redirect(externalContext.getRequestContextPath() + viewId);
        }
        catch (Exception e) {
            log.error("Can't perform redirect to viewId: " + viewId, (Throwable)e);
        }
    }
}

