/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.clientinfo.ws.rs;

import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.gluu.model.GluuAttribute;
import org.gluu.oxauth.clientinfo.ws.rs.ClientInfoRestWebService;
import org.gluu.oxauth.model.clientinfo.ClientInfoErrorResponseType;
import org.gluu.oxauth.model.clientinfo.ClientInfoParamsValidator;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.ScopeService;
import org.json.JSONException;
import org.json.JSONObject;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Path(value="/")
public class ClientInfoRestWebServiceImpl
implements ClientInfoRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ScopeService scopeService;
    @Inject
    private ClientService clientService;
    @Inject
    private AttributeService attributeService;

    @Override
    public Response requestClientInfoGet(String accessToken, String authorization, SecurityContext securityContext) {
        return this.requestClientInfo(accessToken, authorization, securityContext);
    }

    @Override
    public Response requestClientInfoPost(String accessToken, String authorization, SecurityContext securityContext) {
        return this.requestClientInfo(accessToken, authorization, securityContext);
    }

    public Response requestClientInfo(String accessToken, String authorization, SecurityContext securityContext) {
        if (authorization != null && !authorization.isEmpty() && authorization.startsWith("Bearer ")) {
            accessToken = authorization.substring(7);
        }
        this.log.debug("Attempting to request Client Info, Access token = {}, Is Secure = {}", new Object[]{accessToken, securityContext.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        if (!ClientInfoParamsValidator.validateParams(accessToken)) {
            builder = Response.status((int)400);
            builder.entity((Object)this.errorResponseFactory.errorAsJson(ClientInfoErrorResponseType.INVALID_REQUEST, "Failed to validate access token."));
        } else {
            AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
            if (authorizationGrant == null) {
                this.log.trace("Failed to find authorization grant for access token.");
                return Response.status((int)400).entity((Object)this.errorResponseFactory.getErrorAsJson(ClientInfoErrorResponseType.INVALID_TOKEN, "", "Unable to find grant object associated with access token.")).build();
            }
            AbstractToken token = authorizationGrant.getAccessToken(accessToken);
            if (token == null || !token.isValid()) {
                this.log.trace("Invalid access token.");
                return Response.status((int)400).entity((Object)this.errorResponseFactory.getErrorAsJson(ClientInfoErrorResponseType.INVALID_TOKEN, "", "Invalid access token.")).build();
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setPrivate(true);
            cacheControl.setNoTransform(false);
            cacheControl.setNoStore(true);
            builder.cacheControl(cacheControl);
            builder.header("Pragma", (Object)"no-cache");
            builder.entity((Object)this.getJSonResponse(authorizationGrant.getClient(), authorizationGrant.getScopes()));
        }
        return builder.build();
    }

    public String getJSonResponse(Client client, Set<String> scopes) {
        JSONObject jsonObj = new JSONObject();
        try {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeById(scopeName);
                if (scope.getOxAuthClaims() == null) continue;
                for (String claimDn : scope.getOxAuthClaims()) {
                    GluuAttribute attribute = this.attributeService.getAttributeByDn(claimDn);
                    String attributeName = attribute.getName();
                    Object attributeValue = this.clientService.getAttribute(client, attribute.getName());
                    jsonObj.put(attributeName, attributeValue);
                }
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObj.toString();
    }
}

