/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.auth;

import com.google.common.base.Strings;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.auth.Authenticator;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.util.CertUtils;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.service.SessionIdService;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class MTLSService {
    @Inject
    private Logger log;
    @Inject
    private Authenticator authenticator;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;

    public boolean processMTLS(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain, Client client) throws Exception {
        this.log.debug("Trying to authenticate client {} via {} ...", (Object)client.getClientId(), (Object)client.getAuthenticationMethod());
        String clientCertAsPem = httpRequest.getHeader("X-ClientCert");
        if (StringUtils.isBlank((String)clientCertAsPem)) {
            this.log.debug("Client certificate is missed in `X-ClientCert` header, client_id: {}.", (Object)client.getClientId());
            return false;
        }
        X509Certificate cert = CertUtils.x509CertificateFromPem((String)clientCertAsPem);
        if (cert == null) {
            this.log.debug("Failed to parse client certificate, client_id: {}.", (Object)client.getClientId());
            return false;
        }
        if (client.getAuthenticationMethod() == AuthenticationMethod.TLS_CLIENT_AUTH) {
            String subjectDn = client.getAttributes().getTlsClientAuthSubjectDn();
            if (StringUtils.isBlank((String)subjectDn)) {
                this.log.debug("SubjectDN is not set for client {} which is required to authenticate it via `tls_client_auth`.", (Object)client.getClientId());
                return false;
            }
            if (subjectDn.equals(cert.getSubjectDN().getName())) {
                this.log.debug("Client {} authenticated via `tls_client_auth`.", (Object)client.getClientId());
                this.authenticatedSuccessfully(client, httpRequest);
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return true;
            }
        }
        if (client.getAuthenticationMethod() == AuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH) {
            JSONObject jsonWebKeys;
            PublicKey publicKey = cert.getPublicKey();
            byte[] encodedKey = publicKey.getEncoded();
            JSONObject jSONObject = jsonWebKeys = Strings.isNullOrEmpty((String)client.getJwks()) ? JwtUtil.getJSONWebKeys((String)client.getJwksUri()) : new JSONObject(client.getJwks());
            if (jsonWebKeys == null) {
                this.log.debug("Unable to load json web keys for client: {}, jwks_uri: {}, jks: {}", new Object[]{client.getClientId(), client.getJwksUri(), client.getJwks()});
                return false;
            }
            JSONWebKeySet keySet = JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys);
            for (JSONWebKey key : keySet.getKeys()) {
                if (!ArrayUtils.isEquals((Object)encodedKey, (Object)this.cryptoProvider.getPublicKey(key.getKid(), jsonWebKeys).getEncoded())) continue;
                this.log.debug("Client {} authenticated via `self_signed_tls_client_auth`, matched kid: {}.", (Object)client.getClientId(), (Object)key.getKid());
                this.authenticatedSuccessfully(client, httpRequest);
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return true;
            }
        }
        return false;
    }

    private void authenticatedSuccessfully(Client client, HttpServletRequest httpRequest) {
        this.authenticator.configureSessionClient(client);
        List prompts = Prompt.fromString((String)httpRequest.getParameter("prompt"), (String)" ");
        if (prompts.contains(Prompt.LOGIN)) {
            return;
        }
        SessionId sessionIdObject = this.sessionIdService.getSessionId(httpRequest);
        if (sessionIdObject == null || sessionIdObject.getState() != SessionIdState.AUTHENTICATED) {
            return;
        }
        this.authenticator.authenticateBySessionId(sessionIdObject);
    }
}

