/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.audit.debug.wrapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private byte[] content;
    private final Map<String, String[]> parameterMap;
    private final HttpServletRequest delegate;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        this.delegate = request;
        this.parameterMap = this.isFormPost() ? (request.getParameterMap() != null ? new HashMap(request.getParameterMap()) : Collections.emptyMap()) : Collections.emptyMap();
    }

    public Map<String, String[]> getParams() {
        if (ArrayUtils.isEmpty((byte[])this.content) || this.parameterMap.isEmpty()) {
            return this.delegate.getParameterMap();
        }
        return this.parameterMap;
    }

    public String getContent() {
        try {
            this.content = this.parameterMap.isEmpty() ? (ArrayUtils.isEmpty((byte[])this.content) ? IOUtils.toByteArray((InputStream)this.delegate.getInputStream()) : IOUtils.toByteArray((InputStream)((Object)new LoggingServletInputStream(this.content)))) : this.getContentFromParameterMap(this.parameterMap);
            String requestEncoding = this.delegate.getCharacterEncoding();
            String normalizedContent = StringUtils.normalizeSpace((String)new String(this.content, requestEncoding != null ? requestEncoding : StandardCharsets.UTF_8.name()));
            return StringUtils.isBlank((String)normalizedContent) ? null : normalizedContent;
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(0);
        Enumeration headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName == null) continue;
            headers.put(headerName, this.getHeader(headerName));
        }
        return headers;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : this.getParams().entrySet()) {
            String[] values = entry.getValue();
            params.put(entry.getKey(), values.length > 0 ? values[0] : null);
        }
        return params;
    }

    public boolean isFormPost() {
        String contentType = this.getContentType();
        return contentType != null && contentType.contains("application/x-www-form-urlencoded") && "POST".equalsIgnoreCase(this.getMethod());
    }

    private byte[] getContentFromParameterMap(Map<String, String[]> parameterMap) {
        StringBuilder sb = new StringBuilder();
        String ampersand = "&";
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            Object[] value = entry.getValue();
            sb.append(entry.getKey() + "=" + (String)(value.length == 1 ? value[0] : Arrays.toString(value)) + ampersand);
        }
        String params = sb.toString();
        return params.substring(0, params.length() - 1).getBytes();
    }

    private class LoggingServletInputStream
    extends ServletInputStream {
        private final InputStream is;

        private LoggingServletInputStream(byte[] content) {
            this.is = new ByteArrayInputStream(content);
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public void close() throws IOException {
            super.close();
            this.is.close();
        }
    }
}

