/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.audit;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.ConfigurationUpdate;
import org.slf4j.Logger;

@Named
@ApplicationScoped
@DependsOn(value={"appInitializer"})
public class ApplicationAuditLogger {
    @Inject
    private Logger log;
    private final String BROKER_URL_PREFIX = "failover:(";
    private final String BROKER_URL_SUFFIX = ")?timeout=5000&jms.useAsyncSend=true";
    private final int ACK_MODE = 1;
    private final String CLIENT_QUEUE_NAME = "oauth2.audit.logging";
    private final boolean transacted = false;
    private volatile PooledConnectionFactory pooledConnectionFactory;
    private Set<String> jmsBrokerURISet;
    private String jmsUserName;
    private String jmsPassword;
    @Inject
    private AppConfiguration appConfiguration;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean updateState;
    private Boolean enabledOAuthAuditnLogging;

    public void updateConfiguration(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        this.updateState = true;
    }

    @PostConstruct
    public void init() {
        if (BooleanUtils.isNotTrue((Boolean)this.isEnabledOAuthAuditnLogging())) {
            return;
        }
        this.tryToEstablishJMSConnection();
    }

    @Asynchronous
    public void sendMessage(OAuth2AuditLog oAuth2AuditLog) {
        if (BooleanUtils.isNotTrue((Boolean)this.isEnabledOAuthAuditnLogging())) {
            return;
        }
        if (this.pooledConnectionFactory == null || this.isJmsConfigChanged()) {
            if (this.tryToEstablishJMSConnection()) {
                this.loggingThroughJMS(oAuth2AuditLog);
            } else {
                this.loggingThroughFile(oAuth2AuditLog);
            }
        } else {
            this.loggingThroughJMS(oAuth2AuditLog);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.pooledConnectionFactory == null) {
            return;
        }
        this.pooledConnectionFactory.clear();
        this.pooledConnectionFactory = null;
    }

    private boolean tryToEstablishJMSConnection() {
        this.lock.lock();
        try {
            if (this.pooledConnectionFactory == null || this.isJmsConfigChanged()) {
                boolean bl = this.tryToEstablishJMSConnectionImpl();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean tryToEstablishJMSConnectionImpl() {
        this.destroy();
        Set<String> jmsBrokerURISet = this.getJmsBrokerURISet();
        if (BooleanUtils.isNotTrue((Boolean)this.isEnabledOAuthAuditnLogging()) || CollectionUtils.isEmpty(jmsBrokerURISet)) {
            return false;
        }
        this.jmsBrokerURISet = new HashSet<String>(jmsBrokerURISet);
        this.jmsUserName = this.getJmsUserName();
        this.jmsPassword = this.getJmsPassword();
        Iterator<String> jmsBrokerURIIterator = jmsBrokerURISet.iterator();
        StringBuilder uriBuilder = new StringBuilder();
        while (jmsBrokerURIIterator.hasNext()) {
            String jmsBrokerURI = jmsBrokerURIIterator.next();
            uriBuilder.append("tcp://");
            uriBuilder.append(jmsBrokerURI);
            if (!jmsBrokerURIIterator.hasNext()) continue;
            uriBuilder.append(",");
        }
        String brokerUrl = "failover:(" + uriBuilder + ")?timeout=5000&jms.useAsyncSend=true";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.jmsUserName, this.jmsPassword, brokerUrl);
        this.pooledConnectionFactory = new PooledConnectionFactory(connectionFactory);
        this.pooledConnectionFactory.setIdleTimeout(5000);
        this.pooledConnectionFactory.setMaxConnections(10);
        this.pooledConnectionFactory.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loggingThroughJMS(OAuth2AuditLog oAuth2AuditLog) {
        QueueConnection connection = null;
        try {
            connection = this.pooledConnectionFactory.createQueueConnection();
            connection.start();
            QueueSession session = connection.createQueueSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue("oauth2.audit.logging"));
            TextMessage txtMessage = session.createTextMessage();
            txtMessage.setText(ServerUtil.asPrettyJson(oAuth2AuditLog));
            producer.send((Message)txtMessage);
        }
        catch (JMSException e) {
            this.log.error("Can't send message", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Can't serialize the audit log", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Can't send message, please check your activeMQ configuration.", (Throwable)e);
        }
        finally {
            if (connection == null) {
                return;
            }
            try {
                connection.close();
            }
            catch (JMSException e) {
                this.log.error("Can't close connection.");
            }
        }
    }

    private void loggingThroughFile(OAuth2AuditLog oAuth2AuditLog) {
        try {
            this.log.info(ServerUtil.asPrettyJson(oAuth2AuditLog));
        }
        catch (IOException e) {
            this.log.error("Can't serialize the audit log", (Throwable)e);
        }
    }

    private boolean isJmsConfigChanged() {
        return !Objects.equal((Object)this.jmsUserName, (Object)this.getJmsUserName()) || !Objects.equal((Object)this.jmsPassword, (Object)this.getJmsPassword()) || !Objects.equal(this.jmsBrokerURISet, this.getJmsBrokerURISet());
    }

    private Boolean isEnabledOAuthAuditnLogging() {
        if (this.updateState) {
            this.enabledOAuthAuditnLogging = this.appConfiguration.getEnabledOAuthAuditLogging();
        }
        return this.enabledOAuthAuditnLogging;
    }

    private Set<String> getJmsBrokerURISet() {
        return this.appConfiguration.getJmsBrokerURISet();
    }

    private String getJmsUserName() {
        return this.appConfiguration.getJmsUserName();
    }

    private String getJmsPassword() {
        return this.appConfiguration.getJmsPassword();
    }
}

