/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs.fido.u2f;

import com.wordnik.swagger.annotations.Api;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistrationResult;
import org.gluu.oxauth.model.fido.u2f.RegisterRequestMessageLdap;
import org.gluu.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.gluu.oxauth.model.fido.u2f.exception.BadInputException;
import org.gluu.oxauth.model.fido.u2f.exception.RegistrationNotAllowed;
import org.gluu.oxauth.model.fido.u2f.protocol.RegisterRequestMessage;
import org.gluu.oxauth.model.fido.u2f.protocol.RegisterResponse;
import org.gluu.oxauth.model.fido.u2f.protocol.RegisterStatus;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.gluu.oxauth.service.fido.u2f.RegistrationService;
import org.gluu.oxauth.service.fido.u2f.UserSessionIdService;
import org.gluu.oxauth.service.fido.u2f.ValidationService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/fido/u2f/registration")
@Api(value="/fido/u2f/registration", description="The endpoint at which the U2F device start registration process.")
public class U2fRegistrationWS {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UserService userService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private RegistrationService u2fRegistrationService;
    @Inject
    private DeviceRegistrationService deviceRegistrationService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private UserSessionIdService userSessionIdService;
    @Inject
    private ValidationService u2fValidationService;
    @Inject
    private ExternalAuthenticationService service;

    @GET
    @Produces(value={"application/json"})
    public Response startRegistration(@QueryParam(value="username") String userName, @QueryParam(value="application") String appId, @QueryParam(value="session_id") String sessionId, @QueryParam(value="enrollment_code") String enrollmentCode) {
        try {
            List<DeviceRegistration> deviceRegistrations;
            if (this.appConfiguration.getDisableU2fEndpoint().booleanValue()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.log.debug("Startig registration with username '{}' for appId '{}'. session_id '{}', enrollment_code '{}'", new Object[]{userName, appId, sessionId, enrollmentCode});
            String userInum = null;
            boolean sessionBasedEnrollment = false;
            boolean twoStep = StringHelper.isNotEmpty((String)userName);
            if (twoStep) {
                boolean valid;
                boolean removeEnrollment = false;
                if (StringHelper.isNotEmpty((String)sessionId)) {
                    valid = this.u2fValidationService.isValidSessionId(userName, sessionId);
                    if (!valid) {
                        throw new BadInputException(String.format("session_id '%s' is invalid", sessionId));
                    }
                    sessionBasedEnrollment = true;
                } else if (StringHelper.isNotEmpty((String)enrollmentCode)) {
                    valid = this.u2fValidationService.isValidEnrollmentCode(userName, enrollmentCode);
                    if (!valid) {
                        throw new BadInputException(String.format("enrollment_code '%s' is invalid", enrollmentCode));
                    }
                    removeEnrollment = true;
                } else {
                    throw new BadInputException("session_id or enrollment_code is mandatory");
                }
                User user = this.userService.getUser(userName, new String[0]);
                userInum = this.userService.getUserInum(user);
                if (StringHelper.isEmpty((String)userInum)) {
                    throw new BadInputException(String.format("Failed to find user '%s' in LDAP", userName));
                }
                if (removeEnrollment) {
                    user.setAttribute("oxEnrollmentCode", (String)null);
                    this.userService.updateUser(user);
                }
            }
            if (sessionBasedEnrollment && (deviceRegistrations = this.deviceRegistrationService.findUserDeviceRegistrations(userInum, appId, new String[0])).size() > 0 && !this.isCurrentAuthenticationLevelCorrespondsToU2fLevel(sessionId)) {
                throw new RegistrationNotAllowed(String.format("It's not possible to start registration with user_name and session_id because user '%s' has already enrolled device", userName));
            }
            RegisterRequestMessage registerRequestMessage = this.u2fRegistrationService.builRegisterRequestMessage(appId, userInum);
            this.u2fRegistrationService.storeRegisterRequestMessage(registerRequestMessage, userInum, sessionId);
            String entity = ServerUtil.asJson(registerRequestMessage);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            if (ex instanceof RegistrationNotAllowed) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.REGISTRATION_NOT_ALLOWED)).build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response finishRegistration(@FormParam(value="username") String userName, @FormParam(value="tokenResponse") String registerResponseString) {
        String sessionId = null;
        try {
            if (this.appConfiguration.getDisableU2fEndpoint().booleanValue()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.log.debug("Finishing registration for username '{}' with response '{}'", (Object)userName, (Object)registerResponseString);
            RegisterResponse registerResponse = (RegisterResponse)ServerUtil.jsonMapperWithWrapRoot().readValue(registerResponseString, RegisterResponse.class);
            String requestId = registerResponse.getRequestId();
            RegisterRequestMessageLdap registerRequestMessageLdap = this.u2fRegistrationService.getRegisterRequestMessageByRequestId(requestId);
            if (registerRequestMessageLdap == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SESSION_EXPIRED)).build());
            }
            this.u2fRegistrationService.removeRegisterRequestMessage(registerRequestMessageLdap);
            String foundUserInum = registerRequestMessageLdap.getUserInum();
            RegisterRequestMessage registerRequestMessage = registerRequestMessageLdap.getRegisterRequestMessage();
            DeviceRegistrationResult deviceRegistrationResult = this.u2fRegistrationService.finishRegistration(registerRequestMessage, registerResponse, foundUserInum);
            sessionId = registerRequestMessageLdap.getSessionId();
            if (StringHelper.isNotEmpty((String)sessionId)) {
                this.log.debug("There is session id. Setting session id attributes");
                boolean oneStep = StringHelper.isEmpty((String)foundUserInum);
                this.userSessionIdService.updateUserSessionIdOnFinishRequest(sessionId, foundUserInum, deviceRegistrationResult, true, oneStep);
            }
            RegisterStatus registerStatus = new RegisterStatus("success", requestId);
            String entity = ServerUtil.asJson(registerStatus);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            try {
                if (StringHelper.isNotEmpty(sessionId)) {
                    this.log.debug("There is session id. Setting session id status to 'declined'");
                    this.userSessionIdService.updateUserSessionIdOnError(sessionId);
                }
            }
            catch (Exception ex2) {
                this.log.error("Failed to update session id status", (Throwable)ex2);
            }
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            if (ex instanceof BadInputException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.INVALID_REQUEST)).build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private boolean isCurrentAuthenticationLevelCorrespondsToU2fLevel(String session) {
        String[] acrValuesArray;
        SessionId sessionId = this.sessionIdService.getSessionId(session);
        if (sessionId == null) {
            return false;
        }
        String acrValuesStr = this.sessionIdService.getAcr(sessionId);
        if (acrValuesStr == null) {
            return false;
        }
        CustomScriptConfiguration u2fScriptConfiguration = this.service.getCustomScriptConfigurationByName("u2f");
        if (u2fScriptConfiguration == null) {
            return false;
        }
        for (String acrValue : acrValuesArray = acrValuesStr.split(" ")) {
            CustomScriptConfiguration currentScriptConfiguration = this.service.getCustomScriptConfigurationByName(acrValue);
            if (currentScriptConfiguration == null || currentScriptConfiguration.getLevel() < u2fScriptConfiguration.getLevel()) continue;
            return true;
        }
        return false;
    }
}

