/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.inject.Inject;
import org.gluu.model.attribute.AttributeValidation;
import org.gluu.oxauth.i18n.LanguageBean;
import org.gluu.service.AttributeService;

@ApplicationScoped
@FacesValidator(value="gluuPasswordValidator")
public class PasswordValidator
implements Validator {
    private static final String USER_PASSWORD = "userPassword";
    private String newPassword;
    private Pattern pattern;
    private Matcher matcher;
    private boolean hasValidation = false;
    @Inject
    private AttributeService attributeService;
    @Inject
    private LanguageBean languageBean;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String regexp;
        AttributeValidation validation = this.attributeService.getAttributeByName(USER_PASSWORD).getAttributeValidation();
        if (validation != null && (regexp = validation.getRegexp()) != null && !regexp.isEmpty()) {
            this.pattern = Pattern.compile(regexp);
            this.matcher = this.pattern.matcher(value.toString());
            this.hasValidation = true;
        }
        if (this.hasValidation && !this.matcher.matches()) {
            String message = this.languageBean.getMessage("password.validation.invalid");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
            context.validationFailed();
            ((UIInput)component).setValid(false);
        }
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }
}

