/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JwtSigner;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.uma.authorization.UmaPCT;
import org.gluu.oxauth.uma.authorization.UmaRPT;
import org.gluu.oxauth.uma.service.UmaPctService;
import org.gluu.oxauth.uma.service.UmaScopeService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.util.TokenHashUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.util.INumGenerator;
import org.gluu.util.StringHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaRptService {
    private static final String ORGUNIT_OF_RPT = "uma_rpt";
    public static final int DEFAULT_RPT_LIFETIME = 3600;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private UmaPctService pctService;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private ClientService clientService;
    private boolean containsBranch = false;

    public String createDn(String tokenCode) {
        return String.format("tknCde=%s,%s", TokenHashUtil.hash(tokenCode), this.branchDn());
    }

    public String branchDn() {
        return String.format("ou=%s,%s", ORGUNIT_OF_RPT, this.staticConfiguration.getBaseDn().getTokens());
    }

    public void persist(UmaRPT rpt) {
        try {
            Preconditions.checkNotNull((Object)rpt.getClientId());
            this.addBranchIfNeeded();
            rpt.setDn(this.createDn(rpt.getNotHashedCode()));
            rpt.setCode(TokenHashUtil.hash(rpt.getNotHashedCode()));
            this.ldapEntryManager.persist((Object)rpt);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public UmaRPT getRPTByCode(String rptCode) {
        try {
            UmaRPT entry = (UmaRPT)this.ldapEntryManager.find(UmaRPT.class, (Object)this.createDn(rptCode));
            if (entry != null) {
                return entry;
            }
            this.log.error("Failed to find RPT by code: " + rptCode);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void deleteByCode(String rptCode) {
        try {
            UmaRPT t = this.getRPTByCode(rptCode);
            if (t != null) {
                this.ldapEntryManager.remove((Object)t);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean addPermissionToRPT(UmaRPT rpt, Collection<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions) {
        return this.addPermissionToRPT(rpt, permissions.toArray(new org.gluu.oxauth.model.uma.persistence.UmaPermission[permissions.size()]));
    }

    public boolean addPermissionToRPT(UmaRPT rpt, org.gluu.oxauth.model.uma.persistence.UmaPermission ... permission) {
        if (ArrayUtils.isEmpty((Object[])permission)) {
            return true;
        }
        List<String> permissions = UmaRptService.getPermissionDns(Arrays.asList(permission));
        if (rpt.getPermissions() != null) {
            permissions.addAll(rpt.getPermissions());
        }
        rpt.setPermissions(permissions);
        try {
            this.ldapEntryManager.merge((Object)rpt);
            this.log.trace("Persisted RPT: " + rpt);
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static List<String> getPermissionDns(Collection<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions) {
        ArrayList<String> result = new ArrayList<String>();
        if (permissions != null) {
            for (org.gluu.oxauth.model.uma.persistence.UmaPermission p : permissions) {
                result.add(p.getDn());
            }
        }
        return result;
    }

    public List<org.gluu.oxauth.model.uma.persistence.UmaPermission> getRptPermissions(UmaRPT p_rpt) {
        ArrayList<org.gluu.oxauth.model.uma.persistence.UmaPermission> result = new ArrayList<org.gluu.oxauth.model.uma.persistence.UmaPermission>();
        try {
            if (p_rpt != null && p_rpt.getPermissions() != null) {
                List<String> permissionDns = p_rpt.getPermissions();
                for (String permissionDn : permissionDns) {
                    org.gluu.oxauth.model.uma.persistence.UmaPermission permissionObject = (org.gluu.oxauth.model.uma.persistence.UmaPermission)this.ldapEntryManager.find(org.gluu.oxauth.model.uma.persistence.UmaPermission.class, (Object)permissionDn);
                    if (permissionObject == null) continue;
                    result.add(permissionObject);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Date rptExpirationDate() {
        int lifeTime = this.appConfiguration.getUmaRptLifetime();
        if (lifeTime <= 0) {
            lifeTime = 3600;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifeTime);
        return calendar.getTime();
    }

    public UmaRPT createRPTAndPersist(Client client, List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions) {
        try {
            Date creationDate = new Date();
            Date expirationDate = this.rptExpirationDate();
            String code = client.isRptAsJwt() ? this.createRptJwt(client, permissions, creationDate, expirationDate) : UUID.randomUUID().toString() + "_" + INumGenerator.generate((int)8);
            UmaRPT rpt = new UmaRPT(code, creationDate, expirationDate, null, client.getClientId());
            rpt.setPermissions(UmaRptService.getPermissionDns(permissions));
            this.persist(rpt);
            return rpt;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to generate RPT, clientId: " + client.getClientId(), e);
        }
    }

    public void merge(UmaRPT rpt) {
        this.ldapEntryManager.merge((Object)rpt);
    }

    private String createRptJwt(Client client, List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions, Date creationDate, Date expirationDate) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getAccessTokenSigningAlg() != null && SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg()) != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg());
        }
        JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
        Jwt jwt = jwtSigner.newJwt();
        jwt.getClaims().setClaim("client_id", client.getClientId());
        jwt.getClaims().setExpirationTime(expirationDate);
        jwt.getClaims().setIssuedAt(creationDate);
        jwt.getClaims().setAudience(client.getClientId());
        if (permissions != null && !permissions.isEmpty()) {
            String pctCode = (String)permissions.iterator().next().getAttributes().get("pct");
            if (StringHelper.isNotEmpty((String)pctCode)) {
                UmaPCT pct = this.pctService.getByCode(pctCode);
                if (pct != null) {
                    jwt.getClaims().setClaim("pct_claims", pct.getClaims().toJsonObject());
                } else {
                    this.log.error("Failed to find PCT with code: " + pctCode + " which is taken from permission object: " + permissions.iterator().next().getDn());
                }
            }
            jwt.getClaims().setClaim("permissions", this.buildPermissionsJSONObject(permissions));
        }
        return jwtSigner.sign().toString();
    }

    public JSONArray buildPermissionsJSONObject(List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions) throws IOException, JSONException {
        ArrayList<UmaPermission> result = new ArrayList<UmaPermission>();
        for (org.gluu.oxauth.model.uma.persistence.UmaPermission permission : permissions) {
            permission.checkExpired();
            permission.isValid();
            if (permission.isValid()) {
                UmaPermission toAdd = ServerUtil.convert(permission, this.umaScopeService);
                if (toAdd == null) continue;
                result.add(toAdd);
                continue;
            }
            this.log.debug("Ignore permission, skip it in response because permission is not valid. Permission dn: {}", (Object)permission.getDn());
        }
        String json = ServerUtil.asJson(result);
        return new JSONArray(json);
    }

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ORGUNIT_OF_RPT);
        branch.setDn(this.branchDn());
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addBranchIfNeeded() {
        if (!this.containsBranch() && !this.containsBranch) {
            this.addBranch();
        } else {
            this.containsBranch = true;
        }
    }

    public boolean containsBranch() {
        return this.ldapEntryManager.contains(this.branchDn(), SimpleBranch.class);
    }
}

