/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.model.uma.UmaPermissionList;
import org.gluu.oxauth.uma.service.UmaScopeService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.util.INumGenerator;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaPermissionService {
    private static final String ORGUNIT_OF_RESOURCE_PERMISSION = "uma_permission";
    private static final int DEFAULT_TICKET_LIFETIME = 3600;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private UmaScopeService scopeService;
    @Inject
    private AppConfiguration appConfiguration;

    public static String getDn(String clientDn, String ticket) {
        return String.format("oxTicket=%s,%s", ticket, UmaPermissionService.getBranchDn(clientDn));
    }

    public static String getBranchDn(String clientDn) {
        return String.format("ou=%s,%s", ORGUNIT_OF_RESOURCE_PERMISSION, clientDn);
    }

    private List<org.gluu.oxauth.model.uma.persistence.UmaPermission> createPermissions(UmaPermissionList permissions, Date expirationDate) {
        String configurationCode = INumGenerator.generate((int)8) + "." + System.currentTimeMillis();
        String ticket = this.generateNewTicket();
        ArrayList<org.gluu.oxauth.model.uma.persistence.UmaPermission> result = new ArrayList<org.gluu.oxauth.model.uma.persistence.UmaPermission>();
        for (UmaPermission permission : permissions) {
            org.gluu.oxauth.model.uma.persistence.UmaPermission p = new org.gluu.oxauth.model.uma.persistence.UmaPermission(permission.getResourceId(), this.scopeService.getScopeDNsByIdsAndAddToLdapIfNeeded(permission.getScopes()), ticket, configurationCode, expirationDate);
            if (permission.getParams() != null && !permission.getParams().isEmpty()) {
                p.getAttributes().putAll(permission.getParams());
            }
            result.add(p);
        }
        return result;
    }

    public String generateNewTicket() {
        return UUID.randomUUID().toString();
    }

    public String addPermission(UmaPermissionList permissionList, String clientDn) throws Exception {
        try {
            List<org.gluu.oxauth.model.uma.persistence.UmaPermission> created = this.createPermissions(permissionList, this.ticketExpirationDate());
            for (org.gluu.oxauth.model.uma.persistence.UmaPermission permission : created) {
                this.addPermission(permission, clientDn);
            }
            return created.get(0).getTicket();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Date ticketExpirationDate() {
        int lifeTime = this.appConfiguration.getUmaTicketLifetime();
        if (lifeTime <= 0) {
            lifeTime = 3600;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifeTime);
        return calendar.getTime();
    }

    public void addPermission(org.gluu.oxauth.model.uma.persistence.UmaPermission permission, String clientDn) {
        try {
            this.addBranchIfNeeded(clientDn);
            permission.setDn(UmaPermissionService.getDn(clientDn, permission.getTicket()));
            this.ldapEntryManager.persist((Object)permission);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void merge(org.gluu.oxauth.model.uma.persistence.UmaPermission permission) {
        this.ldapEntryManager.merge((Object)permission);
    }

    public void mergeSilently(org.gluu.oxauth.model.uma.persistence.UmaPermission permission) {
        try {
            this.ldapEntryManager.merge((Object)permission);
        }
        catch (Exception e) {
            this.log.error("Failed to persist permission: " + permission, (Throwable)e);
        }
    }

    public List<org.gluu.oxauth.model.uma.persistence.UmaPermission> getPermissionsByTicket(String ticket) {
        try {
            String baseDn = this.staticConfiguration.getBaseDn().getClients();
            Filter filter = Filter.createEqualityFilter((String)"oxTicket", (Object)ticket);
            return this.ldapEntryManager.findEntries(baseDn, org.gluu.oxauth.model.uma.persistence.UmaPermission.class, filter);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void deletePermission(String ticket) {
        try {
            List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions = this.getPermissionsByTicket(ticket);
            for (org.gluu.oxauth.model.uma.persistence.UmaPermission p : permissions) {
                this.ldapEntryManager.remove((Object)p);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addBranch(String clientDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ORGUNIT_OF_RESOURCE_PERMISSION);
        branch.setDn(UmaPermissionService.getBranchDn(clientDn));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addBranchIfNeeded(String clientDn) {
        if (!this.containsBranch(clientDn)) {
            this.addBranch(clientDn);
        }
    }

    public boolean containsBranch(String clientDn) {
        return this.ldapEntryManager.contains(UmaPermissionService.getBranchDn(clientDn), SimpleBranch.class);
    }

    public String changeTicket(List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions, Map<String, String> attributes) {
        String newTicket = this.generateNewTicket();
        for (org.gluu.oxauth.model.uma.persistence.UmaPermission permission : permissions) {
            this.ldapEntryManager.remove((Object)permission);
            String dn = String.format("oxTicket=%s,%s", newTicket, StringUtils.substringAfter((String)permission.getDn(), (String)","));
            permission.setTicket(newTicket);
            permission.setDn(dn);
            permission.setAttributes(attributes);
            this.ldapEntryManager.persist((Object)permission);
            this.log.trace("New ticket: " + newTicket + ", old permission: " + dn);
        }
        return newTicket;
    }
}

