/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.token.ws.rs;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.authorize.CodeVerifier;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCodeGrant;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.ClientCredentialsGrant;
import org.gluu.oxauth.model.common.ExecutionContext;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.IdToken;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.TokenType;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.binding.TokenBindingMessage;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.SessionClient;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.token.TokenErrorResponseType;
import org.gluu.oxauth.model.token.TokenParamsValidator;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.AuthenticationFilterService;
import org.gluu.oxauth.service.AuthenticationService;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.external.ExternalResourceOwnerPasswordCredentialsService;
import org.gluu.oxauth.service.external.context.ExternalResourceOwnerPasswordCredentialsContext;
import org.gluu.oxauth.token.ws.rs.TokenRestWebService;
import org.gluu.oxauth.uma.service.UmaTokenService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.exception.AuthenticationException;
import org.gluu.util.StringHelper;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class TokenRestWebServiceImpl
implements TokenRestWebService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private UserService userService;
    @Inject
    private GrantService grantService;
    @Inject
    private AuthenticationFilterService authenticationFilterService;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaTokenService umaTokenService;
    @Inject
    private ExternalResourceOwnerPasswordCredentialsService externalResourceOwnerPasswordCredentialsService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private SessionIdService sessionIdService;

    @Override
    public Response requestAccessToken(String grantType, String code, String redirectUri, String username, String password, String scope, String assertion, String refreshToken, String clientId, String clientSecret, String codeVerifier, String ticket, String claimToken, String claimTokenFormat, String pctCode, String rptCode, String authReqId, HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        Response.ResponseBuilder builder;
        OAuth2AuditLog oAuth2AuditLog;
        block56: {
            this.log.debug("Attempting to request access token: grantType = {}, code = {}, redirectUri = {}, username = {}, refreshToken = {}, clientId = {}, ExtraParams = {}, isSecure = {}, codeVerifier = {}, ticket = {}", new Object[]{grantType, code, redirectUri, username, refreshToken, clientId, request.getParameterMap(), sec.isSecure(), codeVerifier, ticket});
            boolean isUma = StringUtils.isNotBlank((String)ticket);
            if (isUma) {
                return this.umaTokenService.requestRpt(grantType, ticket, claimToken, claimTokenFormat, pctCode, rptCode, scope, request);
            }
            oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.TOKEN_REQUEST);
            oAuth2AuditLog.setClientId(clientId);
            oAuth2AuditLog.setUsername(username);
            oAuth2AuditLog.setScope(scope);
            String tokenBindingHeader = request.getHeader("Sec-Token-Binding");
            scope = ServerUtil.urlDecode(scope);
            builder = Response.ok();
            try {
                this.log.debug("Starting to validate request parameters");
                if (!TokenParamsValidator.validateParams(grantType, code, redirectUri, username, password, scope, assertion, refreshToken)) {
                    this.log.trace("Failed to validate request parameters");
                    builder = this.error(400, TokenErrorResponseType.INVALID_REQUEST, "Failed to validate request parameters");
                    break block56;
                }
                this.log.trace("Request parameters are right");
                GrantType gt = GrantType.fromString((String)grantType);
                this.log.debug("Grant type: '{}'", (Object)gt);
                SessionClient sessionClient = this.identity.getSessionClient();
                Client client = null;
                if (sessionClient != null) {
                    client = sessionClient.getClient();
                    this.log.debug("Get sessionClient: '{}'", (Object)sessionClient);
                }
                if (client != null) {
                    this.log.debug("Get client from session: '{}'", (Object)client.getClientId());
                    if (client.isDisabled()) {
                        return this.response(this.error(Response.Status.FORBIDDEN.getStatusCode(), TokenErrorResponseType.DISABLED_CLIENT, "Client is disabled."), oAuth2AuditLog);
                    }
                } else {
                    return this.response(this.error(401, TokenErrorResponseType.INVALID_GRANT, "Unable to find client."), oAuth2AuditLog);
                }
                Function idTokenTokingBindingPreprocessing = TokenBindingMessage.createIdTokenTokingBindingPreprocessing((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf());
                if (gt == GrantType.AUTHORIZATION_CODE) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Grant types are invalid."), oAuth2AuditLog);
                    }
                    this.log.debug("Attempting to find authorizationCodeGrant by clinetId: '{}', code: '{}'", (Object)client.getClientId(), (Object)code);
                    final AuthorizationCodeGrant authorizationCodeGrant = this.authorizationGrantList.getAuthorizationCodeGrant(client.getClientId(), code);
                    this.log.trace("AuthorizationCodeGrant : '{}'", (Object)authorizationCodeGrant);
                    if (authorizationCodeGrant != null) {
                        this.validatePKCE(authorizationCodeGrant, codeVerifier, oAuth2AuditLog);
                        authorizationCodeGrant.setIsCachedWithNoPersistence(false);
                        authorizationCodeGrant.save();
                        RefreshToken reToken = null;
                        if (client.getGrantTypes() != null && client.getGrantTypes().length > 0 && Arrays.asList(client.getGrantTypes()).contains(GrantType.REFRESH_TOKEN)) {
                            reToken = authorizationCodeGrant.createRefreshToken();
                        }
                        if (scope != null && !scope.isEmpty()) {
                            scope = authorizationCodeGrant.checkScopesPolicy(scope);
                        }
                        AccessToken accToken = authorizationCodeGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                        this.log.debug("Issuing access token: {}", (Object)accToken.getCode());
                        IdToken idToken = null;
                        if (authorizationCodeGrant.getScopes().contains("openid")) {
                            String nonce = authorizationCodeGrant.getNonce();
                            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                            final String idTokenTokenBindingCnf = client.getIdTokenTokenBindingCnf();
                            Function<JsonWebResponse, Void> authorizationCodePreProcessing = new Function<JsonWebResponse, Void>(){

                                public Void apply(JsonWebResponse jsonWebResponse) {
                                    if (StringUtils.isNotBlank((String)idTokenTokenBindingCnf) && StringUtils.isNotBlank((String)authorizationCodeGrant.getTokenBindingHash())) {
                                        TokenBindingMessage.setCnfClaim((JsonWebResponse)jsonWebResponse, (String)authorizationCodeGrant.getTokenBindingHash(), (String)idTokenTokenBindingCnf);
                                    }
                                    return null;
                                }
                            };
                            idToken = authorizationCodeGrant.createIdToken(nonce, null, accToken, null, null, authorizationCodeGrant, includeIdTokenClaims, authorizationCodePreProcessing);
                        }
                        builder.entity((Object)this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken));
                        oAuth2AuditLog.updateOAuth2AuditLog(authorizationCodeGrant, true);
                        this.grantService.removeByCode(authorizationCodeGrant.getAuthorizationCode().getCode(), authorizationCodeGrant.getClientId());
                    } else {
                        this.log.debug("AuthorizationCodeGrant is empty by clinetId: '{}', code: '{}'", (Object)client.getClientId(), (Object)code);
                        this.grantService.removeAllByAuthorizationCode(code);
                        builder = this.error(400, TokenErrorResponseType.INVALID_GRANT, "Unable to find grant object for given code.");
                    }
                    break block56;
                }
                if (gt == GrantType.REFRESH_TOKEN) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "grant_type is not present in client."), oAuth2AuditLog);
                    }
                    AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByRefreshToken(client.getClientId(), refreshToken);
                    if (authorizationGrant != null) {
                        RefreshToken reToken = authorizationGrant.createRefreshToken();
                        this.grantService.removeByCode(refreshToken, client.getClientId());
                        if (scope != null && !scope.isEmpty()) {
                            scope = authorizationGrant.checkScopesPolicy(scope);
                        }
                        AccessToken accToken = authorizationGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                        IdToken idToken = null;
                        if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && authorizationGrant.getScopes().contains("openid")) {
                            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                            idToken = authorizationGrant.createIdToken(null, null, accToken, null, null, authorizationGrant, includeIdTokenClaims, (Function<JsonWebResponse, Void>)idTokenTokingBindingPreprocessing);
                        }
                        builder.entity((Object)this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken));
                        oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, true);
                    } else {
                        builder = this.error(401, TokenErrorResponseType.INVALID_GRANT, "Unable to find grant object by refresh token.");
                    }
                    break block56;
                }
                if (gt == GrantType.CLIENT_CREDENTIALS) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "grant_type is not present in client."), oAuth2AuditLog);
                    }
                    ClientCredentialsGrant clientCredentialsGrant = this.authorizationGrantList.createClientCredentialsGrant(new User(), client);
                    if (scope != null && !scope.isEmpty()) {
                        scope = clientCredentialsGrant.checkScopesPolicy(scope);
                    }
                    AccessToken accessToken = clientCredentialsGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                    IdToken idToken = null;
                    if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && clientCredentialsGrant.getScopes().contains("openid")) {
                        boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                        idToken = clientCredentialsGrant.createIdToken(null, null, null, null, null, clientCredentialsGrant, includeIdTokenClaims, (Function<JsonWebResponse, Void>)idTokenTokingBindingPreprocessing);
                    }
                    oAuth2AuditLog.updateOAuth2AuditLog(clientCredentialsGrant, true);
                    builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), null, scope, idToken));
                    break block56;
                }
                if (gt == GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) {
                    String userDn;
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "grant_type is not present in client."), oAuth2AuditLog);
                    }
                    boolean authenticated = false;
                    User user = null;
                    if (this.authenticationFilterService.isEnabled() && StringHelper.isNotEmpty((String)(userDn = this.authenticationFilterService.processAuthenticationFilters(request.getParameterMap())))) {
                        user = this.userService.getUserByDn(userDn, new String[0]);
                        authenticated = true;
                    }
                    if (!authenticated) {
                        if (this.externalResourceOwnerPasswordCredentialsService.isEnabled()) {
                            ExternalResourceOwnerPasswordCredentialsContext context = new ExternalResourceOwnerPasswordCredentialsContext(request, response, this.appConfiguration, this.attributeService, this.userService);
                            context.setUser(user);
                            if (this.externalResourceOwnerPasswordCredentialsService.executeExternalAuthenticate(context)) {
                                this.log.trace("RO PC - User is authenticated successfully by external script.");
                                user = context.getUser();
                            }
                        } else {
                            try {
                                authenticated = this.authenticationService.authenticate(username, password);
                                if (authenticated) {
                                    user = this.authenticationService.getAuthenticatedUser();
                                }
                            }
                            catch (AuthenticationException ex) {
                                this.log.trace("Failed to authenticate user ", (Throwable)new RuntimeException("User name or password is invalid"));
                            }
                        }
                    }
                    if (user != null) {
                        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = this.authorizationGrantList.createResourceOwnerPasswordCredentialsGrant(user, client);
                        SessionId sessionId = this.identity.getSessionId();
                        if (sessionId != null) {
                            resourceOwnerPasswordCredentialsGrant.setAcrValues("simple_password_auth");
                            resourceOwnerPasswordCredentialsGrant.setSessionDn(sessionId.getDn());
                            resourceOwnerPasswordCredentialsGrant.save();
                            sessionId.getSessionAttributes().put("authorized_grant", gt.getValue());
                            boolean updateResult = this.sessionIdService.updateSessionId(sessionId, false, true, true);
                            if (!updateResult) {
                                this.log.debug("Failed to update session entry: '{}'", (Object)sessionId.getId());
                            }
                        }
                        RefreshToken reToken = null;
                        if (client.getGrantTypes() != null && client.getGrantTypes().length > 0 && Arrays.asList(client.getGrantTypes()).contains(GrantType.REFRESH_TOKEN)) {
                            reToken = resourceOwnerPasswordCredentialsGrant.createRefreshToken();
                        }
                        if (scope != null && !scope.isEmpty()) {
                            scope = resourceOwnerPasswordCredentialsGrant.checkScopesPolicy(scope);
                        }
                        AccessToken accessToken = resourceOwnerPasswordCredentialsGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                        IdToken idToken = null;
                        if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && resourceOwnerPasswordCredentialsGrant.getScopes().contains("openid")) {
                            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                            idToken = resourceOwnerPasswordCredentialsGrant.createIdToken(null, null, null, null, null, resourceOwnerPasswordCredentialsGrant, includeIdTokenClaims, (Function<JsonWebResponse, Void>)idTokenTokingBindingPreprocessing);
                        }
                        oAuth2AuditLog.updateOAuth2AuditLog(resourceOwnerPasswordCredentialsGrant, true);
                        builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken));
                    } else {
                        this.log.debug("Invalid user", (Throwable)new RuntimeException("User is empty"));
                        builder = this.error(401, TokenErrorResponseType.INVALID_CLIENT, "Invalid user.");
                    }
                    break block56;
                }
                if (gt == GrantType.CIBA) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Grant types are invalid."), oAuth2AuditLog);
                    }
                    this.log.debug("Attempting to find authorizationGrant by authReqId: '{}'", (Object)authReqId);
                    CIBAGrant cibaGrant = this.authorizationGrantList.getCIBAGrant(authReqId);
                    this.log.trace("AuthorizationGrant : '{}'", (Object)cibaGrant);
                    if (cibaGrant != null) {
                        if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PING || cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.POLL) {
                            long currentTime = new Date().getTime();
                            Long lastAccess = cibaGrant.getLastAccessControl();
                            if (lastAccess == null) {
                                lastAccess = currentTime;
                            }
                            cibaGrant.setLastAccessControl(currentTime);
                            cibaGrant.save();
                            if (cibaGrant.isUserAuthorization() && !cibaGrant.isTokensDelivered()) {
                                RefreshToken refToken = cibaGrant.createRefreshToken();
                                this.log.debug("Issuing refresh token: {}", (Object)refToken.getCode());
                                AccessToken accessToken = cibaGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                                this.log.debug("Issuing access token: {}", (Object)accessToken.getCode());
                                IdToken idToken = cibaGrant.createIdToken(null, null, accessToken, refToken, null, cibaGrant, false, null);
                                cibaGrant.setUserAuthorization(true);
                                cibaGrant.setTokensDelivered(true);
                                cibaGrant.save();
                                RefreshToken reToken = null;
                                if (client.getGrantTypes() != null && client.getGrantTypes().length > 0 && Arrays.asList(client.getGrantTypes()).contains(GrantType.REFRESH_TOKEN)) {
                                    reToken = refToken;
                                }
                                if (scope != null && !scope.isEmpty()) {
                                    scope = cibaGrant.checkScopesPolicy(scope);
                                }
                                builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken));
                                oAuth2AuditLog.updateOAuth2AuditLog(cibaGrant, true);
                            } else {
                                int intervalSeconds = this.appConfiguration.getBackchannelAuthenticationResponseInterval();
                                long timeFromLastAccess = currentTime - lastAccess;
                                if (timeFromLastAccess > (long)(intervalSeconds * 1000)) {
                                    this.log.debug("Access hasn't been granted yet for authReqId: '{}'", (Object)authReqId);
                                    builder = this.error(400, TokenErrorResponseType.AUTHORIZATION_PENDING, "User hasn't answered yet");
                                } else {
                                    this.log.debug("Slow down protection authReqId: '{}'", (Object)authReqId);
                                    builder = this.error(400, TokenErrorResponseType.SLOW_DOWN, "Client is asking too fast the token.");
                                }
                            }
                        } else {
                            this.log.debug("Client is not using Poll flow authReqId: '{}'", (Object)authReqId);
                            builder = this.error(400, TokenErrorResponseType.UNAUTHORIZED_CLIENT, "The client is not authorized as it is configured in Push Mode");
                        }
                    } else {
                        this.log.debug("AuthorizationGrant is empty by authReqId: '{}'", (Object)authReqId);
                        builder = this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "Unable to find grant object for given auth_req_id.");
                    }
                }
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                builder = Response.status((int)500);
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.response(builder, oAuth2AuditLog);
    }

    private void validatePKCE(AuthorizationCodeGrant grant, String codeVerifier, OAuth2AuditLog oAuth2AuditLog) {
        this.log.trace("PKCE validation, code_verifier: {}, code_challenge: {}, method: {}", new Object[]{codeVerifier, grant.getCodeChallenge(), grant.getCodeChallengeMethod()});
        if (Strings.isNullOrEmpty((String)grant.getCodeChallenge()) && Strings.isNullOrEmpty((String)codeVerifier)) {
            return;
        }
        if (!CodeVerifier.matched((String)grant.getCodeChallenge(), (String)grant.getCodeChallengeMethod(), (String)codeVerifier)) {
            this.log.error("PKCE check fails. Code challenge does not match to request code verifier, grantId:" + grant.getGrantId() + ", codeVerifier: " + codeVerifier);
            throw new WebApplicationException(this.response(this.error(401, TokenErrorResponseType.INVALID_GRANT, "PKCE check fails. Code challenge does not match to request code verifier."), oAuth2AuditLog));
        }
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        cacheControl.setNoStore(true);
        builder.cacheControl(cacheControl);
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private Response.ResponseBuilder error(int p_status, TokenErrorResponseType p_type, String reason) {
        return Response.status((int)p_status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)p_type, reason));
    }

    public String getJSonResponse(AccessToken accessToken, TokenType tokenType, Integer expiresIn, RefreshToken refreshToken, String scope, IdToken idToken) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("access_token", (Object)accessToken.getCode());
            jsonObj.put("token_type", (Object)tokenType.toString());
            if (expiresIn != null) {
                jsonObj.put("expires_in", (Object)expiresIn);
            }
            if (refreshToken != null) {
                jsonObj.put("refresh_token", (Object)refreshToken.getCode());
            }
            if (scope != null) {
                jsonObj.put("scope", (Object)scope);
            }
            if (idToken != null) {
                jsonObj.put("id_token", (Object)idToken.getCode());
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObj.toString();
    }
}

