/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.session.ws.rs;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.security.Identity;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.EndSessionErrorResponseType;
import org.gluu.oxauth.model.util.URLPatternList;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.service.RedirectionUriService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.external.ExternalApplicationSessionService;
import org.gluu.oxauth.session.ws.rs.EndSessionRestWebService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.Pair;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/")
public class EndSessionRestWebServiceImpl
implements EndSessionRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ExternalApplicationSessionService externalApplicationSessionService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ClientService clientService;
    @Inject
    private GrantService grantService;
    @Inject
    private Identity identity;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private AppConfiguration appConfiguration;

    @Override
    public Response requestEndSession(String idTokenHint, String postLogoutRedirectUri, String state, String sessionId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext sec) {
        try {
            this.log.debug("Attempting to end session, idTokenHint: {}, postLogoutRedirectUri: {}, sessionId: {}, Is Secure = {}", new Object[]{idTokenHint, postLogoutRedirectUri, sessionId, sec.isSecure()});
            this.validateIdTokenHint(idTokenHint, postLogoutRedirectUri);
            this.validateSessionIdRequestParameter(sessionId, postLogoutRedirectUri);
            Pair<SessionId, AuthorizationGrant> pair = this.endSession(idTokenHint, sessionId, httpRequest, httpResponse, postLogoutRedirectUri);
            this.auditLogging(httpRequest, pair);
            if (pair.getFirst() == null && pair.getSecond() == null) {
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, ""));
            }
            return this.httpBased(postLogoutRedirectUri, state, pair);
        }
        catch (WebApplicationException e) {
            if (e.getResponse() != null) {
                return e.getResponse();
            }
            throw e;
        }
    }

    private Response createErrorResponse(String postLogoutRedirectUri, EndSessionErrorResponseType error, String reason) {
        this.log.debug(reason);
        try {
            if (this.allowPostLogoutRedirect(postLogoutRedirectUri)) {
                return Response.status((Response.Status)Response.Status.FOUND).location(new URI(postLogoutRedirectUri)).build();
            }
        }
        catch (URISyntaxException e) {
            this.log.error("Can't perform redirect", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)error, reason)).build();
    }

    private boolean allowPostLogoutRedirect(String postLogoutRedirectUri) {
        if (StringUtils.isBlank((String)postLogoutRedirectUri)) {
            return false;
        }
        Boolean allowPostLogoutRedirectWithoutValidation = this.appConfiguration.getAllowPostLogoutRedirectWithoutValidation();
        return allowPostLogoutRedirectWithoutValidation != null && allowPostLogoutRedirectWithoutValidation != false && new URLPatternList(this.appConfiguration.getClientWhiteList()).isUrlListed(postLogoutRedirectUri);
    }

    private void validateSessionIdRequestParameter(String sessionId, String postLogoutRedirectUri) {
        SessionId sessionIdObject;
        if (StringUtils.isNotBlank((String)sessionId) && (sessionIdObject = this.sessionIdService.getSessionId(sessionId)) == null) {
            String reason = "session_id parameter in request is not valid. Logout is rejected. session_id parameter in request can be skipped or otherwise valid value must be provided.";
            this.log.error("session_id parameter in request is not valid. Logout is rejected. session_id parameter in request can be skipped or otherwise valid value must be provided.");
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "session_id parameter in request is not valid. Logout is rejected. session_id parameter in request can be skipped or otherwise valid value must be provided."));
        }
    }

    private void validateIdTokenHint(String idTokenHint, String postLogoutRedirectUri) {
        AuthorizationGrant authorizationGrant;
        if (StringUtils.isNotBlank((String)idTokenHint) && (authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint)) == null) {
            Boolean endSessionWithAccessToken = this.appConfiguration.getEndSessionWithAccessToken();
            if (endSessionWithAccessToken != null && endSessionWithAccessToken.booleanValue()) {
                authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(idTokenHint);
            }
            if (authorizationGrant == null) {
                String reason = "id_token_hint is not valid. Logout is rejected. id_token_hint can be skipped or otherwise valid value must be provided.";
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "id_token_hint is not valid. Logout is rejected. id_token_hint can be skipped or otherwise valid value must be provided."));
            }
        }
    }

    private String validatePostLogoutRedirectUri(String postLogoutRedirectUri, Pair<SessionId, AuthorizationGrant> pair) {
        try {
            if (pair.getSecond() == null) {
                return this.redirectionUriService.validatePostLogoutRedirectUri((SessionId)pair.getFirst(), postLogoutRedirectUri);
            }
            return this.redirectionUriService.validatePostLogoutRedirectUri(((AuthorizationGrant)pair.getSecond()).getClient().getClientId(), postLogoutRedirectUri);
        }
        catch (WebApplicationException e) {
            if (pair.getFirst() != null) {
                String reason = "Session was removed successfully but post_logout_redirect_uri validation fails since AS failed to validate it against clients associated with session (which was just removed).";
                this.log.error(reason, (Throwable)e);
                throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, reason));
            }
            throw e;
        }
    }

    public Response httpBased(String postLogoutRedirectUri, String state, Pair<SessionId, AuthorizationGrant> pair) {
        String redirectUri = this.validatePostLogoutRedirectUri(postLogoutRedirectUri, pair);
        Set<String> frontchannelLogoutUris = this.getRpFrontchannelLogoutUris(pair);
        String html = this.constructPage(frontchannelLogoutUris, redirectUri, state);
        this.log.debug("Constructed http logout page: " + html);
        return Response.ok().cacheControl(ServerUtil.cacheControl(true, true)).header("Pragma", (Object)"no-cache").type(MediaType.TEXT_HTML_TYPE).entity((Object)html).build();
    }

    private Pair<SessionId, AuthorizationGrant> endSession(String idTokenHint, String sessionId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, String postLogoutRedirectUri) {
        boolean isGrantAndExternalLogoutSuccessful;
        Boolean endSessionWithAccessToken;
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
        if (authorizationGrant == null && (endSessionWithAccessToken = this.appConfiguration.getEndSessionWithAccessToken()) != null && endSessionWithAccessToken.booleanValue()) {
            authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(idTokenHint);
        }
        this.removeConsentSessionId(httpRequest, httpResponse);
        SessionId ldapSessionId = this.removeSessionId(sessionId, httpRequest, httpResponse);
        if (ldapSessionId == null) {
            String reason = "Failed to identify session by session_id query parameter or by session_id cookie.";
            throw new WebApplicationException(this.createErrorResponse(postLogoutRedirectUri, EndSessionErrorResponseType.INVALID_GRANT_AND_SESSION, "Failed to identify session by session_id query parameter or by session_id cookie."));
        }
        boolean externalLogoutResult = false;
        boolean isExternalLogoutPresent = this.externalApplicationSessionService.isEnabled();
        if (isExternalLogoutPresent && ldapSessionId != null) {
            String userName = ldapSessionId.getSessionAttributes().get("auth_user");
            externalLogoutResult = this.externalApplicationSessionService.executeExternalEndSessionMethods(httpRequest, ldapSessionId);
            this.log.info("End session result for '{}': '{}'", new Object[]{userName, "logout", externalLogoutResult});
        }
        boolean bl = isGrantAndExternalLogoutSuccessful = isExternalLogoutPresent && externalLogoutResult;
        if (isExternalLogoutPresent && !isGrantAndExternalLogoutSuccessful) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)EndSessionErrorResponseType.INVALID_GRANT, "External logout is present but executed external logout script returned failed result.");
        }
        if (ldapSessionId != null) {
            this.grantService.removeAllTokensBySession(ldapSessionId.getDn());
        }
        if (this.identity != null) {
            this.identity.logout();
        }
        return new Pair((Object)ldapSessionId, (Object)authorizationGrant);
    }

    private Set<String> getRpFrontchannelLogoutUris(Pair<SessionId, AuthorizationGrant> pair) {
        HashSet clientsByDns;
        HashSet result = Sets.newHashSet();
        SessionId sessionId = (SessionId)pair.getFirst();
        AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getSecond();
        if (sessionId == null) {
            this.log.error("session_id is not passed to endpoint (as cookie or manually). Therefore unable to match clients for session_id.Http based html will contain no iframes.");
            return result;
        }
        Set<Object> set = clientsByDns = sessionId.getPermissionGrantedMap() != null ? this.clientService.getClient(sessionId.getPermissionGrantedMap().getClientIds(true), true) : Sets.newHashSet();
        if (authorizationGrant != null) {
            clientsByDns.add(authorizationGrant.getClient());
        }
        for (Client client : clientsByDns) {
            String[] logoutUris = client.getFrontChannelLogoutUri();
            if (logoutUris == null) continue;
            for (String logoutUri : logoutUris) {
                if (Util.isNullOrEmpty((String)logoutUri)) continue;
                if (client.getFrontChannelLogoutSessionRequired() != null && client.getFrontChannelLogoutSessionRequired().booleanValue()) {
                    logoutUri = logoutUri.contains("?") ? logoutUri + "&sid=" + sessionId.getId() : logoutUri + "?sid=" + sessionId.getId();
                }
                result.add(logoutUri);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionId removeSessionId(String sessionId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        SessionId ldapSessionId = null;
        try {
            String id = sessionId;
            if (StringHelper.isEmpty((String)id)) {
                id = this.sessionIdService.getSessionIdFromCookie(httpRequest);
            }
            if (StringHelper.isNotEmpty((String)id)) {
                ldapSessionId = this.sessionIdService.getSessionId(id);
                if (ldapSessionId != null) {
                    boolean result = this.sessionIdService.remove(ldapSessionId);
                    if (!result) {
                        this.log.error("Failed to remove session_id '{}'", (Object)id);
                    }
                } else {
                    this.log.error("Failed to load session by session_id: '{}'", (Object)id);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionIdService.removeSessionIdCookie(httpResponse);
            this.sessionIdService.removeOPBrowserStateCookie(httpResponse);
        }
        return ldapSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionId removeConsentSessionId(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        SessionId ldapSessionId = null;
        try {
            String id = this.sessionIdService.getConsentSessionIdFromCookie(httpRequest);
            if (StringHelper.isNotEmpty((String)id)) {
                ldapSessionId = this.sessionIdService.getSessionId(id);
                if (ldapSessionId != null) {
                    boolean result = this.sessionIdService.remove(ldapSessionId);
                    if (!result) {
                        this.log.error("Failed to remove consent_session_id '{}'", (Object)id);
                    }
                } else {
                    this.log.error("Failed to load session by consent_session_id: '{}'", (Object)id);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionIdService.removeConsentSessionIdCookie(httpResponse);
        }
        return ldapSessionId;
    }

    private String constructPage(Set<String> logoutUris, String postLogoutUrl, String state) {
        String iframes = "";
        for (String logoutUri : logoutUris) {
            iframes = iframes + String.format("<iframe height=\"0\" width=\"0\" src=\"%s\" sandbox=\"allow-same-origin allow-scripts allow-popups allow-forms\"></iframe>", logoutUri);
        }
        String html = "<!DOCTYPE html><html><head>";
        if (!Util.isNullOrEmpty((String)postLogoutUrl)) {
            if (!Util.isNullOrEmpty((String)state)) {
                postLogoutUrl = postLogoutUrl.contains("?") ? postLogoutUrl + "&state=" + state : postLogoutUrl + "?state=" + state;
            }
            html = html + "<script>window.onload=function() {window.location='" + postLogoutUrl + "'}</script>";
        }
        html = html + "<title>Gluu Generated logout page</title></head><body>Logout requests sent.<br/>" + iframes + "</body></html>";
        return html;
    }

    private void auditLogging(HttpServletRequest request, Pair<SessionId, AuthorizationGrant> pair) {
        SessionId sessionId = (SessionId)pair.getFirst();
        AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getSecond();
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.SESSION_DESTROYED);
        oAuth2AuditLog.setSuccess(true);
        if (authorizationGrant != null) {
            oAuth2AuditLog.setClientId(authorizationGrant.getClientId());
            oAuth2AuditLog.setScope(StringUtils.join(authorizationGrant.getScopes(), (String)" "));
            oAuth2AuditLog.setUsername(authorizationGrant.getUserId());
        } else if (sessionId != null) {
            oAuth2AuditLog.setClientId(sessionId.getPermissionGrantedMap().getClientIds(true).toString());
            oAuth2AuditLog.setScope(sessionId.getSessionAttributes().get("scope"));
            oAuth2AuditLog.setUsername(sessionId.getUserDn());
        }
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
    }
}

