/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.token;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.util.StringHelper;

@Named
public class TokenService {
    @Inject
    private AuthorizationGrantList authorizationGrantList;

    public String getTokenFromAuthorizationParameter(String authorizationParameter) {
        if (StringHelper.isNotEmpty((String)authorizationParameter)) {
            if (authorizationParameter.startsWith("Bearer ")) {
                return authorizationParameter.substring("Bearer ".length());
            }
            if (authorizationParameter.startsWith("Basic ")) {
                return authorizationParameter.substring("Basic ".length());
            }
        }
        return null;
    }

    public AuthorizationGrant getAuthorizationGrant(String p_authorization) {
        String token = this.getTokenFromAuthorizationParameter(p_authorization);
        if (StringUtils.isNotBlank((String)token)) {
            return this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
        }
        return null;
    }

    public AuthorizationGrant getAuthorizationGrantByPrefix(String authorization, String prefix) {
        if (StringUtils.startsWithIgnoreCase((String)authorization, (String)prefix)) {
            return this.authorizationGrantList.getAuthorizationGrantByAccessToken(authorization.substring(prefix.length()));
        }
        return null;
    }

    public String getClientDn(String p_authorization) {
        AuthorizationGrant grant = this.getAuthorizationGrant(p_authorization);
        if (grant != null) {
            return grant.getClientDn();
        }
        return "";
    }
}

