/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.fido.u2f;

import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.fido.u2f.RequestMessageLdap;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.SearchScope;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;

@Stateless
@Named(value="u2fRequestService")
public class RequestService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public List<RequestMessageLdap> getExpiredRequestMessages(BatchOperation<RequestMessageLdap> batchOperation, Date expirationDate, String[] returnAttributes, int sizeLimit, int chunkSize) {
        String u2fBaseDn = this.staticConfiguration.getBaseDn().getU2fBase();
        Filter expirationFilter = Filter.createLessOrEqualFilter((String)"creationDate", (Object)this.ldapEntryManager.encodeTime(u2fBaseDn, expirationDate));
        List requestMessageLdap = this.ldapEntryManager.findEntries(u2fBaseDn, RequestMessageLdap.class, expirationFilter, SearchScope.SUB, returnAttributes, batchOperation, 0, sizeLimit, chunkSize);
        return requestMessageLdap;
    }

    public void removeRequestMessage(RequestMessageLdap requestMessageLdap) {
        this.ldapEntryManager.remove((Object)requestMessageLdap);
    }
}

