/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.AuthenticationScriptUsageType;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.model.CustomScript;
import org.gluu.model.custom.script.model.auth.AuthenticationCustomScript;
import org.gluu.model.custom.script.type.BaseExternalType;
import org.gluu.model.custom.script.type.auth.PersonAuthenticationType;
import org.gluu.model.ldap.GluuLdapConfiguration;
import org.gluu.oxauth.service.cdi.event.ReloadAuthScript;
import org.gluu.oxauth.service.external.internal.InternalDefaultPersonAuthenticationType;
import org.gluu.service.custom.script.ExternalScriptService;
import org.gluu.util.StringHelper;

@ApplicationScoped
public class ExternalAuthenticationService
extends ExternalScriptService {
    public static final String MODIFIED_INTERNAL_TYPES_EVENT_TYPE = "CustomScriptModifiedInternlTypesEvent";
    @Inject
    @Named(value="persistenceAuthConfig")
    private List<GluuLdapConfiguration> ldapAuthConfigs;
    @Inject
    private InternalDefaultPersonAuthenticationType internalDefaultPersonAuthenticationType;
    private static final long serialVersionUID = 7339887464253044927L;
    private Map<AuthenticationScriptUsageType, List<CustomScriptConfiguration>> customScriptConfigurationsMapByUsageType;
    private Map<AuthenticationScriptUsageType, CustomScriptConfiguration> defaultExternalAuthenticators;
    private Map<String, String> scriptAliasMap;

    public ExternalAuthenticationService() {
        super(CustomScriptType.PERSON_AUTHENTICATION);
    }

    public void reloadAuthScript(@Observes @ReloadAuthScript String event) {
        this.reload(event);
    }

    public String scriptName(String acr) {
        if (this.scriptAliasMap.containsKey(acr)) {
            return this.scriptAliasMap.get(acr);
        }
        return acr;
    }

    protected void reloadExternal() {
        this.customScriptConfigurationsMapByUsageType = this.groupCustomScriptConfigurationsMapByUsageType(this.customScriptConfigurationsNameMap);
        this.scriptAliasMap = new HashMap<String, String>();
        for (String name : this.customScriptConfigurationsNameMap.keySet()) {
            this.scriptAliasMap.put(name, name);
            if (null == ((CustomScriptConfiguration)this.customScriptConfigurationsNameMap.get(name)).getCustomScript() || null == ((CustomScriptConfiguration)this.customScriptConfigurationsNameMap.get(name)).getCustomScript().getAliases()) continue;
            for (String acr : ((CustomScriptConfiguration)this.customScriptConfigurationsNameMap.get(name)).getCustomScript().getAliases()) {
                if (!StringUtils.isNotBlank((String)acr)) continue;
                this.scriptAliasMap.put(acr, name);
            }
        }
        this.defaultExternalAuthenticators = this.determineDefaultCustomScriptConfigurationsMap(this.customScriptConfigurationsNameMap);
    }

    protected void addExternalConfigurations(List<CustomScriptConfiguration> newCustomScriptConfigurations) {
        if (this.ldapAuthConfigs == null || this.ldapAuthConfigs.size() == 0) {
            newCustomScriptConfigurations.add(this.getInternalCustomScriptConfiguration());
        } else {
            for (GluuLdapConfiguration ldapAuthConfig : this.ldapAuthConfigs) {
                newCustomScriptConfigurations.add(this.getInternalCustomScriptConfiguration(ldapAuthConfig));
            }
        }
    }

    private Map<AuthenticationScriptUsageType, List<CustomScriptConfiguration>> groupCustomScriptConfigurationsMapByUsageType(Map<String, CustomScriptConfiguration> customScriptConfigurationsMap) {
        HashMap<AuthenticationScriptUsageType, List<CustomScriptConfiguration>> newCustomScriptConfigurationsMapByUsageType = new HashMap<AuthenticationScriptUsageType, List<CustomScriptConfiguration>>();
        for (AuthenticationScriptUsageType usageType : AuthenticationScriptUsageType.values()) {
            ArrayList<CustomScriptConfiguration> currCustomScriptConfigurationsMapByUsageType = new ArrayList<CustomScriptConfiguration>();
            for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurationsMap.values()) {
                if (!this.isValidateUsageType(usageType, customScriptConfiguration)) continue;
                currCustomScriptConfigurationsMapByUsageType.add(customScriptConfiguration);
            }
            newCustomScriptConfigurationsMapByUsageType.put(usageType, currCustomScriptConfigurationsMapByUsageType);
        }
        return newCustomScriptConfigurationsMapByUsageType;
    }

    private Map<AuthenticationScriptUsageType, CustomScriptConfiguration> determineDefaultCustomScriptConfigurationsMap(Map<String, CustomScriptConfiguration> customScriptConfigurationsMap) {
        HashMap<AuthenticationScriptUsageType, CustomScriptConfiguration> newDefaultCustomScriptConfigurationsMap = new HashMap<AuthenticationScriptUsageType, CustomScriptConfiguration>();
        for (AuthenticationScriptUsageType usageType : AuthenticationScriptUsageType.values()) {
            CustomScriptConfiguration defaultExternalAuthenticator = null;
            for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurationsMapByUsageType.get(usageType)) {
                if (defaultExternalAuthenticator != null && defaultExternalAuthenticator.getLevel() >= customScriptConfiguration.getLevel()) continue;
                defaultExternalAuthenticator = customScriptConfiguration;
            }
            newDefaultCustomScriptConfigurationsMap.put(usageType, defaultExternalAuthenticator);
        }
        return newDefaultCustomScriptConfigurationsMap;
    }

    private boolean executeExternalIsValidAuthenticationMethod(AuthenticationScriptUsageType usageType, CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'isValidAuthenticationMethod' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.isValidAuthenticationMethod(usageType, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    private String executeExternalGetAlternativeAuthenticationMethod(AuthenticationScriptUsageType usageType, CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'getAlternativeAuthenticationMethod' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getAlternativeAuthenticationMethod(usageType, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return null;
        }
    }

    public int executeExternalGetCountAuthenticationSteps(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'getCountAuthenticationSteps' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getCountAuthenticationSteps(configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return -1;
        }
    }

    public boolean executeExternalAuthenticate(CustomScriptConfiguration customScriptConfiguration, Map<String, String[]> requestParameters, int step) {
        try {
            this.log.debug("Executing python 'authenticate' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.authenticate(configurationAttributes, requestParameters, step);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public int getNextStep(CustomScriptConfiguration customScriptConfiguration, Map<String, String[]> requestParameters, int step) {
        try {
            this.log.debug("Executing python 'getNextStep' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getNextStep(configurationAttributes, requestParameters, step);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return -1;
        }
    }

    public boolean executeExternalLogout(CustomScriptConfiguration customScriptConfiguration, Map<String, String[]> requestParameters) {
        try {
            this.log.debug("Executing python 'logout' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.logout(configurationAttributes, requestParameters);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public String getLogoutExternalUrl(CustomScriptConfiguration customScriptConfiguration, Map<String, String[]> requestParameters) {
        try {
            this.log.debug("Executing python 'getLogouExternalUrl' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getLogoutExternalUrl(configurationAttributes, requestParameters);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return null;
        }
    }

    public boolean executeExternalPrepareForStep(CustomScriptConfiguration customScriptConfiguration, Map<String, String[]> requestParameters, int step) {
        try {
            this.log.debug("Executing python 'prepareForStep' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.prepareForStep(configurationAttributes, requestParameters, step);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public List<String> executeExternalGetExtraParametersForStep(CustomScriptConfiguration customScriptConfiguration, int step) {
        try {
            this.log.debug("Executing python 'getExtraParametersForStep' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getExtraParametersForStep(configurationAttributes, step);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return null;
        }
    }

    public String executeExternalGetPageForStep(CustomScriptConfiguration customScriptConfiguration, int step) {
        try {
            this.log.debug("Executing python 'getPageForStep' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getPageForStep(configurationAttributes, step);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return null;
        }
    }

    public int executeExternalGetApiVersion(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'getApiVersion' authenticator method");
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)customScriptConfiguration.getExternalType();
            return externalAuthenticator.getApiVersion();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return -1;
        }
    }

    public boolean isEnabled(AuthenticationScriptUsageType usageType) {
        return this.customScriptConfigurationsMapByUsageType != null && this.customScriptConfigurationsMapByUsageType.get(usageType).size() > 0;
    }

    public CustomScriptConfiguration getExternalAuthenticatorByAuthLevel(AuthenticationScriptUsageType usageType, int authLevel) {
        CustomScriptConfiguration resultDefaultExternalAuthenticator = null;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurationsMapByUsageType.get(usageType)) {
            if (customScriptConfiguration.getLevel() != authLevel || resultDefaultExternalAuthenticator != null) continue;
            resultDefaultExternalAuthenticator = customScriptConfiguration;
        }
        return resultDefaultExternalAuthenticator;
    }

    public CustomScriptConfiguration determineCustomScriptConfiguration(AuthenticationScriptUsageType usageType, int authStep, String acr) {
        CustomScriptConfiguration customScriptConfiguration = authStep == 1 ? (StringHelper.isNotEmpty((String)acr) ? this.getCustomScriptConfiguration(usageType, acr) : this.getDefaultExternalAuthenticator(usageType)) : this.getCustomScriptConfiguration(usageType, acr);
        return customScriptConfiguration;
    }

    public CustomScriptConfiguration determineCustomScriptConfiguration(AuthenticationScriptUsageType usageType, List<String> acrValues) {
        List<String> authModes = this.getAuthModesByAcrValues(acrValues);
        if (authModes.size() > 0) {
            for (String authMode : authModes) {
                for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurationsMapByUsageType.get(usageType)) {
                    if (!StringHelper.equalsIgnoreCase((String)authMode, (String)customScriptConfiguration.getName())) continue;
                    return customScriptConfiguration;
                }
            }
        }
        return null;
    }

    public List<String> getAuthModesByAcrValues(List<String> acrValues) {
        ArrayList<String> authModes = new ArrayList<String>();
        for (String acrValue : acrValues) {
            String customScriptName;
            if (!StringHelper.isNotEmpty((String)acrValue) || !this.customScriptConfigurationsNameMap.containsKey(customScriptName = StringHelper.toLowerCase((String)this.scriptName(acrValue)))) continue;
            CustomScriptConfiguration customScriptConfiguration = (CustomScriptConfiguration)this.customScriptConfigurationsNameMap.get(customScriptName);
            CustomScript customScript = customScriptConfiguration.getCustomScript();
            if (customScript.isInternal()) {
                authModes.add(this.scriptName(acrValue));
                continue;
            }
            CustomScriptType customScriptType = customScriptConfiguration.getCustomScript().getScriptType();
            BaseExternalType defaultImplementation = customScriptType.getDefaultImplementation();
            BaseExternalType pythonImplementation = customScriptConfiguration.getExternalType();
            if (pythonImplementation == null || defaultImplementation == pythonImplementation) continue;
            authModes.add(this.scriptName(acrValue));
        }
        return authModes;
    }

    public CustomScriptConfiguration determineExternalAuthenticatorForWorkflow(AuthenticationScriptUsageType usageType, CustomScriptConfiguration customScriptConfiguration) {
        String authMode = customScriptConfiguration.getName();
        this.log.debug("Validating acr_values: '{}'", (Object)authMode);
        boolean isValidAuthenticationMethod = this.executeExternalIsValidAuthenticationMethod(usageType, customScriptConfiguration);
        if (!isValidAuthenticationMethod) {
            this.log.warn("Current acr_values: '{}' isn't valid", (Object)authMode);
            String alternativeAuthenticationMethod = this.executeExternalGetAlternativeAuthenticationMethod(usageType, customScriptConfiguration);
            if (StringHelper.isEmpty((String)alternativeAuthenticationMethod)) {
                this.log.error("Failed to determine alternative authentication mode for acr_values: '{}'", (Object)authMode);
                return null;
            }
            CustomScriptConfiguration alternativeCustomScriptConfiguration = this.getCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, alternativeAuthenticationMethod);
            if (alternativeCustomScriptConfiguration == null) {
                this.log.error("Failed to get alternative CustomScriptConfiguration '{}' for acr_values: '{}'", (Object)alternativeAuthenticationMethod, (Object)authMode);
                return null;
            }
            return alternativeCustomScriptConfiguration;
        }
        return customScriptConfiguration;
    }

    public CustomScriptConfiguration getDefaultExternalAuthenticator(AuthenticationScriptUsageType usageType) {
        if (this.defaultExternalAuthenticators != null) {
            return this.defaultExternalAuthenticators.get(usageType);
        }
        return null;
    }

    public CustomScriptConfiguration getCustomScriptConfiguration(AuthenticationScriptUsageType usageType, String name) {
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurationsMapByUsageType.get(usageType)) {
            if (!StringHelper.equalsIgnoreCase((String)this.scriptName(name), (String)customScriptConfiguration.getName())) continue;
            return customScriptConfiguration;
        }
        return null;
    }

    public CustomScriptConfiguration getCustomScriptConfigurationByName(String name) {
        for (Map.Entry customScriptConfigurationEntry : this.customScriptConfigurationsNameMap.entrySet()) {
            if (!StringHelper.equalsIgnoreCase((String)this.scriptName(name), (String)((String)customScriptConfigurationEntry.getKey()))) continue;
            return (CustomScriptConfiguration)customScriptConfigurationEntry.getValue();
        }
        return null;
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurationsMap() {
        if (this.customScriptConfigurationsNameMap == null) {
            return new ArrayList<CustomScriptConfiguration>(0);
        }
        ArrayList<CustomScriptConfiguration> configurations = new ArrayList<CustomScriptConfiguration>(this.customScriptConfigurationsNameMap.values());
        return configurations;
    }

    public List<String> getAcrValuesList() {
        return new ArrayList<String>(this.scriptAliasMap.keySet());
    }

    private boolean isValidateUsageType(AuthenticationScriptUsageType usageType, CustomScriptConfiguration customScriptConfiguration) {
        if (customScriptConfiguration == null) {
            return false;
        }
        AuthenticationScriptUsageType externalAuthenticatorUsageType = ((AuthenticationCustomScript)customScriptConfiguration.getCustomScript()).getUsageType();
        if (externalAuthenticatorUsageType == null) {
            externalAuthenticatorUsageType = AuthenticationScriptUsageType.INTERACTIVE;
        }
        if (AuthenticationScriptUsageType.BOTH.equals((Object)externalAuthenticatorUsageType)) {
            return true;
        }
        if (AuthenticationScriptUsageType.INTERACTIVE.equals((Object)usageType) && AuthenticationScriptUsageType.INTERACTIVE.equals((Object)externalAuthenticatorUsageType)) {
            return true;
        }
        return AuthenticationScriptUsageType.SERVICE.equals((Object)usageType) && AuthenticationScriptUsageType.SERVICE.equals((Object)externalAuthenticatorUsageType);
    }

    public Map<Integer, Set<String>> levelToAcrMapping() {
        HashMap map = Maps.newHashMap();
        for (CustomScriptConfiguration script : this.getCustomScriptConfigurationsMap()) {
            int level = script.getLevel();
            String acr = script.getName();
            Set acrs = (Set)map.get(level);
            if (acrs == null) {
                acrs = Sets.newHashSet();
                map.put(level, acrs);
            }
            acrs.add(acr);
        }
        return map;
    }

    public Map<String, Integer> acrToLevelMapping() {
        HashMap map = Maps.newHashMap();
        for (CustomScriptConfiguration script : this.getCustomScriptConfigurationsMap()) {
            if (script.getCustomScript().isInternal()) {
                map.put(script.getName(), -1);
                continue;
            }
            map.put(script.getName(), script.getLevel());
        }
        return map;
    }

    private CustomScriptConfiguration getInternalCustomScriptConfiguration(GluuLdapConfiguration ldapAuthConfig) {
        CustomScriptConfiguration customScriptConfiguration = this.getInternalCustomScriptConfiguration();
        customScriptConfiguration.getCustomScript().setName(ldapAuthConfig.getConfigId());
        return customScriptConfiguration;
    }

    private CustomScriptConfiguration getInternalCustomScriptConfiguration() {
        AuthenticationCustomScript customScript = new AuthenticationCustomScript(){

            public AuthenticationScriptUsageType getUsageType() {
                return AuthenticationScriptUsageType.INTERACTIVE;
            }
        };
        customScript.setName("simple_password_auth");
        customScript.setLevel(-1);
        customScript.setInternal(true);
        CustomScriptConfiguration customScriptConfiguration = new CustomScriptConfiguration((CustomScript)customScript, (BaseExternalType)this.internalDefaultPersonAuthenticationType, new HashMap(0));
        return customScriptConfiguration;
    }
}

