/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import java.util.Map;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.session.ApplicationSessionType;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.service.custom.script.ExternalScriptService;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalApplicationSessionService
extends ExternalScriptService {
    private static final long serialVersionUID = 2316361273036208685L;

    public ExternalApplicationSessionService() {
        super(CustomScriptType.APPLICATION_SESSION);
    }

    public boolean executeExternalStartSessionMethod(CustomScriptConfiguration customScriptConfiguration, HttpServletRequest httpRequest, SessionId sessionId) {
        try {
            this.log.debug("Executing python 'startSession' method");
            ApplicationSessionType applicationSessionType = (ApplicationSessionType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return applicationSessionType.startSession((Object)httpRequest, (Object)sessionId, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalStartSessionMethods(HttpServletRequest httpRequest, SessionId sessionId) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (customScriptConfiguration.getExternalType().getApiVersion() <= 1 || (result &= this.executeExternalStartSessionMethod(customScriptConfiguration, httpRequest, sessionId))) continue;
            return result;
        }
        return result;
    }

    public boolean executeExternalEndSessionMethod(CustomScriptConfiguration customScriptConfiguration, HttpServletRequest httpRequest, SessionId sessionId) {
        try {
            this.log.debug("Executing python 'endSession' method");
            ApplicationSessionType applicationSessionType = (ApplicationSessionType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return applicationSessionType.endSession((Object)httpRequest, (Object)sessionId, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean executeExternalEndSessionMethods(HttpServletRequest httpRequest, SessionId sessionId) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (result &= this.executeExternalEndSessionMethod(customScriptConfiguration, httpRequest, sessionId)) continue;
            return result;
        }
        return result;
    }
}

