/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.Calendar;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ScopeService;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Stateless
@Named
public class SpontaneousScopeService {
    private static final int DEFAULT_SPONTANEOUS_SCOPE_LIFETIME_IN_SECONDS = 86400;
    @Inject
    private Logger log;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ScopeService scopeService;

    public void createSpontaneousScopeIfNeeded(String spontaneousScope) {
        Scope fromLdap = this.scopeService.getScopeById(spontaneousScope);
        if (fromLdap != null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        int lifetime = 86400;
        if (this.appConfiguration.getSpontaneousScopeLifetime() > 0) {
            lifetime = this.appConfiguration.getSpontaneousScopeLifetime();
        }
        calendar.add(13, lifetime);
        Scope scope = new Scope();
        scope.setDefaultScope(Boolean.valueOf(false));
        scope.setDescription("Spontaneous scope: " + spontaneousScope);
        scope.setDisplayName(spontaneousScope);
        scope.setId(spontaneousScope);
        scope.setInum(UUID.randomUUID().toString());
        scope.setScopeType(ScopeType.SPONTANEOUS);
        scope.setDeletable(true);
        scope.setNewExpirationDate(calendar.getTime());
        scope.setDn("inum=" + scope.getInum() + "," + this.staticConfiguration.getBaseDn().getScopes());
        this.scopeService.persist(scope);
    }

    public boolean isAllowedBySpontaneousScopes(Client client, String scopeRequested) {
        if (!client.getAttributes().getAllowSpontaneousScopes().booleanValue()) {
            return false;
        }
        for (String spontaneousScope : client.getAttributes().getSpontaneousScopes()) {
            if (!this.isAllowedBySpontaneousScope(spontaneousScope, scopeRequested)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowedBySpontaneousScope(String spontaneousScope, String scopeRequested) {
        try {
            boolean result = Pattern.matches(spontaneousScope, scopeRequested);
            if (result) {
                this.log.trace("Scope {} allowed by spontaneous scope: {}", (Object)scopeRequested, (Object)spontaneousScope);
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

