/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.security.Identity;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.util.Pair;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Stateless
@Named
public class RequestParameterService {
    public static final List<String> ALLOWED_PARAMETER = Collections.unmodifiableList(Arrays.asList("scope", "response_type", "client_id", "redirect_uri", "state", "response_mode", "nonce", "display", "prompt", "max_age", "ui_locales", "id_token_hint", "login_hint", "acr_values", "session_id", "request", "request_uri", "origin_headers", "code_challenge", "code_challenge_method", "custom_response_headers", "claims", "auth_req_id"));
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private AppConfiguration appConfiguration;

    public Map<String, String> getAllowedParameters(@Nonnull Map<String, String> requestParameterMap) {
        HashSet authorizationRequestCustomAllowedParameters = this.appConfiguration.getAuthorizationRequestCustomAllowedParameters();
        if (authorizationRequestCustomAllowedParameters == null) {
            authorizationRequestCustomAllowedParameters = new HashSet(0);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (!requestParameterMap.isEmpty()) {
            Set<Map.Entry<String, String>> set = requestParameterMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (!ALLOWED_PARAMETER.contains(entry.getKey()) && !authorizationRequestCustomAllowedParameters.contains(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public Map<String, String> getCustomParameters(@Nonnull Map<String, String> requestParameterMap) {
        Set authorizationRequestCustomAllowedParameters = this.appConfiguration.getAuthorizationRequestCustomAllowedParameters();
        HashMap<String, String> result = new HashMap<String, String>();
        if (authorizationRequestCustomAllowedParameters == null) {
            return result;
        }
        if (!requestParameterMap.isEmpty()) {
            Set<Map.Entry<String, String>> set = requestParameterMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (!authorizationRequestCustomAllowedParameters.contains(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public String parametersAsString(Map<String, String> parameterMap) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> set = parameterMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String value = entry.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            sb.append(entry.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
        }
        String result = sb.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public Map<String, String> getParametersMap(List<String> extraParameters, Map<String, String> parameterMap) {
        ArrayList<String> allowedParameters = new ArrayList<String>(ALLOWED_PARAMETER);
        if (extraParameters != null) {
            for (String extraParameter : extraParameters) {
                this.putInMap(parameterMap, extraParameter);
            }
            allowedParameters.addAll(extraParameters);
        }
        Iterator<Map.Entry<String, String>> it = parameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (allowedParameters.contains(entry.getKey())) continue;
            it.remove();
        }
        return parameterMap;
    }

    private void putInMap(Map<String, String> map, String p_name) {
        if (map == null) {
            return;
        }
        String value = this.getParameterValue(p_name);
        map.put(p_name, value);
    }

    public String getParameterValue(String p_name) {
        Pair<String, String> valueWithType = this.getParameterValueWithType(p_name);
        if (valueWithType == null) {
            return null;
        }
        return (String)valueWithType.getFirst();
    }

    public Pair<String, String> getParameterValueWithType(String p_name) {
        String value = null;
        String clazz = null;
        Object o = this.identity.getWorkingParameter(p_name);
        if (o instanceof String) {
            String s;
            value = s = (String)o;
            clazz = String.class.getName();
        } else if (o instanceof Integer) {
            Integer i = (Integer)o;
            value = i.toString();
            clazz = Integer.class.getName();
        } else if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            value = b.toString();
            clazz = Boolean.class.getName();
        }
        return new Pair((Object)value, (Object)clazz);
    }

    public Object getTypedValue(String stringValue, String type) {
        if (StringHelper.equals((String)Boolean.class.getName(), (String)type)) {
            return Boolean.valueOf(stringValue);
        }
        if (StringHelper.equals((String)Integer.class.getName(), (String)type)) {
            return Integer.valueOf(stringValue);
        }
        return stringValue;
    }
}

