/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.lang.annotation.Annotation;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.config.Conf;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.service.cdi.event.KeyGenerationEvent;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class KeyGeneratorTimer {
    private static final String EVENT_TYPE = "KeyGeneratorTimerEvent";
    private static final int DEFAULT_INTERVAL = 60;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    public void initTimer() {
        this.log.debug("Initializing Key Generator Timer");
        this.isActive = new AtomicBoolean(false);
        int delay = 60;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 60), (Object)new KeyGenerationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
    }

    @Asynchronous
    public void process(@Observes @Scheduled KeyGenerationEvent keyGenerationEvent) {
        if (!this.appConfiguration.getKeyRegenerationEnabled().booleanValue()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateKeys();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while executing keys update", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void updateKeys() throws JSONException, Exception {
        if (!this.isStartUpdateKeys()) {
            return;
        }
        this.updateKeysImpl();
        this.lastFinishedTime = System.currentTimeMillis();
    }

    private boolean isStartUpdateKeys() {
        int poolingInterval = this.appConfiguration.getKeyRegenerationInterval();
        if (poolingInterval <= 0) {
            poolingInterval = 60;
        }
        poolingInterval = poolingInterval * 3600 * 1000;
        long timeDiffrence = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDiffrence >= (long)poolingInterval;
    }

    private void updateKeysImpl() throws JSONException, Exception {
        String dn = this.configurationFactory.getBaseConfiguration().getString("oxauth_ConfigurationEntryDN");
        Conf conf = (Conf)this.ldapEntryManager.find(Conf.class, (Object)dn);
        JSONObject jwks = conf.getWebKeys().toJSONObject();
        JSONObject updatedJwks = this.updateKeys(jwks);
        conf.setWebKeys((WebKeysConfiguration)((Object)ServerUtil.createJsonMapper().readValue(updatedJwks.toString(), WebKeysConfiguration.class)));
        long nextRevision = conf.getRevision() + 1L;
        conf.setRevision(nextRevision);
        this.ldapEntryManager.merge((Object)conf);
    }

    private JSONObject updateKeys(JSONObject jwks) throws Exception {
        JSONObject jsonObject = AbstractCryptoProvider.generateJwks((int)this.appConfiguration.getKeyRegenerationInterval(), (int)this.appConfiguration.getIdTokenLifetime(), (AppConfiguration)this.appConfiguration);
        JSONArray keys = jwks.getJSONArray("keys");
        for (int i = 0; i < keys.length(); ++i) {
            JSONObject key = keys.getJSONObject(i);
            if (key.has("exp") && !key.isNull("exp")) {
                GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                GregorianCalendar expirationDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                expirationDate.setTimeInMillis(key.getLong("exp"));
                if (expirationDate.before(now)) {
                    this.log.debug("Removing JWK: {}, Expiration date: {}", (Object)key.getString("kid"), (Object)key.getLong("exp"));
                    this.cryptoProvider.deleteKey(key.getString("kid"));
                    continue;
                }
                if (!this.cryptoProvider.containsKey(key.getString("kid"))) continue;
                jsonObject.getJSONArray("keys").put((Object)key);
                continue;
            }
            if (!this.cryptoProvider.containsKey(key.getString("kid"))) continue;
            GregorianCalendar expirationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            expirationTime.add(10, this.appConfiguration.getKeyRegenerationInterval());
            expirationTime.add(13, this.appConfiguration.getIdTokenLifetime());
            key.put("exp", expirationTime.getTimeInMillis());
            jsonObject.getJSONArray("keys").put((Object)key);
        }
        return jsonObject;
    }
}

