/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.CacheGrant;
import org.gluu.oxauth.model.common.ClientTokens;
import org.gluu.oxauth.model.common.SessionTokens;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.ldap.TokenLdap;
import org.gluu.oxauth.model.ldap.TokenType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.util.TokenHashUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.service.CacheService;
import org.slf4j.Logger;

@Stateless
@Named
public class GrantService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private ClientService clientService;
    @Inject
    private CacheService cacheService;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    public static String generateGrantId() {
        return UUID.randomUUID().toString();
    }

    public String buildDn(String p_hashedToken) {
        return String.format("tknCde=%s,", p_hashedToken) + this.tokenBaseDn();
    }

    public String tokenBaseDn() {
        return this.staticConfiguration.getBaseDn().getTokens();
    }

    public void merge(TokenLdap p_token) {
        this.ldapEntryManager.merge((Object)p_token);
    }

    public void mergeSilently(TokenLdap p_token) {
        try {
            this.ldapEntryManager.merge((Object)p_token);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean shouldPutInCache(TokenType tokenType, boolean isImplicitFlow) {
        if (isImplicitFlow && BooleanUtils.isTrue((Boolean)this.appConfiguration.getUseCacheForAllImplicitFlowObjects())) {
            return true;
        }
        switch (tokenType) {
            case ID_TOKEN: {
                if (!ServerUtil.isTrue(this.appConfiguration.getPersistIdTokenInLdap())) {
                    return true;
                }
            }
            case REFRESH_TOKEN: {
                if (ServerUtil.isTrue(this.appConfiguration.getPersistRefreshTokenInLdap())) break;
                return true;
            }
        }
        return false;
    }

    public void persist(TokenLdap token) {
        if (this.shouldPutInCache(token.getTokenTypeEnum(), token.isImplicitFlow())) {
            ClientTokens clientTokens = this.getCacheClientTokens(token.getClientId());
            clientTokens.getTokenHashes().add(token.getTokenCode());
            String expiration = null;
            switch (token.getTokenTypeEnum()) {
                case ID_TOKEN: {
                    expiration = Integer.toString(this.appConfiguration.getIdTokenLifetime());
                    break;
                }
                case REFRESH_TOKEN: {
                    expiration = Integer.toString(this.appConfiguration.getRefreshTokenLifetime());
                    break;
                }
                case ACCESS_TOKEN: {
                    int lifetime = this.appConfiguration.getAccessTokenLifetime();
                    Client client = this.clientService.getClient(token.getClientId());
                    if (client != null && client.getAccessTokenLifetime() != null && client.getAccessTokenLifetime() > 0) {
                        lifetime = client.getAccessTokenLifetime();
                    }
                    expiration = Integer.toString(lifetime);
                }
            }
            token.setIsFromCache(true);
            this.cacheService.put(expiration, token.getTokenCode(), (Object)token);
            this.cacheService.put(expiration, clientTokens.cacheKey(), (Object)clientTokens);
            if (StringUtils.isNotBlank((String)token.getSessionDn())) {
                SessionTokens sessionTokens = this.getCacheSessionTokens(token.getSessionDn());
                sessionTokens.getTokenHashes().add(token.getTokenCode());
                this.cacheService.put(expiration, sessionTokens.cacheKey(), (Object)sessionTokens);
            }
            return;
        }
        this.ldapEntryManager.persist((Object)token);
    }

    public ClientTokens getCacheClientTokens(String clientId) {
        ClientTokens clientTokens = new ClientTokens(clientId);
        Object o = this.cacheService.get(null, clientTokens.cacheKey());
        if (o instanceof ClientTokens) {
            return (ClientTokens)o;
        }
        return clientTokens;
    }

    public SessionTokens getCacheSessionTokens(String sessionDn) {
        SessionTokens sessionTokens = new SessionTokens(sessionDn);
        Object o = this.cacheService.get(null, sessionTokens.cacheKey());
        if (o instanceof SessionTokens) {
            return (SessionTokens)o;
        }
        return sessionTokens;
    }

    public void remove(TokenLdap p_token) {
        if (p_token.isFromCache()) {
            this.cacheService.remove(p_token.getTokenCode());
            this.log.trace("Removed token from cache, code: " + p_token.getTokenCode());
        } else {
            this.ldapEntryManager.remove((Object)p_token);
            this.log.trace("Removed token from LDAP, code: " + p_token.getTokenCode());
        }
    }

    public void removeSilently(TokenLdap token) {
        try {
            this.remove(token);
            if (StringUtils.isNotBlank((String)token.getAuthorizationCode())) {
                this.cacheService.remove(null, CacheGrant.cacheKey(token.getClientId(), token.getAuthorizationCode(), token.getGrantId()));
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void remove(List<TokenLdap> p_entries) {
        if (p_entries != null && !p_entries.isEmpty()) {
            for (TokenLdap t : p_entries) {
                try {
                    this.remove(t);
                }
                catch (Exception e) {
                    this.log.error("Failed to remove entry", (Throwable)e);
                }
            }
        }
    }

    public void removeSilently(List<TokenLdap> p_entries) {
        if (p_entries != null && !p_entries.isEmpty()) {
            for (TokenLdap t : p_entries) {
                this.removeSilently(t);
            }
        }
    }

    public void remove(AuthorizationGrant p_grant) {
        if (p_grant != null && p_grant.getTokenLdap() != null) {
            try {
                this.remove(p_grant.getTokenLdap());
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<TokenLdap> getGrantsOfClient(String p_clientId) {
        try {
            String baseDn = this.clientService.buildClientDn(p_clientId);
            return this.ldapEntryManager.findEntries(baseDn, TokenLdap.class, Filter.createPresenceFilter((String)"tknCde"));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public TokenLdap getGrantByCode(String p_code) {
        return this.getGrantByCode(p_code, false);
    }

    public TokenLdap getGrantByCode(String p_code, boolean onlyFromCache) {
        Object grant = this.cacheService.get(TokenHashUtil.hash(p_code));
        if (grant instanceof TokenLdap) {
            return (TokenLdap)grant;
        }
        if (onlyFromCache) {
            return null;
        }
        return this.load(this.buildDn(TokenHashUtil.hash(p_code)));
    }

    private TokenLdap load(String p_tokenDn) {
        try {
            TokenLdap entry = (TokenLdap)this.ldapEntryManager.find(TokenLdap.class, (Object)p_tokenDn);
            return entry;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<TokenLdap> getGrantsByGrantId(String p_grantId) {
        try {
            return this.ldapEntryManager.findEntries(this.tokenBaseDn(), TokenLdap.class, Filter.createEqualityFilter((String)"grtId", (Object)p_grantId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<TokenLdap> getGrantsByAuthorizationCode(String p_authorizationCode) {
        try {
            return this.ldapEntryManager.findEntries(this.tokenBaseDn(), TokenLdap.class, Filter.createEqualityFilter((String)"authzCode", (Object)TokenHashUtil.hash(p_authorizationCode)));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<TokenLdap> getGrantsBySessionDn(String sessionDn) {
        ArrayList<TokenLdap> grants = new ArrayList<TokenLdap>();
        try {
            List ldapGrants = this.ldapEntryManager.findEntries(this.tokenBaseDn(), TokenLdap.class, Filter.createEqualityFilter((String)"ssnId", (Object)sessionDn));
            if (ldapGrants != null) {
                grants.addAll(ldapGrants);
            }
            grants.addAll(this.getGrantsFromCacheBySessionDn(sessionDn));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return grants;
    }

    public List<TokenLdap> getGrantsFromCacheBySessionDn(String sessionDn) {
        if (StringUtils.isBlank((String)sessionDn)) {
            return Collections.emptyList();
        }
        return this.getCacheTokensEntries(this.getCacheSessionTokens(sessionDn).getTokenHashes());
    }

    public List<TokenLdap> getCacheClientTokensEntries(String clientId) {
        Object o = this.cacheService.get(null, new ClientTokens(clientId).cacheKey());
        if (o instanceof ClientTokens) {
            return this.getCacheTokensEntries(((ClientTokens)o).getTokenHashes());
        }
        return Collections.emptyList();
    }

    public List<TokenLdap> getCacheTokensEntries(Set<String> tokenHashes) {
        ArrayList<TokenLdap> tokens = new ArrayList<TokenLdap>();
        for (String tokenHash : tokenHashes) {
            Object o1 = this.cacheService.get(null, tokenHash);
            if (!(o1 instanceof TokenLdap)) continue;
            TokenLdap token = (TokenLdap)o1;
            token.setIsFromCache(true);
            tokens.add(token);
        }
        return tokens;
    }

    public void removeAllTokensBySession(String sessionDn) {
        this.removeSilently(this.getGrantsBySessionDn(sessionDn));
    }

    public void removeByCode(String p_code, String p_clientId) {
        TokenLdap t = this.getGrantByCode(p_code, true);
        if (t != null) {
            this.removeSilently(t);
        }
        this.cacheService.remove(CacheGrant.cacheKey(p_clientId, p_code, null));
    }

    public void removeAllByAuthorizationCode(String p_authorizationCode) {
        this.removeSilently(this.getGrantsByAuthorizationCode(p_authorizationCode));
    }

    public void removeAllByGrantId(String p_grantId) {
        this.removeSilently(this.getGrantsByGrantId(p_grantId));
    }
}

