/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.model.SmtpConfiguration;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.service.EncryptionService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.oxauth.persistence.model.configuration.GluuConfiguration;
import org.slf4j.Logger;

@Stateless
@Named
public class ConfigurationService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private EncryptionService encryptionService;

    public void addConfiguration(GluuConfiguration configuration) {
        this.ldapEntryManager.persist((Object)configuration);
    }

    public void updateConfiguration(GluuConfiguration configuration) {
        this.ldapEntryManager.merge((Object)configuration);
    }

    public GluuConfiguration getConfigurationByInum(String inum) {
        return (GluuConfiguration)this.ldapEntryManager.find(GluuConfiguration.class, (Object)this.getDnForConfiguration(inum));
    }

    public GluuConfiguration getConfiguration() {
        String configurationDn = this.staticConfiguration.getBaseDn().getConfiguration();
        if (StringHelper.isEmpty((String)configurationDn)) {
            return null;
        }
        return (GluuConfiguration)this.ldapEntryManager.find(GluuConfiguration.class, (Object)configurationDn);
    }

    public String getDnForConfiguration(String inum) {
        String baseDn = this.staticConfiguration.getBaseDn().getConfiguration();
        if (StringHelper.isEmpty((String)inum)) {
            return baseDn;
        }
        return String.format("inum=%s,%s", inum, baseDn);
    }

    public void decryptSmtpPassword(SmtpConfiguration smtpConfiguration) {
        if (smtpConfiguration == null) {
            return;
        }
        String password = smtpConfiguration.getPassword();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                smtpConfiguration.setPasswordDecrypted(this.encryptionService.decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt SMTP user password", (Throwable)ex);
            }
        }
    }
}

