/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.gluu.exception.ConfigurationException;
import org.gluu.model.AuthenticationScriptUsageType;
import org.gluu.model.SimpleProperty;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.ldap.GluuLdapConfiguration;
import org.gluu.oxauth.model.auth.AuthenticationMode;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.event.ApplicationInitializedEvent;
import org.gluu.oxauth.model.util.SecurityProviderUtility;
import org.gluu.oxauth.service.ApplicationFactory;
import org.gluu.oxauth.service.CleanerTimer;
import org.gluu.oxauth.service.EncryptionService;
import org.gluu.oxauth.service.KeyGeneratorTimer;
import org.gluu.oxauth.service.MetricService;
import org.gluu.oxauth.service.cdi.event.AuthConfigurationEvent;
import org.gluu.oxauth.service.cdi.event.ReloadAuthScript;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.oxauth.service.logger.LoggerService;
import org.gluu.oxauth.service.status.ldap.LdapStatusTimer;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.exception.BasePersistenceException;
import org.gluu.persist.ldap.impl.LdapEntryManagerFactory;
import org.gluu.persist.model.PersistenceConfiguration;
import org.gluu.service.JsonService;
import org.gluu.service.PythonService;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.ApplicationInitialized;
import org.gluu.service.cdi.event.LdapConfigurationReload;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.cdi.util.CdiUtil;
import org.gluu.service.custom.lib.CustomLibrariesLoader;
import org.gluu.service.custom.script.CustomScriptManager;
import org.gluu.service.metric.inject.ReportMetric;
import org.gluu.service.timer.QuartzSchedulerManager;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.gluu.util.StringHelper;
import org.gluu.util.properties.FileConfiguration;
import org.gluu.util.security.StringEncrypter;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.oxauth.persistence.model.configuration.GluuConfiguration;
import org.oxauth.persistence.model.configuration.oxIDPAuthConf;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class AppInitializer {
    private static final int DEFAULT_INTERVAL = 30;
    @Inject
    private Logger log;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Event<String> event;
    @Inject
    private Event<ApplicationInitializedEvent> eventApplicationInitialized;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    @Named(value="persistenceEntryManager")
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    @Named(value="persistenceMetricEntryManager")
    @ReportMetric
    private Instance<PersistenceEntryManager> persistenceMetricEntryManagerInstance;
    @Inject
    @Named(value="persistenceAuthEntryManager")
    private Instance<List<PersistenceEntryManager>> persistenceAuthEntryManagerInstance;
    @Inject
    @Named(value="persistenceAuthConfig")
    private Instance<List<GluuLdapConfiguration>> persistenceAuthConfigInstance;
    @Inject
    private ApplicationFactory applicationFactory;
    @Inject
    private Instance<AuthenticationMode> authenticationModeInstance;
    @Inject
    private Instance<EncryptionService> encryptionServiceInstance;
    @Inject
    private PythonService pythonService;
    @Inject
    private MetricService metricService;
    @Inject
    private CustomScriptManager customScriptManager;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private CleanerTimer cleanerTimer;
    @Inject
    private KeyGeneratorTimer keyGeneratorTimer;
    @Inject
    private CustomLibrariesLoader customLibrariesLoader;
    @Inject
    private LdapStatusTimer ldapStatusTimer;
    @Inject
    private QuartzSchedulerManager quartzSchedulerManager;
    @Inject
    private LoggerService loggerService;
    @Inject
    private JsonService jsonService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    private AtomicBoolean isActive;
    private long lastFinishedTime;
    private AuthenticationMode authenticationMode;
    private List<GluuLdapConfiguration> persistenceAuthConfigs;

    @PostConstruct
    public void createApplicationComponents() {
        SecurityProviderUtility.installBCProvider();
    }

    public void applicationInitialized(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        this.log.debug("Initializing application services");
        this.configurationFactory.create();
        PersistenceEntryManager localPersistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        this.log.trace("Attempting to use {}: {}", (Object)"persistenceEntryManager", (Object)localPersistenceEntryManager.getOperationService());
        GluuConfiguration newConfiguration = this.loadConfiguration(localPersistenceEntryManager, "oxIDPAuthentication", "oxAuthenticationMode");
        this.persistenceAuthConfigs = this.loadPersistenceAuthConfigs(newConfiguration);
        this.pythonService.initPythonInterpreter(this.configurationFactory.getBaseConfiguration().getString("pythonModulesDir", null));
        ArrayList supportedCustomScriptTypes = Lists.newArrayList((Object[])CustomScriptType.values());
        supportedCustomScriptTypes.remove(CustomScriptType.CACHE_REFRESH);
        supportedCustomScriptTypes.remove(CustomScriptType.UPDATE_USER);
        supportedCustomScriptTypes.remove(CustomScriptType.USER_REGISTRATION);
        supportedCustomScriptTypes.remove(CustomScriptType.SCIM);
        this.initSchedulerService();
        this.metricService.initTimer();
        this.configurationFactory.initTimer();
        this.loggerService.initTimer();
        this.ldapStatusTimer.initTimer();
        this.cleanerTimer.initTimer();
        this.customScriptManager.initTimer((List)supportedCustomScriptTypes);
        this.keyGeneratorTimer.initTimer();
        this.initTimer();
        this.setDefaultAuthenticationMethod(newConfiguration);
        this.eventApplicationInitialized.select(new Annotation[]{ApplicationInitialized.Literal.APPLICATION}).fire((Object)new ApplicationInitializedEvent());
    }

    protected void initSchedulerService() {
        this.quartzSchedulerManager.start();
        String disableScheduler = System.getProperties().getProperty("gluu.disable.scheduler");
        if (disableScheduler != null && Boolean.valueOf(disableScheduler).booleanValue()) {
            this.log.warn("Suspending Quartz Scheduler Service...");
            this.quartzSchedulerManager.standby();
            return;
        }
    }

    @Produces
    @ApplicationScoped
    public StringEncrypter getStringEncrypter() {
        String encodeSalt = this.configurationFactory.getCryptoConfigurationSalt();
        if (StringHelper.isEmpty((String)encodeSalt)) {
            throw new ConfigurationException("Encode salt isn't defined");
        }
        try {
            StringEncrypter stringEncrypter = StringEncrypter.instance((String)encodeSalt);
            return stringEncrypter;
        }
        catch (StringEncrypter.EncryptionException ex) {
            throw new ConfigurationException("Failed to create StringEncrypter instance");
        }
    }

    public void initTimer() {
        this.isActive = new AtomicBoolean(false);
        this.setLastFinishedTime(System.currentTimeMillis());
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 30), (Object)new AuthConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled AuthConfigurationEvent authConfigurationEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading application configuration", ex);
        }
        finally {
            this.isActive.set(false);
            this.setLastFinishedTime(System.currentTimeMillis());
        }
    }

    private void reloadConfiguration() {
        PersistenceEntryManager localPersistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        this.log.trace("Attempting to use {}: {}", (Object)"persistenceEntryManager", (Object)localPersistenceEntryManager.getOperationService());
        GluuConfiguration newConfiguration = this.loadConfiguration(localPersistenceEntryManager, "oxIDPAuthentication", "oxAuthenticationMode");
        List<GluuLdapConfiguration> newPersistenceAuthConfigs = this.loadPersistenceAuthConfigs(newConfiguration);
        if (!this.persistenceAuthConfigs.equals(newPersistenceAuthConfigs)) {
            this.recreatePersistenceAuthEntryManagers(newPersistenceAuthConfigs);
            this.persistenceAuthConfigs = newPersistenceAuthConfigs;
            this.event.select(new Annotation[]{ReloadAuthScript.Literal.INSTANCE}).fire((Object)"CustomScriptModifiedInternlTypesEvent");
        }
        this.setDefaultAuthenticationMethod(newConfiguration);
    }

    public PersistenceEntryManager createPersistenceAuthEntryManager(GluuLdapConfiguration persistenceAuthConfig) {
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.applicationFactory.getPersistenceEntryManagerFactory();
        Properties persistenceConnectionProperties = this.prepareAuthConnectionProperties(persistenceAuthConfig, persistenceEntryManagerFactory.getPersistenceType());
        PersistenceEntryManager persistenceAuthEntryManager = persistenceEntryManagerFactory.createEntryManager(persistenceConnectionProperties);
        this.log.debug("Created custom authentication PersistenceEntryManager: {}", (Object)persistenceAuthEntryManager);
        return persistenceAuthEntryManager;
    }

    protected Properties preparePersistanceProperties() {
        PersistenceConfiguration persistenceConfiguration = this.configurationFactory.getPersistenceConfiguration();
        FileConfiguration persistenceConfig = persistenceConfiguration.getConfiguration();
        Properties connectionProperties = persistenceConfig.getProperties();
        EncryptionService securityService = (EncryptionService)this.encryptionServiceInstance.get();
        Properties decryptedConnectionProperties = securityService.decryptAllProperties(connectionProperties);
        return decryptedConnectionProperties;
    }

    protected Properties prepareCustomPersistanceProperties(String configId) {
        Properties connectionProperties = this.preparePersistanceProperties();
        if (StringHelper.isNotEmpty((String)configId)) {
            connectionProperties = (Properties)connectionProperties.clone();
            String baseGroup = configId + ".";
            for (Object key : connectionProperties.keySet()) {
                String propertyName = (String)key;
                if (!propertyName.startsWith(baseGroup)) continue;
                propertyName = propertyName.substring(baseGroup.length());
                Object value = connectionProperties.get(key);
                connectionProperties.put(propertyName, value);
            }
        }
        return connectionProperties;
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceEntryManager")
    public PersistenceEntryManager createPersistenceEntryManager() {
        Properties connectionProperties = this.preparePersistanceProperties();
        PersistenceEntryManager persistenceEntryManager = this.applicationFactory.getPersistenceEntryManagerFactory().createEntryManager(connectionProperties);
        this.log.info("Created {}: {} with operation service: {}", new Object[]{"persistenceEntryManager", persistenceEntryManager, persistenceEntryManager.getOperationService()});
        return persistenceEntryManager;
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceMetricEntryManager")
    @ReportMetric
    public PersistenceEntryManager createMetricPersistenceEntryManager() {
        Properties connectionProperties = this.prepareCustomPersistanceProperties("metric");
        PersistenceEntryManager persistenceEntryManager = this.applicationFactory.getPersistenceEntryManagerFactory().createEntryManager(connectionProperties);
        this.log.info("Created {}: {} with operation service: {}", new Object[]{"persistenceMetricEntryManager", persistenceEntryManager, persistenceEntryManager.getOperationService()});
        return persistenceEntryManager;
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceAuthConfig")
    public List<GluuLdapConfiguration> createPersistenceAuthConfigs() {
        return this.persistenceAuthConfigs;
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceAuthEntryManager")
    public List<PersistenceEntryManager> createPersistenceAuthEntryManager() {
        ArrayList<PersistenceEntryManager> persistenceAuthEntryManagers = new ArrayList<PersistenceEntryManager>();
        if (this.persistenceAuthConfigs.size() == 0) {
            return persistenceAuthEntryManagers;
        }
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.applicationFactory.getPersistenceEntryManagerFactory(LdapEntryManagerFactory.class);
        List<Properties> persistenceAuthProperties = this.prepareAuthConnectionProperties(this.persistenceAuthConfigs, persistenceEntryManagerFactory.getPersistenceType());
        for (int i = 0; i < persistenceAuthProperties.size(); ++i) {
            PersistenceEntryManager persistenceAuthEntryManager = persistenceEntryManagerFactory.createEntryManager(persistenceAuthProperties.get(i));
            this.log.debug("Created {}#{}: {}", new Object[]{"persistenceAuthEntryManager", i, persistenceAuthEntryManager});
            persistenceAuthEntryManagers.add(persistenceAuthEntryManager);
        }
        return persistenceAuthEntryManagers;
    }

    public void recreatePersistenceEntryManager(@Observes @LdapConfigurationReload String event) {
        this.recreatePersistanceEntryManagerImpl(this.persistenceEntryManagerInstance, "persistenceEntryManager", new Annotation[0]);
        this.recreatePersistanceEntryManagerImpl(this.persistenceEntryManagerInstance, "persistenceMetricEntryManager", new Annotation[]{ReportMetric.Literal.INSTANCE});
    }

    protected void recreatePersistanceEntryManagerImpl(Instance<PersistenceEntryManager> instance, String persistenceEntryManagerName, Annotation ... qualifiers) {
        PersistenceEntryManager oldPersistenceEntryManager = (PersistenceEntryManager)CdiUtil.getContextBean((BeanManager)this.beanManager, PersistenceEntryManager.class, (String)persistenceEntryManagerName, (Annotation[])new Annotation[0]);
        this.closePersistenceEntryManager(oldPersistenceEntryManager, persistenceEntryManagerName);
        PersistenceEntryManager persistenceEntryManager = (PersistenceEntryManager)instance.get();
        instance.destroy((Object)persistenceEntryManager);
        this.log.info("Recreated instance {}: {} with operation service: {}", new Object[]{persistenceEntryManagerName, persistenceEntryManager, persistenceEntryManager.getOperationService()});
    }

    private void closePersistenceEntryManager(PersistenceEntryManager oldPersistenceEntryManager, String persistenceEntryManagerName) {
        if (oldPersistenceEntryManager != null && oldPersistenceEntryManager.getOperationService() != null) {
            this.log.debug("Attempting to destroy {}:{} with operation service: {}", new Object[]{persistenceEntryManagerName, oldPersistenceEntryManager, oldPersistenceEntryManager.getOperationService()});
            oldPersistenceEntryManager.destroy();
            this.log.debug("Destroyed {}:{} with operation service: {}", new Object[]{persistenceEntryManagerName, oldPersistenceEntryManager, oldPersistenceEntryManager.getOperationService()});
        }
    }

    private void closePersistenceEntryManagers(List<PersistenceEntryManager> oldPersistenceEntryManagers) {
        for (PersistenceEntryManager oldPersistenceEntryManager : oldPersistenceEntryManagers) {
            this.log.debug("Attempting to destroy {}: {}", (Object)"persistenceAuthEntryManager", (Object)oldPersistenceEntryManager);
            oldPersistenceEntryManager.destroy();
            this.log.debug("Destroyed {}: {}", (Object)"persistenceAuthEntryManager", (Object)oldPersistenceEntryManager);
        }
    }

    public void recreatePersistenceAuthEntryManagers(List<GluuLdapConfiguration> newPersistenceAuthConfigs) {
        List oldPersistenceAuthEntryManagers = (List)CdiUtil.getContextBean((BeanManager)this.beanManager, (Type)new ParameterizedTypeImpl(List.class, new Type[]{PersistenceEntryManager.class}), (String)"persistenceAuthEntryManager", (Annotation[])new Annotation[0]);
        this.persistenceAuthConfigs = newPersistenceAuthConfigs;
        this.closePersistenceEntryManagers(oldPersistenceAuthEntryManagers);
        for (PersistenceEntryManager oldPersistenceAuthEntryManager : oldPersistenceAuthEntryManagers) {
            this.log.debug("Attempting to destroy {}: {}", (Object)"persistenceAuthEntryManager", (Object)oldPersistenceAuthEntryManager);
            oldPersistenceAuthEntryManager.destroy();
            this.log.debug("Destroyed {}: {}", (Object)"persistenceAuthEntryManager", (Object)oldPersistenceAuthEntryManager);
        }
        List persistenceAuthEntryManagers = (List)this.persistenceAuthEntryManagerInstance.get();
        this.persistenceAuthEntryManagerInstance.destroy((Object)persistenceAuthEntryManagers);
        this.log.info("Recreated instance {}: {}", (Object)"persistenceAuthEntryManager", (Object)persistenceAuthEntryManagers);
        List oldPersistenceAuthConfigs = (List)this.persistenceAuthConfigInstance.get();
        this.persistenceAuthConfigInstance.destroy((Object)oldPersistenceAuthConfigs);
    }

    private List<Properties> prepareAuthConnectionProperties(List<GluuLdapConfiguration> persistenceAuthConfigs, String persistenceType) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        for (GluuLdapConfiguration persistenceAuthConfig : persistenceAuthConfigs) {
            Properties decrypytedConnectionProperties = this.prepareAuthConnectionProperties(persistenceAuthConfig, persistenceType);
            result.add(decrypytedConnectionProperties);
        }
        return result;
    }

    private Properties prepareAuthConnectionProperties(GluuLdapConfiguration persistenceAuthConfig, String persistenceType) {
        String prefix = persistenceType + ".";
        FileConfiguration configuration = this.configurationFactory.getPersistenceConfiguration().getConfiguration();
        Properties properties = (Properties)configuration.getProperties().clone();
        if (persistenceAuthConfig != null) {
            properties.setProperty(prefix + "servers", this.buildServersString(persistenceAuthConfig.getServers()));
            String bindDn = persistenceAuthConfig.getBindDN();
            if (StringHelper.isNotEmpty((String)bindDn)) {
                properties.setProperty(prefix + "bindDN", bindDn);
                properties.setProperty(prefix + "bindPassword", persistenceAuthConfig.getBindPassword());
            }
            properties.setProperty(prefix + "useSSL", Boolean.toString(persistenceAuthConfig.isUseSSL()));
            properties.setProperty(prefix + "maxconnections", Integer.toString(persistenceAuthConfig.getMaxConnections()));
        }
        EncryptionService securityService = (EncryptionService)this.encryptionServiceInstance.get();
        Properties decrypytedProperties = securityService.decryptAllProperties(properties);
        return decrypytedProperties;
    }

    private String buildServersString(List<?> servers) {
        StringBuilder sb = new StringBuilder();
        if (servers == null) {
            return sb.toString();
        }
        boolean first = true;
        for (Object server : servers) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (server instanceof SimpleProperty) {
                sb.append(((SimpleProperty)server).getValue());
                continue;
            }
            sb.append(server);
        }
        return sb.toString();
    }

    private void setDefaultAuthenticationMethod(GluuConfiguration configuration) {
        String actualAuthMethod;
        String currentAuthMethod = null;
        if (this.authenticationMode != null) {
            currentAuthMethod = this.authenticationMode.getName();
        }
        if (!StringHelper.equals((String)currentAuthMethod, (String)(actualAuthMethod = this.getActualDefaultAuthenticationMethod(configuration)))) {
            this.authenticationMode = null;
            if (actualAuthMethod != null) {
                this.authenticationMode = new AuthenticationMode(actualAuthMethod);
            }
            this.authenticationModeInstance.destroy(this.authenticationModeInstance.get());
        }
    }

    private String getActualDefaultAuthenticationMethod(GluuConfiguration configuration) {
        if (configuration != null && configuration.getAuthenticationMode() != null) {
            return configuration.getAuthenticationMode();
        }
        CustomScriptConfiguration defaultExternalAuthenticator = this.externalAuthenticationService.getDefaultExternalAuthenticator(AuthenticationScriptUsageType.INTERACTIVE);
        if (defaultExternalAuthenticator != null) {
            return defaultExternalAuthenticator.getName();
        }
        return "simple_password_auth";
    }

    @Produces
    @ApplicationScoped
    public AuthenticationMode getDefaultAuthenticationMode() {
        return this.authenticationMode;
    }

    private GluuConfiguration loadConfiguration(PersistenceEntryManager localPersistenceEntryManager, String ... persistenceReturnAttributes) {
        String configurationDn = this.configurationFactory.getBaseDn().getConfiguration();
        if (StringHelper.isEmpty((String)configurationDn)) {
            return null;
        }
        GluuConfiguration configuration = null;
        try {
            configuration = (GluuConfiguration)localPersistenceEntryManager.find((Object)configurationDn, GluuConfiguration.class, persistenceReturnAttributes);
        }
        catch (BasePersistenceException ex) {
            this.log.error("Failed to load global configuration entry from Ldap", (Throwable)ex);
            return null;
        }
        return configuration;
    }

    private List<GluuLdapConfiguration> loadPersistenceAuthConfigs(GluuConfiguration configuration) {
        ArrayList<GluuLdapConfiguration> persistenceAuthConfigs = new ArrayList<GluuLdapConfiguration>();
        List<oxIDPAuthConf> persistenceIdpAuthConfigs = this.loadLdapIdpAuthConfigs(configuration);
        if (persistenceIdpAuthConfigs == null) {
            return persistenceAuthConfigs;
        }
        for (oxIDPAuthConf persistenceIdpAuthConfig : persistenceIdpAuthConfigs) {
            GluuLdapConfiguration persistenceAuthConfig = persistenceIdpAuthConfig.getConfig();
            if (persistenceAuthConfig == null || !persistenceAuthConfig.isEnabled()) continue;
            persistenceAuthConfigs.add(persistenceAuthConfig);
        }
        return persistenceAuthConfigs;
    }

    private List<oxIDPAuthConf> loadLdapIdpAuthConfigs(GluuConfiguration configuration) {
        if (configuration == null || configuration.getOxIDPAuthentication() == null) {
            return null;
        }
        ArrayList<oxIDPAuthConf> configurations = new ArrayList<oxIDPAuthConf>();
        for (oxIDPAuthConf authConf : configuration.getOxIDPAuthentication()) {
            if (!authConf.getType().equalsIgnoreCase("ldap") && !authConf.getType().equalsIgnoreCase("auth")) continue;
            configurations.add(authConf);
        }
        return configurations;
    }

    public void destroy(@Observes @BeforeDestroyed(value=ApplicationScoped.class) ServletContext init) {
        this.log.info("Stopping services and closing DB connections at server shutdown...");
        this.log.debug("Checking who intiated destory", new Throwable());
        this.metricService.close();
        PersistenceEntryManager persistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        this.closePersistenceEntryManager(persistenceEntryManager, "persistenceEntryManager");
        List persistenceAuthEntryManagers = (List)this.persistenceAuthEntryManagerInstance.get();
        this.closePersistenceEntryManagers(persistenceAuthEntryManagers);
    }

    public long getLastFinishedTime() {
        return this.lastFinishedTime;
    }

    public void setLastFinishedTime(long lastFinishedTime) {
        this.lastFinishedTime = lastFinishedTime;
    }
}

