/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.revoke;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.TokenTypeHint;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.SessionClient;
import org.gluu.oxauth.model.token.TokenRevocationErrorResponseType;
import org.gluu.oxauth.revoke.RevokeRestWebService;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.util.ServerUtil;
import org.slf4j.Logger;

@Path(value="/")
public class RevokeRestWebServiceImpl
implements RevokeRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private Identity identity;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private GrantService grantService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    @Override
    public Response requestAccessToken(String token, String tokenTypeHint, HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.debug("Attempting to revoke token: token = {}, tokenTypeHint = {}, isSecure = {}", new Object[]{token, tokenTypeHint, sec.isSecure()});
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.TOKEN_REVOCATION);
        Response.ResponseBuilder builder = Response.ok();
        SessionClient sessionClient = this.identity.getSessionClient();
        Client client = null;
        if (sessionClient != null) {
            client = sessionClient.getClient();
            oAuth2AuditLog.setClientId(client.getClientId());
            if (this.validateToken(token)) {
                TokenTypeHint tth = TokenTypeHint.getByValue((String)tokenTypeHint);
                AuthorizationGrant authorizationGrant = null;
                if (tth == TokenTypeHint.ACCESS_TOKEN) {
                    authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
                } else if (tth == TokenTypeHint.REFRESH_TOKEN) {
                    authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByRefreshToken(client.getClientId(), token);
                } else {
                    authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
                    if (authorizationGrant == null) {
                        authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByRefreshToken(client.getClientId(), token);
                    }
                }
                if (authorizationGrant != null) {
                    this.grantService.removeAllTokensBySession(authorizationGrant.getTokenLdap().getSessionDn());
                }
            } else {
                builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE);
                builder.entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)TokenRevocationErrorResponseType.INVALID_REQUEST, "Failed to validate token."));
            }
        }
        return this.response(builder, oAuth2AuditLog);
    }

    private boolean validateToken(String token) {
        return StringUtils.isNotBlank((String)token);
    }

    private TokenTypeHint validateTokenTypeHint(String tokenTypeHint) {
        return TokenTypeHint.getByValue((String)tokenTypeHint);
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        cacheControl.setNoStore(true);
        builder.cacheControl(cacheControl);
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }
}

