/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.token;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.gluu.model.GluuAttribute;
import org.gluu.model.attribute.AttributeDataType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.auth.PersonAuthenticationType;
import org.gluu.oxauth.ciba.CIBASupportProxy;
import org.gluu.oxauth.model.authorize.Claim;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCode;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.IAuthorizationGrant;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.oxauth.model.common.SubjectType;
import org.gluu.oxauth.model.common.UnmodifiableAuthorizationGrant;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.exception.InvalidClaimException;
import org.gluu.oxauth.model.exception.InvalidJweException;
import org.gluu.oxauth.model.jwe.Jwe;
import org.gluu.oxauth.model.jwe.JweEncrypterImpl;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtSubClaimObject;
import org.gluu.oxauth.model.jwt.JwtType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.token.JwtSigner;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.PairwiseIdentifierService;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.external.ExternalAuthenticationService;
import org.gluu.oxauth.service.external.ExternalDynamicScopeService;
import org.gluu.oxauth.service.external.context.DynamicScopeExternalContext;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.oxauth.persistence.model.PairwiseIdentifier;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Stateless
@Named
public class IdTokenFactory {
    @Inject
    private Logger log;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ClientService clientService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private PairwiseIdentifierService pairwiseIdentifierService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private CIBASupportProxy cibaSupportProxy;

    public Jwt generateSignedIdToken(IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, String state, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        Object value;
        JwtSigner jwtSigner = JwtSigner.newJwtSigner(this.appConfiguration, this.webKeysConfiguration, authorizationGrant.getClient());
        Jwt jwt = jwtSigner.newJwt();
        int lifeTime = this.appConfiguration.getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwt.getClaims().setExpirationTime(expiration);
        jwt.getClaims().setIssuedAt(issuedAt);
        if (preProcessing != null) {
            preProcessing.apply((Object)jwt);
        }
        if (authorizationGrant.getAcrValues() != null) {
            jwt.getClaims().setClaim("acr", authorizationGrant.getAcrValues());
            this.setAmrClaim((JsonWebResponse)jwt, authorizationGrant.getAcrValues());
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwt.getClaims().setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwt.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = AbstractToken.getHash(authorizationCode.getCode(), jwtSigner.getSignatureAlgorithm());
            jwt.getClaims().setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = AbstractToken.getHash(accessToken.getCode(), jwtSigner.getSignatureAlgorithm());
            jwt.getClaims().setClaim("at_hash", accessTokenHash);
        }
        if (Strings.isNotBlank((String)state)) {
            String stateHash = AbstractToken.getHash(state, jwtSigner.getSignatureAlgorithm());
            jwt.getClaims().setClaim("s_hash", stateHash);
        }
        jwt.getClaims().setClaim("oxOpenIDConnectVersion", this.appConfiguration.getOxOpenIdConnectVersion());
        User user = authorizationGrant.getUser();
        ArrayList<Scope> dynamicScopes = new ArrayList<Scope>();
        if (includeIdTokenClaims && authorizationGrant.getClient().isIncludeClaimsInIdToken()) {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeById(scopeName);
                if (scope != null && ScopeType.DYNAMIC == scope.getScopeType()) {
                    dynamicScopes.add(scope);
                    continue;
                }
                Map<String, Object> claims = this.getClaims(user, scope);
                if (Boolean.TRUE.equals(scope.isOxAuthGroupClaims())) {
                    JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                    groupClaim.setName(scope.getId());
                    for (Map.Entry<String, Object> entry : claims.entrySet()) {
                        String key = entry.getKey();
                        Object value2 = entry.getValue();
                        if (value2 instanceof List) {
                            groupClaim.setClaim(key, (List)value2);
                            continue;
                        }
                        groupClaim.setClaim(key, (String)value2);
                    }
                    jwt.getClaims().setClaim(scope.getId(), groupClaim);
                } else {
                    for (Map.Entry entry : claims.entrySet()) {
                        String key = (String)entry.getKey();
                        value = entry.getValue();
                        if (value instanceof List) {
                            jwt.getClaims().setClaim(key, (List)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            jwt.getClaims().setClaim(key, (Boolean)value);
                            continue;
                        }
                        if (value instanceof Date) {
                            jwt.getClaims().setClaim(key, Long.valueOf(((Date)value).getTime()));
                            continue;
                        }
                        jwt.getClaims().setClaim(key, (String)value);
                    }
                }
                jwt.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute("inum"));
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember().getClaims()) {
                Client client;
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null || !this.validateRequesteClaim(gluuAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes)) continue;
                String string = gluuAttribute.getName();
                Object attribute = authorizationGrant.getUser().getAttribute(string, optional, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                if (attribute == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value3 = jsonArray.optString(i);
                        if (value3 == null) continue;
                        values.add(value3);
                    }
                    jwt.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                value = (String)attribute;
                jwt.getClaims().setClaim(claim.getName(), value);
            }
        }
        if (authorizationGrant.getClient().getSubjectType() != null && SubjectType.fromString((String)authorizationGrant.getClient().getSubjectType()).equals((Object)SubjectType.PAIRWISE) && (StringUtils.isNotBlank((String)authorizationGrant.getClient().getSectorIdentifierUri()) || authorizationGrant.getClient().getRedirectUris() != null)) {
            String clientId;
            String sectorIdentifierUri = null;
            sectorIdentifierUri = StringUtils.isNotBlank((String)authorizationGrant.getClient().getSectorIdentifierUri()) ? authorizationGrant.getClient().getSectorIdentifierUri() : authorizationGrant.getClient().getRedirectUris()[0];
            String userInum = authorizationGrant.getUser().getAttribute("inum");
            PairwiseIdentifier pairwiseIdentifier = this.pairwiseIdentifierService.findPairWiseIdentifier(userInum, sectorIdentifierUri, clientId = authorizationGrant.getClientId());
            if (pairwiseIdentifier == null) {
                pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, clientId);
                pairwiseIdentifier.setId(UUID.randomUUID().toString());
                pairwiseIdentifier.setDn(this.pairwiseIdentifierService.getDnForPairwiseIdentifier(pairwiseIdentifier.getId(), userInum));
                this.pairwiseIdentifierService.addPairwiseIdentifier(userInum, pairwiseIdentifier);
            }
            jwt.getClaims().setSubjectIdentifier(pairwiseIdentifier.getId());
        } else {
            if (authorizationGrant.getClient().getSubjectType() != null && SubjectType.fromString((String)authorizationGrant.getClient().getSubjectType()).equals((Object)SubjectType.PAIRWISE)) {
                this.log.warn("Unable to calculate the pairwise subject identifier because the client hasn't a redirect uri. A public subject identifier will be used instead.");
            }
            String openidSubAttribute = this.appConfiguration.getOpenidSubAttribute();
            String subValue = authorizationGrant.getUser().getAttribute(openidSubAttribute);
            if (StringHelper.equalsIgnoreCase((String)openidSubAttribute, (String)"uid")) {
                subValue = authorizationGrant.getUser().getUserId();
            }
            jwt.getClaims().setSubjectIdentifier(subValue);
        }
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, (JsonWebResponse)jwt, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        if (this.cibaSupportProxy.isCIBASupported() && authorizationGrant instanceof CIBAGrant) {
            String refreshTokenHash = AbstractToken.getHash(refreshToken.getCode(), jwtSigner.getSignatureAlgorithm());
            jwt.getClaims().setClaim("urn:openid:params:jwt:claim:rt_hash", refreshTokenHash);
            CIBAGrant cibaGrant = (CIBAGrant)authorizationGrant;
            jwt.getClaims().setClaim("urn:openid:params:jwt:claim:auth_req_id", cibaGrant.getCIBAAuthenticationRequestId().getCode());
        }
        return jwtSigner.sign();
    }

    private void setAmrClaim(JsonWebResponse jwt, String acrValues) {
        ArrayList amrList = Lists.newArrayList();
        CustomScriptConfiguration script = this.externalAuthenticationService.getCustomScriptConfigurationByName(acrValues);
        if (script != null) {
            Map authenticationMethodClaimsOrNull;
            amrList.add(Integer.toString(script.getLevel()));
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)script.getExternalType();
            int apiVersion = externalAuthenticator.getApiVersion();
            if (apiVersion > 3 && (authenticationMethodClaimsOrNull = externalAuthenticator.getAuthenticationMethodClaims()) != null) {
                for (String key : authenticationMethodClaimsOrNull.keySet()) {
                    amrList.add(key + ":" + (String)authenticationMethodClaimsOrNull.get(key));
                }
            }
        }
        jwt.getClaims().setClaim("amr", (List)amrList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Jwe generateEncryptedIdToken(IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, String state, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        Jwe jwe = new Jwe();
        KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenEncryptedResponseAlg());
        BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenEncryptedResponseEnc());
        jwe.getHeader().setType(JwtType.JWT);
        jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
        jwe.getClaims().setIssuer(this.appConfiguration.getIssuer());
        jwe.getClaims().setAudience(authorizationGrant.getClient().getClientId());
        int lifeTime = this.appConfiguration.getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwe.getClaims().setExpirationTime(expiration);
        jwe.getClaims().setIssuedAt(issuedAt);
        if (preProcessing != null) {
            preProcessing.apply((Object)jwe);
        }
        if (authorizationGrant.getAcrValues() != null) {
            jwe.getClaims().setClaim("acr", authorizationGrant.getAcrValues());
            this.setAmrClaim((JsonWebResponse)jwe, authorizationGrant.getAcrValues());
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwe.getClaims().setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwe.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = AuthorizationCode.getHash(authorizationCode.getCode(), null);
            jwe.getClaims().setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = AccessToken.getHash(accessToken.getCode(), null);
            jwe.getClaims().setClaim("at_hash", accessTokenHash);
        }
        if (Strings.isNotBlank((String)state)) {
            String stateHash = AbstractToken.getHash(state, null);
            jwe.getClaims().setClaim("s_hash", stateHash);
        }
        jwe.getClaims().setClaim("oxOpenIDConnectVersion", this.appConfiguration.getOxOpenIdConnectVersion());
        User user = authorizationGrant.getUser();
        ArrayList<Scope> dynamicScopes = new ArrayList<Scope>();
        if (includeIdTokenClaims && authorizationGrant.getClient().isIncludeClaimsInIdToken()) {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeById(scopeName);
                if (scope != null && ScopeType.DYNAMIC == scope.getScopeType()) {
                    dynamicScopes.add(scope);
                    continue;
                }
                Map<String, Object> claims = this.getClaims(user, scope);
                if (Boolean.TRUE.equals(scope.isOxAuthGroupClaims())) {
                    JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                    groupClaim.setName(scope.getId());
                    for (Map.Entry<String, Object> entry : claims.entrySet()) {
                        String string = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof List) {
                            groupClaim.setClaim(string, (List)value);
                            continue;
                        }
                        groupClaim.setClaim(string, (String)value);
                    }
                    jwe.getClaims().setClaim(scope.getId(), groupClaim);
                } else {
                    for (Map.Entry entry : claims.entrySet()) {
                        String key = (String)entry.getKey();
                        Object v = entry.getValue();
                        if (v instanceof List) {
                            jwe.getClaims().setClaim(key, (List)v);
                            continue;
                        }
                        if (v instanceof Boolean) {
                            jwe.getClaims().setClaim(key, (Boolean)v);
                            continue;
                        }
                        if (v instanceof Date) {
                            jwe.getClaims().setClaim(key, Long.valueOf(((Date)v).getTime()));
                            continue;
                        }
                        jwe.getClaims().setClaim(key, (String)v);
                    }
                }
                jwe.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute("inum"));
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember().getClaims()) {
                Client client;
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null || !this.validateRequesteClaim(gluuAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes)) continue;
                String string = gluuAttribute.getName();
                Object attribute = authorizationGrant.getUser().getAttribute(string, optional, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                if (attribute == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jSONArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        String value = jSONArray.optString(i);
                        if (value == null) continue;
                        values.add(value);
                    }
                    jwe.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                String string2 = (String)attribute;
                jwe.getClaims().setClaim(claim.getName(), string2);
            }
        }
        if (authorizationGrant.getClient().getSubjectType() != null && SubjectType.fromString((String)authorizationGrant.getClient().getSubjectType()).equals((Object)SubjectType.PAIRWISE) && (StringUtils.isNotBlank((String)authorizationGrant.getClient().getSectorIdentifierUri()) || authorizationGrant.getClient().getRedirectUris() != null)) {
            String clientId;
            String sectorIdentifierUri = null;
            sectorIdentifierUri = StringUtils.isNotBlank((String)authorizationGrant.getClient().getSectorIdentifierUri()) ? authorizationGrant.getClient().getSectorIdentifierUri() : authorizationGrant.getClient().getRedirectUris()[0];
            String userInum = authorizationGrant.getUser().getAttribute("inum");
            PairwiseIdentifier pairwiseIdentifier = this.pairwiseIdentifierService.findPairWiseIdentifier(userInum, sectorIdentifierUri, clientId = authorizationGrant.getClientId());
            if (pairwiseIdentifier == null) {
                pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, clientId);
                pairwiseIdentifier.setId(UUID.randomUUID().toString());
                pairwiseIdentifier.setDn(this.pairwiseIdentifierService.getDnForPairwiseIdentifier(pairwiseIdentifier.getId(), userInum));
                this.pairwiseIdentifierService.addPairwiseIdentifier(userInum, pairwiseIdentifier);
            }
            jwe.getClaims().setSubjectIdentifier(pairwiseIdentifier.getId());
        } else {
            if (authorizationGrant.getClient().getSubjectType() != null && SubjectType.fromString((String)authorizationGrant.getClient().getSubjectType()).equals((Object)SubjectType.PAIRWISE)) {
                this.log.warn("Unable to calculate the pairwise subject identifier because the client hasn't a redirect uri. A public subject identifier will be used instead.");
            }
            String openidSubAttribute = this.appConfiguration.getOpenidSubAttribute();
            String subValue = authorizationGrant.getUser().getAttribute(openidSubAttribute);
            if (StringHelper.equalsIgnoreCase((String)openidSubAttribute, (String)"uid")) {
                subValue = authorizationGrant.getUser().getUserId();
            }
            jwe.getClaims().setSubjectIdentifier(subValue);
        }
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, (JsonWebResponse)jwe, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        if (this.cibaSupportProxy.isCIBASupported() && authorizationGrant instanceof CIBAGrant) {
            String refreshTokenHash = AbstractToken.getHash(refreshToken.getCode(), null);
            jwe.getClaims().setClaim("urn:openid:params:jwt:claim:rt_hash", refreshTokenHash);
            CIBAGrant cibaGrant = (CIBAGrant)authorizationGrant;
            jwe.getClaims().setClaim("urn:openid:params:jwt:claim:auth_req_id", cibaGrant.getCIBAAuthenticationRequestId().getCode());
        }
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            JSONObject jsonWebKeys = JwtUtil.getJSONWebKeys((String)authorizationGrant.getClient().getJwksUri());
            String keyId = this.cryptoProvider.getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyEncryptionAlgorithm.getName()), Use.ENCRYPTION);
            PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId, jsonWebKeys);
            jwe.getHeader().setKeyId(keyId);
            if (publicKey == null) throw new InvalidJweException("The public key is not valid");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, publicKey);
            return jweEncrypter.encrypt(jwe);
        }
        if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A128KW) {
            if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A256KW) return jwe;
        }
        try {
            byte[] sharedSymmetricKey = this.clientService.decryptSecret(authorizationGrant.getClient().getClientSecret()).getBytes("UTF-8");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedSymmetricKey);
            return jweEncrypter.encrypt(jwe);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJweException((Throwable)e);
        }
    }

    public JsonWebResponse createJwr(IAuthorizationGrant grant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, String state, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        Client grantClient = grant.getClient();
        if (grantClient != null && grantClient.getIdTokenEncryptedResponseAlg() != null && grantClient.getIdTokenEncryptedResponseEnc() != null) {
            return this.generateEncryptedIdToken(grant, nonce, authorizationCode, accessToken, refreshToken, state, scopes, includeIdTokenClaims, preProcessing);
        }
        return this.generateSignedIdToken(grant, nonce, authorizationCode, accessToken, refreshToken, state, scopes, includeIdTokenClaims, preProcessing);
    }

    public boolean validateRequesteClaim(GluuAttribute gluuAttribute, String[] clientAllowedClaims, Collection<String> scopes) {
        if (gluuAttribute != null) {
            if (clientAllowedClaims != null) {
                for (int i = 0; i < clientAllowedClaims.length; ++i) {
                    if (!gluuAttribute.getDn().equals(clientAllowedClaims[i])) continue;
                    return true;
                }
            }
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeById(scopeName);
                if (scope == null || scope.getOxAuthClaims() == null) continue;
                for (String claimDn : scope.getOxAuthClaims()) {
                    if (!gluuAttribute.getDisplayName().equals(this.attributeService.getAttributeByDn(claimDn).getDisplayName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Map<String, Object> getClaims(User user, Scope scope) throws InvalidClaimException, ParseException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (scope != null && scope.getOxAuthClaims() != null) {
            for (String claimDn : scope.getOxAuthClaims()) {
                GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                String claimName = gluuAttribute.getOxAuthClaimName();
                String ldapName = gluuAttribute.getName();
                Object attribute = null;
                if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
                if (ldapName.equals("uid")) {
                    attribute = user.getUserId();
                } else if (AttributeDataType.BOOLEAN.equals((Object)gluuAttribute.getDataType())) {
                    attribute = Boolean.parseBoolean(String.valueOf(user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue())));
                } else if (AttributeDataType.DATE.equals((Object)gluuAttribute.getDataType())) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
                    Object attributeValue = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                    if (attributeValue != null) {
                        attribute = format.parse(attributeValue.toString());
                    }
                } else {
                    attribute = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                }
                if (attribute == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value = jsonArray.optString(i);
                        if (value == null) continue;
                        values.add(value);
                    }
                    claims.put(claimName, values);
                    continue;
                }
                claims.put(claimName, attribute);
            }
        }
        return claims;
    }
}

